/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.json.TicketValidationJsonResponse;

final class JsonValidationResponseParser {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonValidationResponseParser() {
        this.objectMapper.findAndRegisterModules();
    }

    public TicketValidationJsonResponse parse(String response) throws TicketValidationException, IOException {
        if (CommonUtils.isBlank(response)) {
            throw new TicketValidationException("Invalid JSON response; The response is empty");
        }
        TicketValidationJsonResponse json = this.objectMapper.readValue(response, TicketValidationJsonResponse.class);
        TicketValidationJsonResponse.CasServiceResponseAuthentication serviceResponse = json.getServiceResponse();
        if (serviceResponse.getAuthenticationFailure() != null && serviceResponse.getAuthenticationSuccess() != null) {
            throw new TicketValidationException("Invalid JSON response; It indicates both a success and a failure event, which is indicative of a server error. The actual response is " + response);
        }
        if (serviceResponse.getAuthenticationFailure() != null) {
            String error2 = json.getServiceResponse().getAuthenticationFailure().getCode() + " - " + serviceResponse.getAuthenticationFailure().getDescription();
            throw new TicketValidationException(error2);
        }
        String principal = json.getServiceResponse().getAuthenticationSuccess().getUser();
        if (CommonUtils.isEmpty(principal)) {
            throw new TicketValidationException("No principal was found in the response from the CAS server.");
        }
        return json;
    }
}

