/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.NamespaceContext;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.IOUtils;
import org.jasig.cas.client.util.MapNamespaceContext;
import org.jasig.cas.client.util.SamlUtils;
import org.jasig.cas.client.util.ThreadLocalXPathExpression;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Saml11TicketValidator
extends AbstractUrlBasedTicketValidator {
    public static final String AUTH_METHOD_ATTRIBUTE = "samlAuthenticationStatement::authMethod";
    private static final String SAML_REQUEST_TEMPLATE;
    private static final NamespaceContext NS_CONTEXT;
    private static final ThreadLocalXPathExpression XPATH_ASSERTION_DATE_START;
    private static final ThreadLocalXPathExpression XPATH_ASSERTION_DATE_END;
    private static final ThreadLocalXPathExpression XPATH_NAME_ID;
    private static final ThreadLocalXPathExpression XPATH_AUTH_METHOD;
    private static final ThreadLocalXPathExpression XPATH_ATTRIBUTES;
    private static final String HEX_CHARS = "0123456789abcdef";
    private long tolerance = 1000L;
    private final Random random;

    public Saml11TicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalStateException("Cannot find required SHA1PRNG algorithm");
        }
    }

    @Override
    protected String getUrlSuffix() {
        return "samlValidate";
    }

    @Override
    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
        String service = urlParameters.get("service");
        urlParameters.remove("service");
        urlParameters.remove("ticket");
        urlParameters.put("TARGET", service);
    }

    @Override
    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        try {
            Document document = XmlUtils.newDocument(response);
            Date assertionValidityStart = SamlUtils.parseUtcDate(XPATH_ASSERTION_DATE_START.evaluateAsString(document));
            Date assertionValidityEnd = SamlUtils.parseUtcDate(XPATH_ASSERTION_DATE_END.evaluateAsString(document));
            if (!this.isValidAssertion(assertionValidityStart, assertionValidityEnd)) {
                throw new TicketValidationException("Invalid SAML assertion");
            }
            String nameId = XPATH_NAME_ID.evaluateAsString(document);
            if (nameId == null) {
                throw new TicketValidationException("SAML assertion does not contain NameIdentifier element");
            }
            String authMethod = XPATH_AUTH_METHOD.evaluateAsString(document);
            NodeList attributes = XPATH_ATTRIBUTES.evaluateAsNodeList(document);
            HashMap<String, Object> principalAttributes = new HashMap<String, Object>(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                Element attribute = (Element)attributes.item(i);
                String name2 = attribute.getAttribute("AttributeName");
                this.logger.trace("Processing attribute {}", (Object)name2);
                NodeList values2 = attribute.getElementsByTagNameNS("*", "AttributeValue");
                if (values2.getLength() == 1) {
                    principalAttributes.put(name2, values2.item(0).getTextContent());
                    continue;
                }
                ArrayList<String> items = new ArrayList<String>(values2.getLength());
                for (int j = 0; j < values2.getLength(); ++j) {
                    items.add(values2.item(j).getTextContent());
                }
                principalAttributes.put(name2, items);
            }
            return new AssertionImpl(new AttributePrincipalImpl(nameId, principalAttributes), assertionValidityStart, assertionValidityEnd, new Date(), Collections.singletonMap(AUTH_METHOD_ATTRIBUTE, authMethod));
        }
        catch (Exception e2) {
            throw new TicketValidationException("Error processing SAML response", e2);
        }
    }

    private boolean isValidAssertion(Date notBefore, Date notOnOrAfter) {
        if (notBefore == null || notOnOrAfter == null) {
            this.logger.debug("Assertion is not valid because it does not have bounding dates.");
            return false;
        }
        DateTime currentTime = new DateTime(DateTimeZone.UTC);
        Interval validityRange = new Interval((ReadableInstant)new DateTime(notBefore).minus(this.tolerance), (ReadableInstant)new DateTime(notOnOrAfter).plus(this.tolerance));
        if (validityRange.contains(currentTime)) {
            this.logger.debug("Current time is within the interval validity.");
            return true;
        }
        if (currentTime.isBefore(validityRange.getStart())) {
            this.logger.debug("Assertion is not yet valid");
        } else {
            this.logger.debug("Assertion is expired");
        }
        return false;
    }

    @Override
    protected String retrieveResponseFromServer(URL validationUrl, String ticket) {
        String request = String.format(SAML_REQUEST_TEMPLATE, this.generateId(), SamlUtils.formatForUtcTime(new Date()), ticket);
        HttpURLConnection conn = null;
        try {
            conn = this.getURLConnectionFactory().buildHttpURLConnection(validationUrl.openConnection());
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            Charset charset = CommonUtils.isNotBlank(this.getEncoding()) ? Charset.forName(this.getEncoding()) : IOUtils.UTF8;
            conn.getOutputStream().write(request.getBytes(charset));
            String string2 = IOUtils.readString(conn.getInputStream(), charset);
            return string2;
        }
        catch (IOException e2) {
            throw new RuntimeException("IO error sending HTTP request to /samlValidate", e2);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }

    private String generateId() {
        byte[] data2 = new byte[16];
        this.random.nextBytes(data2);
        StringBuilder id = new StringBuilder(33);
        id.append('_');
        for (int i = 0; i < data2.length; ++i) {
            id.append(HEX_CHARS.charAt((data2[i] & 0xF0) >> 4));
            id.append(HEX_CHARS.charAt(data2[i] & 0xF));
        }
        return id.toString();
    }

    static {
        NS_CONTEXT = new MapNamespaceContext("soap->http://schemas.xmlsoap.org/soap/envelope/", "sa->urn:oasis:names:tc:SAML:1.0:assertion", "sp->urn:oasis:names:tc:SAML:1.0:protocol");
        XPATH_ASSERTION_DATE_START = new ThreadLocalXPathExpression("//sa:Assertion/sa:Conditions/@NotBefore", NS_CONTEXT);
        XPATH_ASSERTION_DATE_END = new ThreadLocalXPathExpression("//sa:Assertion/sa:Conditions/@NotOnOrAfter", NS_CONTEXT);
        XPATH_NAME_ID = new ThreadLocalXPathExpression("//sa:AuthenticationStatement/sa:Subject/sa:NameIdentifier", NS_CONTEXT);
        XPATH_AUTH_METHOD = new ThreadLocalXPathExpression("//sa:AuthenticationStatement/@AuthenticationMethod", NS_CONTEXT);
        XPATH_ATTRIBUTES = new ThreadLocalXPathExpression("//sa:AttributeStatement/sa:Attribute", NS_CONTEXT);
        try {
            SAML_REQUEST_TEMPLATE = IOUtils.readString(Saml11TicketValidator.class.getResourceAsStream("/META-INF/cas/samlRequestTemplate.xml"));
        }
        catch (IOException e2) {
            throw new IllegalStateException("Cannot load SAML request template from classpath", e2);
        }
    }
}

