/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUrlBasedTicketValidator
implements TicketValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpURLConnectionFactory urlConnectionFactory = new HttpsURLConnectionFactory();
    private final String casServerUrlPrefix;
    private boolean renew;
    private Map<String, String> customParameters;
    private String encoding;

    protected AbstractUrlBasedTicketValidator(String casServerUrlPrefix) {
        CommonUtils.assertNotNull(casServerUrlPrefix, "casServerUrlPrefix cannot be null.");
        this.casServerUrlPrefix = CommonUtils.addTrailingSlash(casServerUrlPrefix);
    }

    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
    }

    protected abstract String getUrlSuffix();

    protected final String constructValidationUrl(String ticket, String serviceUrl) {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        this.logger.debug("Placing URL parameters in map.");
        urlParameters.put("ticket", ticket);
        urlParameters.put("service", serviceUrl);
        if (this.renew) {
            urlParameters.put("renew", "true");
        }
        this.logger.debug("Calling template URL attribute map.");
        this.populateUrlAttributeMap(urlParameters);
        this.logger.debug("Loading custom parameters from configuration.");
        if (this.customParameters != null) {
            urlParameters.putAll(this.customParameters);
        }
        String suffix = this.getUrlSuffix();
        StringBuilder buffer = new StringBuilder(urlParameters.size() * 10 + this.casServerUrlPrefix.length() + suffix.length() + 1);
        int i = 0;
        buffer.append(this.casServerUrlPrefix);
        buffer.append(suffix);
        for (Map.Entry entry : urlParameters.entrySet()) {
            String key2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            buffer.append(i++ == 0 ? "?" : "&");
            buffer.append(key2);
            buffer.append("=");
            String encodedValue = this.encodeUrl(value);
            buffer.append(encodedValue);
        }
        return buffer.toString();
    }

    protected final String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return url;
        }
    }

    protected abstract Assertion parseResponseFromServer(String var1) throws TicketValidationException;

    protected abstract String retrieveResponseFromServer(URL var1, String var2);

    @Override
    public final Assertion validate(String ticket, String service) throws TicketValidationException {
        String validationUrl = this.constructValidationUrl(ticket, service);
        this.logger.debug("Constructing validation url: {}", (Object)validationUrl);
        try {
            this.logger.debug("Retrieving response from server.");
            String serverResponse = this.retrieveResponseFromServer(new URL(validationUrl), ticket);
            if (serverResponse == null) {
                throw new TicketValidationException("The CAS server returned no response.");
            }
            this.logger.debug("Server response: {}", (Object)serverResponse);
            return this.parseResponseFromServer(serverResponse);
        }
        catch (MalformedURLException e2) {
            throw new TicketValidationException(e2);
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public final void setEncoding(String encoding2) {
        this.encoding = encoding2;
    }

    protected final String getEncoding() {
        return this.encoding;
    }

    protected final boolean isRenew() {
        return this.renew;
    }

    protected final String getCasServerUrlPrefix() {
        return this.casServerUrlPrefix;
    }

    protected final Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    protected HttpURLConnectionFactory getURLConnectionFactory() {
        return this.urlConnectionFactory;
    }

    public void setURLConnectionFactory(HttpURLConnectionFactory urlConnectionFactory) {
        this.urlConnectionFactory = urlConnectionFactory;
    }
}

