/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public final class ReflectUtils {
    private ReflectUtils() {
    }

    public static <T> Class<T> loadClass(String className) throws IllegalArgumentException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException(className + " class not found.");
        }
    }

    public static <T> T newInstance(String className, Object ... args2) {
        return ReflectUtils.newInstance(ReflectUtils.loadClass(className), args2);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args2) {
        Class[] argClasses = new Class[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            argClasses[i] = args2[i].getClass();
        }
        try {
            return clazz.getConstructor(argClasses).newInstance(args2);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Error creating new instance of " + clazz, e2);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        try {
            return ReflectUtils.getPropertyDescriptor(Introspector.getBeanInfo(clazz), propertyName);
        }
        catch (IntrospectionException e2) {
            throw new RuntimeException("Failed getting bean info for " + clazz, e2);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(BeanInfo info2, String propertyName) {
        for (int i = 0; i < info2.getPropertyDescriptors().length; ++i) {
            PropertyDescriptor pd = info2.getPropertyDescriptors()[i];
            if (!pd.getName().equals(propertyName)) continue;
            return pd;
        }
        return null;
    }

    public static void setProperty(String propertyName, Object value, Object target) {
        try {
            ReflectUtils.setProperty(propertyName, value, target, Introspector.getBeanInfo(target.getClass()));
        }
        catch (IntrospectionException e2) {
            throw new RuntimeException("Failed getting bean info on target JavaBean " + target, e2);
        }
    }

    public static void setProperty(String propertyName, Object value, Object target, BeanInfo info2) {
        try {
            PropertyDescriptor pd = ReflectUtils.getPropertyDescriptor(info2, propertyName);
            pd.getWriteMethod().invoke(target, value);
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException("Error setting property " + propertyName, e2.getCause());
        }
        catch (Exception e3) {
            throw new RuntimeException("Error setting property " + propertyName, e3);
        }
    }

    public static Object getField(String fieldName, Object target) {
        Class<?> clazz = target.getClass();
        Field field = null;
        do {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                clazz = clazz.getSuperclass();
            }
        } while (field == null && clazz != null);
        if (field == null) {
            throw new IllegalArgumentException(fieldName + " does not exist on " + target);
        }
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(target);
        }
        catch (Exception e3) {
            throw new IllegalArgumentException("Error getting field " + fieldName, e3);
        }
    }
}

