/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private IOUtils() {
    }

    public static String readString(InputStream in) throws IOException {
        return IOUtils.readString(in, UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream in, Charset charset) throws IOException {
        InputStreamReader reader2 = new InputStreamReader(in, charset);
        StringBuilder builder = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(2048);
        try {
            while (((Reader)reader2).read(buffer) > -1) {
                buffer.flip();
                builder.append(buffer);
            }
        }
        finally {
            IOUtils.closeQuietly(reader2);
        }
        return builder.toString();
    }

    public static void closeQuietly(Closeable resource2) {
        try {
            if (resource2 != null) {
                resource2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

