/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelegatingFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String requestParameterName;
    private final Map<String, Filter> delegators;
    private final Filter defaultFilter;
    private final boolean exactMatch;

    public DelegatingFilter(String requestParameterName, Map<String, Filter> delegators, boolean exactMatch) {
        this(requestParameterName, delegators, exactMatch, null);
    }

    public DelegatingFilter(String requestParameterName, Map<String, Filter> delegators, boolean exactMatch, Filter defaultFilter) {
        CommonUtils.assertNotNull(requestParameterName, "requestParameterName cannot be null.");
        CommonUtils.assertTrue(!delegators.isEmpty(), "delegators cannot be empty.");
        this.requestParameterName = requestParameterName;
        this.delegators = delegators;
        this.defaultFilter = defaultFilter;
        this.exactMatch = exactMatch;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String parameter = CommonUtils.safeGetParameter((HttpServletRequest)request, this.requestParameterName);
        if (CommonUtils.isNotEmpty(parameter)) {
            for (String key2 : this.delegators.keySet()) {
                if ((!parameter.equals(key2) || !this.exactMatch) && (!parameter.matches(key2) || this.exactMatch)) continue;
                Filter filter2 = this.delegators.get(key2);
                this.logger.debug("Match found for parameter [{}] with value [{}]. Delegating to filter [{}]", this.requestParameterName, parameter, filter2.getClass().getName());
                filter2.doFilter(request, response, filterChain);
                return;
            }
        }
        this.logger.debug("No match found for parameter [{}] with value [{}]", (Object)this.requestParameterName, (Object)parameter);
        if (this.defaultFilter != null) {
            this.defaultFilter.doFilter(request, response, filterChain);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

