/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jasig.cas.client.ssl.AnyHostnameVerifier;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpsURLConnectionFactory
implements HttpURLConnectionFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsURLConnectionFactory.class);
    private HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private Properties sslConfiguration = new Properties();

    public HttpsURLConnectionFactory() {
    }

    public HttpsURLConnectionFactory(HostnameVerifier verifier, Properties config) {
        this.setHostnameVerifier(verifier);
        this.setSSLConfiguration(config);
    }

    public final void setSSLConfiguration(Properties config) {
        this.sslConfiguration = config;
    }

    public final void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    @Override
    public HttpURLConnection buildHttpURLConnection(URLConnection url) {
        return this.configureHttpsConnectionIfNeeded(url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpsURLConnectionFactory that = (HttpsURLConnectionFactory)o;
        if (!this.hostnameVerifier.equals(that.hostnameVerifier)) {
            return false;
        }
        return this.sslConfiguration.equals(that.sslConfiguration);
    }

    public int hashCode() {
        int result2 = this.hostnameVerifier.hashCode();
        result2 = 31 * result2 + this.sslConfiguration.hashCode();
        return result2;
    }

    private HttpURLConnection configureHttpsConnectionIfNeeded(URLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
            SSLSocketFactory socketFactory = this.createSSLSocketFactory();
            if (socketFactory != null) {
                httpsConnection.setSSLSocketFactory(socketFactory);
            }
            if (this.isIgnoreSslFailures()) {
                httpsConnection.setHostnameVerifier(new AnyHostnameVerifier());
            } else if (this.hostnameVerifier != null) {
                httpsConnection.setHostnameVerifier(this.hostnameVerifier);
            }
        }
        return (HttpURLConnection)conn;
    }

    private boolean isIgnoreSslFailures() {
        return this.sslConfiguration.getProperty("ignoreSslFailures", "false").equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory createSSLSocketFactory() {
        FileInputStream keyStoreIS = null;
        try {
            SSLContext sslContext = SSLContext.getInstance(this.sslConfiguration.getProperty("protocol", "SSL"));
            if (this.isIgnoreSslFailures()) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
                return sSLSocketFactory;
            }
            if (this.sslConfiguration.getProperty("keyStoreType") != null) {
                KeyStore keyStore = KeyStore.getInstance(this.sslConfiguration.getProperty("keyStoreType"));
                if (this.sslConfiguration.getProperty("keyStorePath") != null) {
                    keyStoreIS = new FileInputStream(this.sslConfiguration.getProperty("keyStorePath"));
                    if (this.sslConfiguration.getProperty("keyStorePass") != null) {
                        keyStore.load(keyStoreIS, this.sslConfiguration.getProperty("keyStorePass").toCharArray());
                        LOGGER.debug("Keystore has {} keys", (Object)keyStore.size());
                        KeyManagerFactory keyManager = KeyManagerFactory.getInstance(this.sslConfiguration.getProperty("keyManagerType", "SunX509"));
                        keyManager.init(keyStore, this.sslConfiguration.getProperty("certificatePassword").toCharArray());
                        sslContext.init(keyManager.getKeyManagers(), null, null);
                        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
                        CommonUtils.closeQuietly(keyStoreIS);
                        return sSLSocketFactory;
                    }
                }
            }
            CommonUtils.closeQuietly(keyStoreIS);
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage(), e2);
        }
        finally {
            CommonUtils.closeQuietly(keyStoreIS);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.hostnameVerifier == HttpsURLConnection.getDefaultHostnameVerifier()) {
            out.writeObject(null);
        } else {
            out.writeObject(this.hostnameVerifier);
        }
        out.writeObject(this.sslConfiguration);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object internalHostNameVerifier = in.readObject();
        this.hostnameVerifier = internalHostNameVerifier == null ? HttpsURLConnection.getDefaultHostnameVerifier() : (HostnameVerifier)internalHostNameVerifier;
        this.sslConfiguration = (Properties)in.readObject();
    }
}

