/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DatatypeConverter;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleSignOutHandler {
    private static final int DECOMPRESSION_FACTOR = 10;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = Protocol.CAS2.getArtifactParameterName();
    private String logoutParameterName = ConfigurationKeys.LOGOUT_PARAMETER_NAME.getDefaultValue();
    private String relayStateParameterName = ConfigurationKeys.RELAY_STATE_PARAMETER_NAME.getDefaultValue();
    private String logoutCallbackPath;
    private boolean artifactParameterOverPost = false;
    private boolean eagerlyCreateSessions = true;
    private List<String> safeParameters;
    private final LogoutStrategy logoutStrategy = SingleSignOutHandler.isServlet30() ? new Servlet30LogoutStrategy() : new Servlet25LogoutStrategy();

    public void setSessionMappingStorage(SessionMappingStorage storage2) {
        this.sessionMappingStorage = storage2;
    }

    public void setArtifactParameterOverPost(boolean artifactParameterOverPost) {
        this.artifactParameterOverPost = artifactParameterOverPost;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setArtifactParameterName(String name2) {
        this.artifactParameterName = name2;
    }

    public void setLogoutParameterName(String name2) {
        this.logoutParameterName = name2;
    }

    public void setLogoutCallbackPath(String logoutCallbackPath) {
        this.logoutCallbackPath = logoutCallbackPath;
    }

    public void setRelayStateParameterName(String name2) {
        this.relayStateParameterName = name2;
    }

    public void setEagerlyCreateSessions(boolean eagerlyCreateSessions) {
        this.eagerlyCreateSessions = eagerlyCreateSessions;
    }

    public synchronized void init() {
        if (this.safeParameters == null) {
            CommonUtils.assertNotNull(this.artifactParameterName, "artifactParameterName cannot be null.");
            CommonUtils.assertNotNull(this.logoutParameterName, "logoutParameterName cannot be null.");
            CommonUtils.assertNotNull(this.sessionMappingStorage, "sessionMappingStorage cannot be null.");
            CommonUtils.assertNotNull(this.relayStateParameterName, "relayStateParameterName cannot be null.");
            this.safeParameters = this.artifactParameterOverPost ? Arrays.asList(this.logoutParameterName, this.artifactParameterName) : Collections.singletonList(this.logoutParameterName);
        }
    }

    private boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.artifactParameterName, this.safeParameters));
    }

    private boolean isLogoutRequest(HttpServletRequest request) {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            return !this.isMultipartRequest(request) && this.pathEligibleForLogout(request) && CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
        }
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
        }
        return false;
    }

    private boolean pathEligibleForLogout(HttpServletRequest request) {
        return this.logoutCallbackPath == null || this.logoutCallbackPath.equals(this.getPath(request));
    }

    private String getPath(HttpServletRequest request) {
        return request.getServletPath() + CommonUtils.nullToEmpty(request.getPathInfo());
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response) {
        if (this.isTokenRequest(request)) {
            this.logger.trace("Received a token request");
            this.recordSession(request);
            return true;
        }
        if (this.isLogoutRequest(request)) {
            this.logger.trace("Received a logout request");
            this.destroySession(request);
            return false;
        }
        this.logger.trace("Ignoring URI for logout: {}", (Object)request.getRequestURI());
        return true;
    }

    private void recordSession(HttpServletRequest request) {
        HttpSession session = request.getSession(this.eagerlyCreateSessions);
        if (session == null) {
            this.logger.debug("No session currently exists (and none created).  Cannot record session information for single sign out.");
            return;
        }
        String token2 = CommonUtils.safeGetParameter(request, this.artifactParameterName, this.safeParameters);
        this.logger.debug("Recording session for token {}", (Object)token2);
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(token2, session);
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = DatatypeConverter.parseBase64Binary((String)originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result2 = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result2);
            String string2 = new String(result2, 0, resultLength, "UTF-8");
            return string2;
        }
        catch (Exception e2) {
            this.logger.error("Unable to decompress logout message", e2);
            throw new RuntimeException(e2);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    private void destroySession(HttpServletRequest request) {
        HttpSession session;
        String logoutMessage = CommonUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters);
        if (CommonUtils.isBlank(logoutMessage)) {
            this.logger.error("Could not locate logout message of the request from {}", (Object)this.logoutParameterName);
            return;
        }
        if (!logoutMessage.contains("SessionIndex")) {
            logoutMessage = this.uncompressLogoutMessage(logoutMessage);
        }
        this.logger.trace("Logout request:\n{}", (Object)logoutMessage);
        String token2 = XmlUtils.getTextForElement(logoutMessage, "SessionIndex");
        if (CommonUtils.isNotBlank(token2) && (session = this.sessionMappingStorage.removeSessionByMappingId(token2)) != null) {
            String sessionID = session.getId();
            this.logger.debug("Invalidating session [{}] for token [{}]", (Object)sessionID, (Object)token2);
            try {
                session.invalidate();
            }
            catch (IllegalStateException e2) {
                this.logger.debug("Error invalidating session.", e2);
            }
            this.logoutStrategy.logout(request);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }

    private static boolean isServlet30() {
        try {
            return HttpServletRequest.class.getMethod("logout", new Class[0]) != null;
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
    }

    private class Servlet30LogoutStrategy
    implements LogoutStrategy {
        private Servlet30LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
            try {
                request.logout();
            }
            catch (ServletException e2) {
                SingleSignOutHandler.this.logger.debug("Error performing request.logout.");
            }
        }
    }

    private class Servlet25LogoutStrategy
    implements LogoutStrategy {
        private Servlet25LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
        }
    }

    private static interface LogoutStrategy {
        public void logout(HttpServletRequest var1);
    }
}

