/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.session;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutHandler;
import org.jasig.cas.client.util.AbstractConfigurationFilter;

public final class SingleSignOutFilter
extends AbstractConfigurationFilter {
    private static final SingleSignOutHandler HANDLER = new SingleSignOutHandler();
    private final AtomicBoolean handlerInitialized = new AtomicBoolean(false);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!this.isIgnoreInitConfiguration()) {
            this.setArtifactParameterName(this.getString(ConfigurationKeys.ARTIFACT_PARAMETER_NAME));
            this.setLogoutParameterName(this.getString(ConfigurationKeys.LOGOUT_PARAMETER_NAME));
            this.setRelayStateParameterName(this.getString(ConfigurationKeys.RELAY_STATE_PARAMETER_NAME));
            this.setLogoutCallbackPath(this.getString(ConfigurationKeys.LOGOUT_CALLBACK_PATH));
            HANDLER.setArtifactParameterOverPost(this.getBoolean(ConfigurationKeys.ARTIFACT_PARAMETER_OVER_POST));
            HANDLER.setEagerlyCreateSessions(this.getBoolean(ConfigurationKeys.EAGERLY_CREATE_SESSIONS));
        }
        HANDLER.init();
        this.handlerInitialized.set(true);
    }

    public void setArtifactParameterName(String name2) {
        HANDLER.setArtifactParameterName(name2);
    }

    public void setLogoutParameterName(String name2) {
        HANDLER.setLogoutParameterName(name2);
    }

    public void setRelayStateParameterName(String name2) {
        HANDLER.setRelayStateParameterName(name2);
    }

    public void setLogoutCallbackPath(String logoutCallbackPath) {
        HANDLER.setLogoutCallbackPath(logoutCallbackPath);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage2) {
        HANDLER.setSessionMappingStorage(storage2);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.handlerInitialized.getAndSet(true)) {
            HANDLER.init();
        }
        if (HANDLER.process(request, response)) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    protected static SingleSignOutHandler getSingleSignOutHandler() {
        return HANDLER;
    }
}

