/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.anssi.ANSSINamedCurves;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String string2) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByName(string2);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = NISTNamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByName(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECGOST3410NamedCurves.getByNameX9(string2);
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByName(string2);
        }
        return x9ECParameters;
    }

    public static ASN1ObjectIdentifier getOID(String string2) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = X962NamedCurves.getOID(string2);
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = SECNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = NISTNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = TeleTrusTNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ANSSINamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = GMNamedCurves.getOID(string2);
        }
        if (aSN1ObjectIdentifier == null && string2.equals("curve25519")) {
            aSN1ObjectIdentifier = CryptlibObjectIdentifiers.curvey25519;
        }
        return aSN1ObjectIdentifier;
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string2 = X962NamedCurves.getName(aSN1ObjectIdentifier);
        if (string2 == null) {
            string2 = SECNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = NISTNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = TeleTrusTNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = ANSSINamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = ECGOST3410NamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = GMNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string2 == null) {
            string2 = CustomNamedCurves.getName(aSN1ObjectIdentifier);
        }
        return string2;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECGOST3410NamedCurves.getByOIDX9(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    public static Enumeration getNames() {
        Vector vector2 = new Vector();
        ECNamedCurveTable.addEnumeration(vector2, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector2, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector2, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector2, TeleTrusTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector2, ANSSINamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector2, ECGOST3410NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector2, GMNamedCurves.getNames());
        return vector2.elements();
    }

    private static void addEnumeration(Vector vector2, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
    }
}

