/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class Nysiis
implements StringEncoder {
    private static final char[] CHARS_A = new char[]{'A'};
    private static final char[] CHARS_AF = new char[]{'A', 'F'};
    private static final char[] CHARS_C = new char[]{'C'};
    private static final char[] CHARS_FF = new char[]{'F', 'F'};
    private static final char[] CHARS_G = new char[]{'G'};
    private static final char[] CHARS_N = new char[]{'N'};
    private static final char[] CHARS_NN = new char[]{'N', 'N'};
    private static final char[] CHARS_S = new char[]{'S'};
    private static final char[] CHARS_SSS = new char[]{'S', 'S', 'S'};
    private static final Pattern PAT_MAC = Pattern.compile("^MAC");
    private static final Pattern PAT_KN = Pattern.compile("^KN");
    private static final Pattern PAT_K = Pattern.compile("^K");
    private static final Pattern PAT_PH_PF = Pattern.compile("^(PH|PF)");
    private static final Pattern PAT_SCH = Pattern.compile("^SCH");
    private static final Pattern PAT_EE_IE = Pattern.compile("(EE|IE)$");
    private static final Pattern PAT_DT_ETC = Pattern.compile("(DT|RT|RD|NT|ND)$");
    private static final char SPACE = ' ';
    private static final int TRUE_LENGTH = 6;
    private final boolean strict;

    private static boolean isVowel(char c) {
        return c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U';
    }

    private static char[] transcodeRemaining(char prev2, char curr, char next2, char aNext) {
        if (curr == 'E' && next2 == 'V') {
            return CHARS_AF;
        }
        if (Nysiis.isVowel(curr)) {
            return CHARS_A;
        }
        if (curr == 'Q') {
            return CHARS_G;
        }
        if (curr == 'Z') {
            return CHARS_S;
        }
        if (curr == 'M') {
            return CHARS_N;
        }
        if (curr == 'K') {
            if (next2 == 'N') {
                return CHARS_NN;
            }
            return CHARS_C;
        }
        if (curr == 'S' && next2 == 'C' && aNext == 'H') {
            return CHARS_SSS;
        }
        if (curr == 'P' && next2 == 'H') {
            return CHARS_FF;
        }
        if (!(curr != 'H' || Nysiis.isVowel(prev2) && Nysiis.isVowel(next2))) {
            return new char[]{prev2};
        }
        if (curr == 'W' && Nysiis.isVowel(prev2)) {
            return new char[]{prev2};
        }
        return new char[]{curr};
    }

    public Nysiis() {
        this(true);
    }

    public Nysiis(boolean strict) {
        this.strict = strict;
    }

    @Override
    public Object encode(Object obj2) throws EncoderException {
        if (!(obj2 instanceof String)) {
            throw new EncoderException("Parameter supplied to Nysiis encode is not of type java.lang.String");
        }
        return this.nysiis((String)obj2);
    }

    @Override
    public String encode(String str2) {
        return this.nysiis(str2);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String nysiis(String str2) {
        if (str2 == null) {
            return null;
        }
        if ((str2 = SoundexUtils.clean(str2)).length() == 0) {
            return str2;
        }
        str2 = PAT_MAC.matcher(str2).replaceFirst("MCC");
        str2 = PAT_KN.matcher(str2).replaceFirst("NN");
        str2 = PAT_K.matcher(str2).replaceFirst("C");
        str2 = PAT_PH_PF.matcher(str2).replaceFirst("FF");
        str2 = PAT_SCH.matcher(str2).replaceFirst("SSS");
        str2 = PAT_EE_IE.matcher(str2).replaceFirst("Y");
        str2 = PAT_DT_ETC.matcher(str2).replaceFirst("D");
        StringBuilder key2 = new StringBuilder(str2.length());
        key2.append(str2.charAt(0));
        char[] chars2 = str2.toCharArray();
        int len = chars2.length;
        for (int i = 1; i < len; ++i) {
            char next2 = i < len - 1 ? chars2[i + 1] : (char)' ';
            char aNext = i < len - 2 ? chars2[i + 2] : (char)' ';
            char[] transcoded = Nysiis.transcodeRemaining(chars2[i - 1], chars2[i], next2, aNext);
            System.arraycopy(transcoded, 0, chars2, i, transcoded.length);
            if (chars2[i] == chars2[i - 1]) continue;
            key2.append(chars2[i]);
        }
        if (key2.length() > 1) {
            char last2Char;
            char lastChar = key2.charAt(key2.length() - 1);
            if (lastChar == 'S') {
                key2.deleteCharAt(key2.length() - 1);
                lastChar = key2.charAt(key2.length() - 1);
            }
            if (key2.length() > 2 && (last2Char = key2.charAt(key2.length() - 2)) == 'A' && lastChar == 'Y') {
                key2.deleteCharAt(key2.length() - 2);
            }
            if (lastChar == 'A') {
                key2.deleteCharAt(key2.length() - 1);
            }
        }
        String string2 = key2.toString();
        return this.isStrict() ? string2.substring(0, Math.min(6, string2.length())) : string2;
    }
}

