/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.binary.StringUtils;

public final class MurmurHash2 {
    private static final int M32 = 1540483477;
    private static final int R32 = 24;
    private static final long M64 = -4132994306676758123L;
    private static final int R64 = 47;

    private MurmurHash2() {
    }

    public static int hash32(byte[] data2, int length, int seed) {
        int h2 = seed ^ length;
        int nblocks = length >> 2;
        for (int i = 0; i < nblocks; ++i) {
            int index2 = i << 2;
            int k = MurmurHash2.getLittleEndianInt(data2, index2);
            k *= 1540483477;
            k ^= k >>> 24;
            h2 *= 1540483477;
            h2 ^= (k *= 1540483477);
        }
        int index3 = nblocks << 2;
        switch (length - index3) {
            case 3: {
                h2 ^= (data2[index3 + 2] & 0xFF) << 16;
            }
            case 2: {
                h2 ^= (data2[index3 + 1] & 0xFF) << 8;
            }
            case 1: {
                h2 ^= data2[index3] & 0xFF;
                h2 *= 1540483477;
            }
        }
        h2 ^= h2 >>> 13;
        h2 *= 1540483477;
        h2 ^= h2 >>> 15;
        return h2;
    }

    public static int hash32(byte[] data2, int length) {
        return MurmurHash2.hash32(data2, length, -1756908916);
    }

    public static int hash32(String text) {
        byte[] bytes2 = StringUtils.getBytesUtf8(text);
        return MurmurHash2.hash32(bytes2, bytes2.length);
    }

    public static int hash32(String text, int from, int length) {
        return MurmurHash2.hash32(text.substring(from, from + length));
    }

    public static long hash64(byte[] data2, int length, int seed) {
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int nblocks = length >> 3;
        for (int i = 0; i < nblocks; ++i) {
            int index2 = i << 3;
            long k = MurmurHash2.getLittleEndianLong(data2, index2);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h2 ^= (k *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
        }
        int index3 = nblocks << 3;
        switch (length - index3) {
            case 7: {
                h2 ^= ((long)data2[index3 + 6] & 0xFFL) << 48;
            }
            case 6: {
                h2 ^= ((long)data2[index3 + 5] & 0xFFL) << 40;
            }
            case 5: {
                h2 ^= ((long)data2[index3 + 4] & 0xFFL) << 32;
            }
            case 4: {
                h2 ^= ((long)data2[index3 + 3] & 0xFFL) << 24;
            }
            case 3: {
                h2 ^= ((long)data2[index3 + 2] & 0xFFL) << 16;
            }
            case 2: {
                h2 ^= ((long)data2[index3 + 1] & 0xFFL) << 8;
            }
            case 1: {
                h2 ^= (long)data2[index3] & 0xFFL;
                h2 *= -4132994306676758123L;
            }
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }

    public static long hash64(byte[] data2, int length) {
        return MurmurHash2.hash64(data2, length, -512093083);
    }

    public static long hash64(String text) {
        byte[] bytes2 = StringUtils.getBytesUtf8(text);
        return MurmurHash2.hash64(bytes2, bytes2.length);
    }

    public static long hash64(String text, int from, int length) {
        return MurmurHash2.hash64(text.substring(from, from + length));
    }

    private static int getLittleEndianInt(byte[] data2, int index2) {
        return data2[index2] & 0xFF | (data2[index2 + 1] & 0xFF) << 8 | (data2[index2 + 2] & 0xFF) << 16 | (data2[index2 + 3] & 0xFF) << 24;
    }

    private static long getLittleEndianLong(byte[] data2, int index2) {
        return (long)data2[index2] & 0xFFL | ((long)data2[index2 + 1] & 0xFFL) << 8 | ((long)data2[index2 + 2] & 0xFFL) << 16 | ((long)data2[index2 + 3] & 0xFFL) << 24 | ((long)data2[index2 + 4] & 0xFFL) << 32 | ((long)data2[index2 + 5] & 0xFFL) << 40 | ((long)data2[index2 + 6] & 0xFFL) << 48 | ((long)data2[index2 + 7] & 0xFFL) << 56;
    }
}

