/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.PreparedStatement;
import io.vertx.rxjava.sqlclient.SqlClient;
import io.vertx.rxjava.sqlclient.Transaction;
import io.vertx.rxjava.sqlclient.spi.DatabaseMetadata;
import io.vertx.sqlclient.PrepareOptions;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection
extends SqlClient {
    public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg<SqlConnection>(obj2 -> new SqlConnection((io.vertx.sqlclient.SqlConnection)obj2), SqlConnection::getDelegate);
    private final io.vertx.sqlclient.SqlConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConnection that = (SqlConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public SqlConnection(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.SqlConnection)delegate));
        this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
    }

    public io.vertx.sqlclient.SqlConnection getDelegate() {
        return this.delegate;
    }

    public SqlConnection prepare(String sql, final Handler<AsyncResult<PreparedStatement>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(PreparedStatement.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public SqlConnection prepare(String sql) {
        return this.prepare(sql, (AsyncResult<PreparedStatement> ar) -> {});
    }

    public Single<PreparedStatement> rxPrepare(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(sql, (Handler<AsyncResult<PreparedStatement>>)fut)));
    }

    public SqlConnection prepare(String sql, PrepareOptions options2, final Handler<AsyncResult<PreparedStatement>> handler) {
        this.delegate.prepare(sql, options2, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(PreparedStatement.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public SqlConnection prepare(String sql, PrepareOptions options2) {
        return this.prepare(sql, options2, ar -> {});
    }

    public Single<PreparedStatement> rxPrepare(String sql, PrepareOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(sql, options2, (Handler<AsyncResult<PreparedStatement>>)fut)));
    }

    public SqlConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SqlConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public void begin(final Handler<AsyncResult<Transaction>> handler) {
        this.delegate.begin((Handler)new Handler<AsyncResult<io.vertx.sqlclient.Transaction>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.Transaction> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Transaction.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void begin() {
        this.begin(ar -> {});
    }

    public Single<Transaction> rxBegin() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.begin((Handler<AsyncResult<Transaction>>)fut)));
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public void close() {
        this.close(ar -> {});
    }

    @Override
    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public DatabaseMetadata databaseMetadata() {
        DatabaseMetadata ret = DatabaseMetadata.newInstance(this.delegate.databaseMetadata());
        return ret;
    }

    public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
        return arg != null ? new SqlConnection(arg) : null;
    }
}

