/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.sqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Context;
import io.vertx.rxjava.sqlclient.PreparedQuery;
import io.vertx.rxjava.sqlclient.Query;
import io.vertx.rxjava.sqlclient.Row;
import io.vertx.rxjava.sqlclient.RowSet;
import io.vertx.rxjava.sqlclient.SqlClient;
import io.vertx.rxjava.sqlclient.SqlConnection;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.function.Function;
import rx.Single;

@RxGen(value=io.vertx.sqlclient.Pool.class)
public class Pool
extends SqlClient {
    public static final TypeArg<Pool> __TYPE_ARG = new TypeArg<Pool>(obj2 -> new Pool((io.vertx.sqlclient.Pool)obj2), Pool::getDelegate);
    private final io.vertx.sqlclient.Pool delegate;
    private static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg<RowSet>(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<Row>(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    private static final TypeArg<RowSet<Row>> TYPE_ARG_1 = new TypeArg<RowSet>(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<Row>(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Pool(io.vertx.sqlclient.Pool delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public Pool(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.Pool)delegate));
        this.delegate = (io.vertx.sqlclient.Pool)delegate;
    }

    public io.vertx.sqlclient.Pool getDelegate() {
        return this.delegate;
    }

    public static Pool pool(SqlConnectOptions connectOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions));
        return ret;
    }

    public static Pool pool(SqlConnectOptions database, PoolOptions options2) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)database, (PoolOptions)options2));
        return ret;
    }

    public static Pool pool(io.vertx.rxjava.core.Vertx vertx, SqlConnectOptions database, PoolOptions options2) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((Vertx)vertx.getDelegate(), (SqlConnectOptions)database, (PoolOptions)options2));
        return ret;
    }

    public void getConnection(final Handler<AsyncResult<SqlConnection>> handler) {
        this.delegate.getConnection((Handler)new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(SqlConnection.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void getConnection() {
        this.getConnection(ar -> {});
    }

    public Single<SqlConnection> rxGetConnection() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getConnection((Handler<AsyncResult<SqlConnection>>)fut)));
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        Query<RowSet<Row>> ret = Query.newInstance(this.delegate.query(sql), TYPE_ARG_0);
        return ret;
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.preparedQuery(sql), TYPE_ARG_1);
        return ret;
    }

    public <T> void withTransaction(final Function<SqlConnection, Future<T>> function, Handler<AsyncResult<T>> handler) {
        this.delegate.withTransaction(new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                Future ret = (Future)function.apply(SqlConnection.newInstance(arg));
                return ret.map(val2 -> val2);
            }
        }, handler);
    }

    public <T> void withTransaction(Function<SqlConnection, Future<T>> function) {
        this.withTransaction(function, ar -> {});
    }

    public <T> Single<T> rxWithTransaction(Function<SqlConnection, Future<T>> function) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.withTransaction(function, (Handler)fut)));
    }

    public <T> void withConnection(final Function<SqlConnection, Future<T>> function, Handler<AsyncResult<T>> handler) {
        this.delegate.withConnection(new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                Future ret = (Future)function.apply(SqlConnection.newInstance(arg));
                return ret.map(val2 -> val2);
            }
        }, handler);
    }

    public <T> void withConnection(Function<SqlConnection, Future<T>> function) {
        this.withConnection(function, ar -> {});
    }

    public <T> Single<T> rxWithConnection(Function<SqlConnection, Future<T>> function) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.withConnection(function, (Handler)fut)));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public void close() {
        this.close(ar -> {});
    }

    @Override
    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public Pool connectHandler(final Handler<SqlConnection> handler) {
        this.delegate.connectHandler((Handler)new Handler<io.vertx.sqlclient.SqlConnection>(){

            @Override
            public void handle(io.vertx.sqlclient.SqlConnection event) {
                handler.handle(SqlConnection.newInstance(event));
            }
        });
        return this;
    }

    public Pool connectionProvider(final Function<Context, Future<SqlConnection>> provider2) {
        this.delegate.connectionProvider((Function)new Function<io.vertx.core.Context, Future<io.vertx.sqlclient.SqlConnection>>(){

            @Override
            public Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
                Future ret = (Future)provider2.apply(Context.newInstance(arg));
                return ret.map(val2 -> val2.getDelegate());
            }
        });
        return this;
    }

    public int size() {
        int ret = this.delegate.size();
        return ret;
    }

    public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
        return arg != null ? new Pool(arg) : null;
    }
}

