/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.rxjava.redis.client.Request;
import io.vertx.rxjava.redis.client.Response;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.redis.client.RedisConnection.class)
public class RedisConnection
implements ReadStream<Response> {
    public static final TypeArg<RedisConnection> __TYPE_ARG = new TypeArg<RedisConnection>(obj2 -> new RedisConnection((io.vertx.redis.client.RedisConnection)obj2), RedisConnection::getDelegate);
    private final io.vertx.redis.client.RedisConnection delegate;
    private Observable<Response> observable;
    private static final TypeArg<Response> TYPE_ARG_0 = new TypeArg<Response>(o1 -> Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConnection that = (RedisConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
        this.delegate = delegate;
    }

    public RedisConnection(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
    }

    public io.vertx.redis.client.RedisConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Response> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public Pipe<Response> pipe() {
        Pipe<Response> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Response> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<Response> dst) {
        this.pipeTo(dst, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxPipeTo(WriteStream<Response> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public RedisConnection handler(final Handler<Response> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.redis.client.Response>(){

            @Override
            public void handle(io.vertx.redis.client.Response event) {
                handler.handle(Response.newInstance(event));
            }
        });
        return this;
    }

    public RedisConnection pause() {
        this.delegate.pause();
        return this;
    }

    public RedisConnection resume() {
        this.delegate.resume();
        return this;
    }

    public RedisConnection fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public RedisConnection endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RedisConnection send(Request command2, final Handler<AsyncResult<Response>> onSend2) {
        this.delegate.send(command2.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend2.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    onSend2.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisConnection send(Request command2) {
        return this.send(command2, ar -> {});
    }

    public Single<Response> rxSend(Request command2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(command2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisConnection batch(List<Request> commands, final Handler<AsyncResult<List<Response>>> onSend2) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            @Override
            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    onSend2.handle(Future.succeededFuture(ar.result().stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    onSend2.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisConnection batch(List<Request> commands) {
        return this.batch(commands, ar -> {});
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)fut)));
    }

    public RedisConnection close(Handler<AsyncResult<Void>> onClose) {
        this.delegate.close(onClose);
        return this;
    }

    public RedisConnection close() {
        return this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public boolean pendingQueueFull() {
        boolean ret = this.delegate.pendingQueueFull();
        return ret;
    }

    public static RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
        return arg != null ? new RedisConnection(arg) : null;
    }
}

