/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.redis.client.Redis;
import io.vertx.rxjava.redis.client.RedisConnection;
import io.vertx.rxjava.redis.client.Response;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {
    public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<RedisAPI>(obj2 -> new RedisAPI((io.vertx.redis.client.RedisAPI)obj2), RedisAPI::getDelegate);
    private final io.vertx.redis.client.RedisAPI delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisAPI that = (RedisAPI)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
        this.delegate = delegate;
    }

    public RedisAPI(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
    }

    public io.vertx.redis.client.RedisAPI getDelegate() {
        return this.delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public RedisAPI acl(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.acl(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI acl(List<String> args2) {
        return this.acl(args2, ar -> {});
    }

    public Single<Response> rxAcl(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.acl(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI append(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.append(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI append(String arg0, String arg1) {
        return this.append(arg0, arg1, ar -> {});
    }

    public Single<Response> rxAppend(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.append(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI asking(final Handler<AsyncResult<Response>> handler) {
        this.delegate.asking((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI asking() {
        return this.asking(ar -> {});
    }

    public Single<Response> rxAsking() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.asking((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI auth(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.auth(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI auth(List<String> args2) {
        return this.auth(args2, ar -> {});
    }

    public Single<Response> rxAuth(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.auth(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bgrewriteaof(final Handler<AsyncResult<Response>> handler) {
        this.delegate.bgrewriteaof((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bgrewriteaof() {
        return this.bgrewriteaof(ar -> {});
    }

    public Single<Response> rxBgrewriteaof() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bgrewriteaof((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bgsave(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bgsave(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bgsave(List<String> args2) {
        return this.bgsave(args2, ar -> {});
    }

    public Single<Response> rxBgsave(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bgsave(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bitcount(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bitcount(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bitcount(List<String> args2) {
        return this.bitcount(args2, ar -> {});
    }

    public Single<Response> rxBitcount(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bitcount(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bitfield(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bitfield(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bitfield(List<String> args2) {
        return this.bitfield(args2, ar -> {});
    }

    public Single<Response> rxBitfield(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bitfield(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bitfieldRo(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bitfieldRo(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bitfieldRo(List<String> args2) {
        return this.bitfieldRo(args2, ar -> {});
    }

    public Single<Response> rxBitfieldRo(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bitfieldRo(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bitop(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bitop(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bitop(List<String> args2) {
        return this.bitop(args2, ar -> {});
    }

    public Single<Response> rxBitop(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bitop(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bitpos(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bitpos(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bitpos(List<String> args2) {
        return this.bitpos(args2, ar -> {});
    }

    public Single<Response> rxBitpos(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bitpos(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI blmove(String arg0, String arg1, String arg2, String arg3, String arg4, final Handler<AsyncResult<Response>> handler) {
        this.delegate.blmove(arg0, arg1, arg2, arg3, arg4, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI blmove(String arg0, String arg1, String arg2, String arg3, String arg4) {
        return this.blmove(arg0, arg1, arg2, arg3, arg4, ar -> {});
    }

    public Single<Response> rxBlmove(String arg0, String arg1, String arg2, String arg3, String arg4) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.blmove(arg0, arg1, arg2, arg3, arg4, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI blpop(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.blpop(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI blpop(List<String> args2) {
        return this.blpop(args2, ar -> {});
    }

    public Single<Response> rxBlpop(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.blpop(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI brpop(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.brpop(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI brpop(List<String> args2) {
        return this.brpop(args2, ar -> {});
    }

    public Single<Response> rxBrpop(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.brpop(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI brpoplpush(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.brpoplpush(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI brpoplpush(String arg0, String arg1, String arg2) {
        return this.brpoplpush(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxBrpoplpush(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.brpoplpush(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bzpopmax(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bzpopmax(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bzpopmax(List<String> args2) {
        return this.bzpopmax(args2, ar -> {});
    }

    public Single<Response> rxBzpopmax(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bzpopmax(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI bzpopmin(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.bzpopmin(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI bzpopmin(List<String> args2) {
        return this.bzpopmin(args2, ar -> {});
    }

    public Single<Response> rxBzpopmin(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bzpopmin(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI client(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.client(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI client(List<String> args2) {
        return this.client(args2, ar -> {});
    }

    public Single<Response> rxClient(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.client(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI cluster(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.cluster(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI cluster(List<String> args2) {
        return this.cluster(args2, ar -> {});
    }

    public Single<Response> rxCluster(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.cluster(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI command(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.command(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI command(List<String> args2) {
        return this.command(args2, ar -> {});
    }

    public Single<Response> rxCommand(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.command(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI config(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.config(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI config(List<String> args2) {
        return this.config(args2, ar -> {});
    }

    public Single<Response> rxConfig(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.config(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI copy(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.copy(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI copy(List<String> args2) {
        return this.copy(args2, ar -> {});
    }

    public Single<Response> rxCopy(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.copy(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI dbsize(final Handler<AsyncResult<Response>> handler) {
        this.delegate.dbsize((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI dbsize() {
        return this.dbsize(ar -> {});
    }

    public Single<Response> rxDbsize() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.dbsize((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI debug(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.debug(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI debug(List<String> args2) {
        return this.debug(args2, ar -> {});
    }

    public Single<Response> rxDebug(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.debug(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI decr(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.decr(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI decr(String arg0) {
        return this.decr(arg0, ar -> {});
    }

    public Single<Response> rxDecr(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.decr(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI decrby(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.decrby(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI decrby(String arg0, String arg1) {
        return this.decrby(arg0, arg1, ar -> {});
    }

    public Single<Response> rxDecrby(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.decrby(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI del(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.del(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI del(List<String> args2) {
        return this.del(args2, ar -> {});
    }

    public Single<Response> rxDel(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.del(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI discard(final Handler<AsyncResult<Response>> handler) {
        this.delegate.discard((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI discard() {
        return this.discard(ar -> {});
    }

    public Single<Response> rxDiscard() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.discard((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI dump(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.dump(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI dump(String arg0) {
        return this.dump(arg0, ar -> {});
    }

    public Single<Response> rxDump(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.dump(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI echo(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.echo(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI echo(String arg0) {
        return this.echo(arg0, ar -> {});
    }

    public Single<Response> rxEcho(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.echo(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI eval(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.eval(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI eval(List<String> args2) {
        return this.eval(args2, ar -> {});
    }

    public Single<Response> rxEval(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.eval(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI evalsha(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.evalsha(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI evalsha(List<String> args2) {
        return this.evalsha(args2, ar -> {});
    }

    public Single<Response> rxEvalsha(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.evalsha(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI exec(final Handler<AsyncResult<Response>> handler) {
        this.delegate.exec((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI exec() {
        return this.exec(ar -> {});
    }

    public Single<Response> rxExec() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exec((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI exists(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.exists(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI exists(List<String> args2) {
        return this.exists(args2, ar -> {});
    }

    public Single<Response> rxExists(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exists(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI expire(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.expire(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI expire(String arg0, String arg1) {
        return this.expire(arg0, arg1, ar -> {});
    }

    public Single<Response> rxExpire(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.expire(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI expireat(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.expireat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI expireat(String arg0, String arg1) {
        return this.expireat(arg0, arg1, ar -> {});
    }

    public Single<Response> rxExpireat(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.expireat(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI failover(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.failover(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI failover(List<String> args2) {
        return this.failover(args2, ar -> {});
    }

    public Single<Response> rxFailover(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.failover(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI flushall(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.flushall(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI flushall(List<String> args2) {
        return this.flushall(args2, ar -> {});
    }

    public Single<Response> rxFlushall(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.flushall(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI flushdb(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.flushdb(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI flushdb(List<String> args2) {
        return this.flushdb(args2, ar -> {});
    }

    public Single<Response> rxFlushdb(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.flushdb(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI geoadd(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.geoadd(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI geoadd(List<String> args2) {
        return this.geoadd(args2, ar -> {});
    }

    public Single<Response> rxGeoadd(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.geoadd(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI geodist(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.geodist(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI geodist(List<String> args2) {
        return this.geodist(args2, ar -> {});
    }

    public Single<Response> rxGeodist(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.geodist(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI geohash(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.geohash(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI geohash(List<String> args2) {
        return this.geohash(args2, ar -> {});
    }

    public Single<Response> rxGeohash(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.geohash(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI geopos(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.geopos(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI geopos(List<String> args2) {
        return this.geopos(args2, ar -> {});
    }

    public Single<Response> rxGeopos(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.geopos(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI georadius(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.georadius(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI georadius(List<String> args2) {
        return this.georadius(args2, ar -> {});
    }

    public Single<Response> rxGeoradius(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.georadius(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI georadiusRo(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.georadiusRo(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI georadiusRo(List<String> args2) {
        return this.georadiusRo(args2, ar -> {});
    }

    public Single<Response> rxGeoradiusRo(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.georadiusRo(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI georadiusbymember(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.georadiusbymember(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI georadiusbymember(List<String> args2) {
        return this.georadiusbymember(args2, ar -> {});
    }

    public Single<Response> rxGeoradiusbymember(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.georadiusbymember(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI georadiusbymemberRo(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.georadiusbymemberRo(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI georadiusbymemberRo(List<String> args2) {
        return this.georadiusbymemberRo(args2, ar -> {});
    }

    public Single<Response> rxGeoradiusbymemberRo(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.georadiusbymemberRo(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI geosearch(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.geosearch(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI geosearch(List<String> args2) {
        return this.geosearch(args2, ar -> {});
    }

    public Single<Response> rxGeosearch(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.geosearch(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI geosearchstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.geosearchstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI geosearchstore(List<String> args2) {
        return this.geosearchstore(args2, ar -> {});
    }

    public Single<Response> rxGeosearchstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.geosearchstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI get(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.get(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI get(String arg0) {
        return this.get(arg0, ar -> {});
    }

    public Single<Response> rxGet(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.get(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI getbit(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.getbit(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI getbit(String arg0, String arg1) {
        return this.getbit(arg0, arg1, ar -> {});
    }

    public Single<Response> rxGetbit(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getbit(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI getdel(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.getdel(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI getdel(String arg0) {
        return this.getdel(arg0, ar -> {});
    }

    public Single<Response> rxGetdel(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getdel(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI getex(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.getex(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI getex(List<String> args2) {
        return this.getex(args2, ar -> {});
    }

    public Single<Response> rxGetex(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getex(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI getrange(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.getrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI getrange(String arg0, String arg1, String arg2) {
        return this.getrange(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxGetrange(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getrange(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI getset(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.getset(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI getset(String arg0, String arg1) {
        return this.getset(arg0, arg1, ar -> {});
    }

    public Single<Response> rxGetset(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getset(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hdel(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hdel(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hdel(List<String> args2) {
        return this.hdel(args2, ar -> {});
    }

    public Single<Response> rxHdel(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hdel(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hello(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hello(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hello(List<String> args2) {
        return this.hello(args2, ar -> {});
    }

    public Single<Response> rxHello(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hello(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hexists(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hexists(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hexists(String arg0, String arg1) {
        return this.hexists(arg0, arg1, ar -> {});
    }

    public Single<Response> rxHexists(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hexists(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hget(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hget(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hget(String arg0, String arg1) {
        return this.hget(arg0, arg1, ar -> {});
    }

    public Single<Response> rxHget(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hget(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hgetall(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hgetall(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hgetall(String arg0) {
        return this.hgetall(arg0, ar -> {});
    }

    public Single<Response> rxHgetall(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hgetall(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hincrby(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hincrby(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hincrby(String arg0, String arg1, String arg2) {
        return this.hincrby(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxHincrby(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hincrby(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hincrbyfloat(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hincrbyfloat(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hincrbyfloat(String arg0, String arg1, String arg2) {
        return this.hincrbyfloat(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxHincrbyfloat(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hincrbyfloat(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hkeys(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hkeys(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hkeys(String arg0) {
        return this.hkeys(arg0, ar -> {});
    }

    public Single<Response> rxHkeys(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hkeys(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hlen(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hlen(String arg0) {
        return this.hlen(arg0, ar -> {});
    }

    public Single<Response> rxHlen(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hlen(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hmget(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hmget(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hmget(List<String> args2) {
        return this.hmget(args2, ar -> {});
    }

    public Single<Response> rxHmget(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hmget(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hmset(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hmset(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hmset(List<String> args2) {
        return this.hmset(args2, ar -> {});
    }

    public Single<Response> rxHmset(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hmset(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI host(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.host(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI host(List<String> args2) {
        return this.host(args2, ar -> {});
    }

    public Single<Response> rxHost(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.host(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hrandfield(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hrandfield(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hrandfield(List<String> args2) {
        return this.hrandfield(args2, ar -> {});
    }

    public Single<Response> rxHrandfield(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hrandfield(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hscan(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hscan(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hscan(List<String> args2) {
        return this.hscan(args2, ar -> {});
    }

    public Single<Response> rxHscan(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hscan(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hset(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hset(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hset(List<String> args2) {
        return this.hset(args2, ar -> {});
    }

    public Single<Response> rxHset(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hset(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hsetnx(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hsetnx(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hsetnx(String arg0, String arg1, String arg2) {
        return this.hsetnx(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxHsetnx(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hsetnx(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hstrlen(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hstrlen(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hstrlen(String arg0, String arg1) {
        return this.hstrlen(arg0, arg1, ar -> {});
    }

    public Single<Response> rxHstrlen(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hstrlen(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI hvals(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.hvals(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI hvals(String arg0) {
        return this.hvals(arg0, ar -> {});
    }

    public Single<Response> rxHvals(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.hvals(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI incr(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.incr(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI incr(String arg0) {
        return this.incr(arg0, ar -> {});
    }

    public Single<Response> rxIncr(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.incr(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI incrby(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.incrby(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI incrby(String arg0, String arg1) {
        return this.incrby(arg0, arg1, ar -> {});
    }

    public Single<Response> rxIncrby(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.incrby(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI incrbyfloat(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.incrbyfloat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI incrbyfloat(String arg0, String arg1) {
        return this.incrbyfloat(arg0, arg1, ar -> {});
    }

    public Single<Response> rxIncrbyfloat(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.incrbyfloat(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI info(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.info(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI info(List<String> args2) {
        return this.info(args2, ar -> {});
    }

    public Single<Response> rxInfo(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.info(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI keys(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.keys(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI keys(String arg0) {
        return this.keys(arg0, ar -> {});
    }

    public Single<Response> rxKeys(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.keys(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lastsave(final Handler<AsyncResult<Response>> handler) {
        this.delegate.lastsave((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lastsave() {
        return this.lastsave(ar -> {});
    }

    public Single<Response> rxLastsave() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lastsave((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI latency(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.latency(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI latency(List<String> args2) {
        return this.latency(args2, ar -> {});
    }

    public Single<Response> rxLatency(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.latency(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lindex(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lindex(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lindex(String arg0, String arg1) {
        return this.lindex(arg0, arg1, ar -> {});
    }

    public Single<Response> rxLindex(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lindex(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI linsert(String arg0, String arg1, String arg2, String arg3, final Handler<AsyncResult<Response>> handler) {
        this.delegate.linsert(arg0, arg1, arg2, arg3, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI linsert(String arg0, String arg1, String arg2, String arg3) {
        return this.linsert(arg0, arg1, arg2, arg3, ar -> {});
    }

    public Single<Response> rxLinsert(String arg0, String arg1, String arg2, String arg3) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.linsert(arg0, arg1, arg2, arg3, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI llen(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.llen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI llen(String arg0) {
        return this.llen(arg0, ar -> {});
    }

    public Single<Response> rxLlen(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.llen(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lmove(String arg0, String arg1, String arg2, String arg3, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lmove(arg0, arg1, arg2, arg3, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lmove(String arg0, String arg1, String arg2, String arg3) {
        return this.lmove(arg0, arg1, arg2, arg3, ar -> {});
    }

    public Single<Response> rxLmove(String arg0, String arg1, String arg2, String arg3) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lmove(arg0, arg1, arg2, arg3, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lolwut(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lolwut(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lolwut(List<String> args2) {
        return this.lolwut(args2, ar -> {});
    }

    public Single<Response> rxLolwut(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lolwut(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lpop(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lpop(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lpop(List<String> args2) {
        return this.lpop(args2, ar -> {});
    }

    public Single<Response> rxLpop(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lpop(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lpos(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lpos(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lpos(List<String> args2) {
        return this.lpos(args2, ar -> {});
    }

    public Single<Response> rxLpos(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lpos(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lpush(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lpush(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lpush(List<String> args2) {
        return this.lpush(args2, ar -> {});
    }

    public Single<Response> rxLpush(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lpush(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lpushx(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lpushx(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lpushx(List<String> args2) {
        return this.lpushx(args2, ar -> {});
    }

    public Single<Response> rxLpushx(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lpushx(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lrange(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lrange(String arg0, String arg1, String arg2) {
        return this.lrange(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxLrange(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lrange(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lrem(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lrem(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lrem(String arg0, String arg1, String arg2) {
        return this.lrem(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxLrem(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lrem(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI lset(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.lset(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI lset(String arg0, String arg1, String arg2) {
        return this.lset(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxLset(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lset(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI ltrim(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.ltrim(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI ltrim(String arg0, String arg1, String arg2) {
        return this.ltrim(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxLtrim(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.ltrim(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI memory(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.memory(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI memory(List<String> args2) {
        return this.memory(args2, ar -> {});
    }

    public Single<Response> rxMemory(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.memory(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI mget(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.mget(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI mget(List<String> args2) {
        return this.mget(args2, ar -> {});
    }

    public Single<Response> rxMget(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.mget(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI migrate(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.migrate(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI migrate(List<String> args2) {
        return this.migrate(args2, ar -> {});
    }

    public Single<Response> rxMigrate(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.migrate(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI module(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.module(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI module(List<String> args2) {
        return this.module(args2, ar -> {});
    }

    public Single<Response> rxModule(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.module(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI monitor(final Handler<AsyncResult<Response>> handler) {
        this.delegate.monitor((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI monitor() {
        return this.monitor(ar -> {});
    }

    public Single<Response> rxMonitor() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.monitor((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI move(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.move(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI move(String arg0, String arg1) {
        return this.move(arg0, arg1, ar -> {});
    }

    public Single<Response> rxMove(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.move(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI mset(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.mset(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI mset(List<String> args2) {
        return this.mset(args2, ar -> {});
    }

    public Single<Response> rxMset(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.mset(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI msetnx(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.msetnx(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI msetnx(List<String> args2) {
        return this.msetnx(args2, ar -> {});
    }

    public Single<Response> rxMsetnx(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.msetnx(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI multi(final Handler<AsyncResult<Response>> handler) {
        this.delegate.multi((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI multi() {
        return this.multi(ar -> {});
    }

    public Single<Response> rxMulti() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.multi((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI object(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.object(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI object(List<String> args2) {
        return this.object(args2, ar -> {});
    }

    public Single<Response> rxObject(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.object(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI persist(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.persist(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI persist(String arg0) {
        return this.persist(arg0, ar -> {});
    }

    public Single<Response> rxPersist(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.persist(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pexpire(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pexpire(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pexpire(String arg0, String arg1) {
        return this.pexpire(arg0, arg1, ar -> {});
    }

    public Single<Response> rxPexpire(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pexpire(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pexpireat(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pexpireat(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pexpireat(String arg0, String arg1) {
        return this.pexpireat(arg0, arg1, ar -> {});
    }

    public Single<Response> rxPexpireat(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pexpireat(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pfadd(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pfadd(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pfadd(List<String> args2) {
        return this.pfadd(args2, ar -> {});
    }

    public Single<Response> rxPfadd(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pfadd(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pfcount(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pfcount(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pfcount(List<String> args2) {
        return this.pfcount(args2, ar -> {});
    }

    public Single<Response> rxPfcount(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pfcount(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pfdebug(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pfdebug(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pfdebug(List<String> args2) {
        return this.pfdebug(args2, ar -> {});
    }

    public Single<Response> rxPfdebug(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pfdebug(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pfmerge(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pfmerge(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pfmerge(List<String> args2) {
        return this.pfmerge(args2, ar -> {});
    }

    public Single<Response> rxPfmerge(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pfmerge(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pfselftest(final Handler<AsyncResult<Response>> handler) {
        this.delegate.pfselftest((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pfselftest() {
        return this.pfselftest(ar -> {});
    }

    public Single<Response> rxPfselftest() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pfselftest((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI ping(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.ping(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI ping(List<String> args2) {
        return this.ping(args2, ar -> {});
    }

    public Single<Response> rxPing(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.ping(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI post(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.post(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI post(List<String> args2) {
        return this.post(args2, ar -> {});
    }

    public Single<Response> rxPost(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.post(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI psetex(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.psetex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI psetex(String arg0, String arg1, String arg2) {
        return this.psetex(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxPsetex(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.psetex(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI psubscribe(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.psubscribe(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI psubscribe(List<String> args2) {
        return this.psubscribe(args2, ar -> {});
    }

    public Single<Response> rxPsubscribe(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.psubscribe(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI psync(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.psync(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI psync(List<String> args2) {
        return this.psync(args2, ar -> {});
    }

    public Single<Response> rxPsync(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.psync(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pttl(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pttl(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pttl(String arg0) {
        return this.pttl(arg0, ar -> {});
    }

    public Single<Response> rxPttl(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pttl(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI publish(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.publish(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI publish(String arg0, String arg1) {
        return this.publish(arg0, arg1, ar -> {});
    }

    public Single<Response> rxPublish(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.publish(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI pubsub(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.pubsub(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI pubsub(List<String> args2) {
        return this.pubsub(args2, ar -> {});
    }

    public Single<Response> rxPubsub(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pubsub(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI punsubscribe(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.punsubscribe(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI punsubscribe(List<String> args2) {
        return this.punsubscribe(args2, ar -> {});
    }

    public Single<Response> rxPunsubscribe(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.punsubscribe(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI randomkey(final Handler<AsyncResult<Response>> handler) {
        this.delegate.randomkey((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI randomkey() {
        return this.randomkey(ar -> {});
    }

    public Single<Response> rxRandomkey() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.randomkey((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI readonly(final Handler<AsyncResult<Response>> handler) {
        this.delegate.readonly((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI readonly() {
        return this.readonly(ar -> {});
    }

    public Single<Response> rxReadonly() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.readonly((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI readwrite(final Handler<AsyncResult<Response>> handler) {
        this.delegate.readwrite((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI readwrite() {
        return this.readwrite(ar -> {});
    }

    public Single<Response> rxReadwrite() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.readwrite((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI rename(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.rename(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI rename(String arg0, String arg1) {
        return this.rename(arg0, arg1, ar -> {});
    }

    public Single<Response> rxRename(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.rename(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI renamenx(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.renamenx(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI renamenx(String arg0, String arg1) {
        return this.renamenx(arg0, arg1, ar -> {});
    }

    public Single<Response> rxRenamenx(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.renamenx(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI replconf(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.replconf(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI replconf(List<String> args2) {
        return this.replconf(args2, ar -> {});
    }

    public Single<Response> rxReplconf(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replconf(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI replicaof(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.replicaof(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI replicaof(String arg0, String arg1) {
        return this.replicaof(arg0, arg1, ar -> {});
    }

    public Single<Response> rxReplicaof(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replicaof(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI reset(final Handler<AsyncResult<Response>> handler) {
        this.delegate.reset((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI reset() {
        return this.reset(ar -> {});
    }

    public Single<Response> rxReset() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.reset((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI restore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.restore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI restore(List<String> args2) {
        return this.restore(args2, ar -> {});
    }

    public Single<Response> rxRestore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.restore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI restoreAsking(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.restoreAsking(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI restoreAsking(List<String> args2) {
        return this.restoreAsking(args2, ar -> {});
    }

    public Single<Response> rxRestoreAsking(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.restoreAsking(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI role(final Handler<AsyncResult<Response>> handler) {
        this.delegate.role((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI role() {
        return this.role(ar -> {});
    }

    public Single<Response> rxRole() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.role((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI rpop(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.rpop(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI rpop(List<String> args2) {
        return this.rpop(args2, ar -> {});
    }

    public Single<Response> rxRpop(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.rpop(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI rpoplpush(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.rpoplpush(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI rpoplpush(String arg0, String arg1) {
        return this.rpoplpush(arg0, arg1, ar -> {});
    }

    public Single<Response> rxRpoplpush(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.rpoplpush(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI rpush(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.rpush(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI rpush(List<String> args2) {
        return this.rpush(args2, ar -> {});
    }

    public Single<Response> rxRpush(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.rpush(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI rpushx(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.rpushx(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI rpushx(List<String> args2) {
        return this.rpushx(args2, ar -> {});
    }

    public Single<Response> rxRpushx(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.rpushx(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sadd(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sadd(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sadd(List<String> args2) {
        return this.sadd(args2, ar -> {});
    }

    public Single<Response> rxSadd(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sadd(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI save(final Handler<AsyncResult<Response>> handler) {
        this.delegate.save((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI save() {
        return this.save(ar -> {});
    }

    public Single<Response> rxSave() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.save((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI scan(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.scan(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI scan(List<String> args2) {
        return this.scan(args2, ar -> {});
    }

    public Single<Response> rxScan(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.scan(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI scard(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.scard(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI scard(String arg0) {
        return this.scard(arg0, ar -> {});
    }

    public Single<Response> rxScard(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.scard(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI script(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.script(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI script(List<String> args2) {
        return this.script(args2, ar -> {});
    }

    public Single<Response> rxScript(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.script(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sdiff(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sdiff(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sdiff(List<String> args2) {
        return this.sdiff(args2, ar -> {});
    }

    public Single<Response> rxSdiff(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sdiff(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sdiffstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sdiffstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sdiffstore(List<String> args2) {
        return this.sdiffstore(args2, ar -> {});
    }

    public Single<Response> rxSdiffstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sdiffstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI select(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.select(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI select(String arg0) {
        return this.select(arg0, ar -> {});
    }

    public Single<Response> rxSelect(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.select(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI set(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.set(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI set(List<String> args2) {
        return this.set(args2, ar -> {});
    }

    public Single<Response> rxSet(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.set(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI setbit(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.setbit(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI setbit(String arg0, String arg1, String arg2) {
        return this.setbit(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxSetbit(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.setbit(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI setex(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.setex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI setex(String arg0, String arg1, String arg2) {
        return this.setex(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxSetex(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.setex(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI setnx(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.setnx(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI setnx(String arg0, String arg1) {
        return this.setnx(arg0, arg1, ar -> {});
    }

    public Single<Response> rxSetnx(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.setnx(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI setrange(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.setrange(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI setrange(String arg0, String arg1, String arg2) {
        return this.setrange(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxSetrange(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.setrange(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI shutdown(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.shutdown(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI shutdown(List<String> args2) {
        return this.shutdown(args2, ar -> {});
    }

    public Single<Response> rxShutdown(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.shutdown(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sinter(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sinter(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sinter(List<String> args2) {
        return this.sinter(args2, ar -> {});
    }

    public Single<Response> rxSinter(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sinter(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sinterstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sinterstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sinterstore(List<String> args2) {
        return this.sinterstore(args2, ar -> {});
    }

    public Single<Response> rxSinterstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sinterstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sismember(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sismember(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sismember(String arg0, String arg1) {
        return this.sismember(arg0, arg1, ar -> {});
    }

    public Single<Response> rxSismember(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sismember(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI slaveof(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.slaveof(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI slaveof(String arg0, String arg1) {
        return this.slaveof(arg0, arg1, ar -> {});
    }

    public Single<Response> rxSlaveof(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.slaveof(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI slowlog(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.slowlog(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI slowlog(List<String> args2) {
        return this.slowlog(args2, ar -> {});
    }

    public Single<Response> rxSlowlog(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.slowlog(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI smembers(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.smembers(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI smembers(String arg0) {
        return this.smembers(arg0, ar -> {});
    }

    public Single<Response> rxSmembers(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.smembers(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI smismember(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.smismember(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI smismember(List<String> args2) {
        return this.smismember(args2, ar -> {});
    }

    public Single<Response> rxSmismember(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.smismember(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI smove(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.smove(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI smove(String arg0, String arg1, String arg2) {
        return this.smove(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxSmove(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.smove(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sort(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sort(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sort(List<String> args2) {
        return this.sort(args2, ar -> {});
    }

    public Single<Response> rxSort(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sort(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI spop(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.spop(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI spop(List<String> args2) {
        return this.spop(args2, ar -> {});
    }

    public Single<Response> rxSpop(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.spop(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI srandmember(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.srandmember(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI srandmember(List<String> args2) {
        return this.srandmember(args2, ar -> {});
    }

    public Single<Response> rxSrandmember(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.srandmember(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI srem(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.srem(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI srem(List<String> args2) {
        return this.srem(args2, ar -> {});
    }

    public Single<Response> rxSrem(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.srem(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sscan(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sscan(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sscan(List<String> args2) {
        return this.sscan(args2, ar -> {});
    }

    public Single<Response> rxSscan(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sscan(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI stralgo(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.stralgo(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI stralgo(List<String> args2) {
        return this.stralgo(args2, ar -> {});
    }

    public Single<Response> rxStralgo(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.stralgo(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI strlen(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.strlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI strlen(String arg0) {
        return this.strlen(arg0, ar -> {});
    }

    public Single<Response> rxStrlen(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.strlen(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI subscribe(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.subscribe(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI subscribe(List<String> args2) {
        return this.subscribe(args2, ar -> {});
    }

    public Single<Response> rxSubscribe(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.subscribe(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI substr(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.substr(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI substr(String arg0, String arg1, String arg2) {
        return this.substr(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxSubstr(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.substr(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sunion(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sunion(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sunion(List<String> args2) {
        return this.sunion(args2, ar -> {});
    }

    public Single<Response> rxSunion(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sunion(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sunionstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.sunionstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sunionstore(List<String> args2) {
        return this.sunionstore(args2, ar -> {});
    }

    public Single<Response> rxSunionstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sunionstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI swapdb(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.swapdb(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI swapdb(String arg0, String arg1) {
        return this.swapdb(arg0, arg1, ar -> {});
    }

    public Single<Response> rxSwapdb(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.swapdb(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI sync(final Handler<AsyncResult<Response>> handler) {
        this.delegate.sync((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI sync() {
        return this.sync(ar -> {});
    }

    public Single<Response> rxSync() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sync((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI time(final Handler<AsyncResult<Response>> handler) {
        this.delegate.time((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI time() {
        return this.time(ar -> {});
    }

    public Single<Response> rxTime() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.time((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI touch(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.touch(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI touch(List<String> args2) {
        return this.touch(args2, ar -> {});
    }

    public Single<Response> rxTouch(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.touch(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI ttl(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.ttl(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI ttl(String arg0) {
        return this.ttl(arg0, ar -> {});
    }

    public Single<Response> rxTtl(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.ttl(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI type(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.type(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI type(String arg0) {
        return this.type(arg0, ar -> {});
    }

    public Single<Response> rxType(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.type(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI unlink(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.unlink(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI unlink(List<String> args2) {
        return this.unlink(args2, ar -> {});
    }

    public Single<Response> rxUnlink(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unlink(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI unsubscribe(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.unsubscribe(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI unsubscribe(List<String> args2) {
        return this.unsubscribe(args2, ar -> {});
    }

    public Single<Response> rxUnsubscribe(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unsubscribe(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI unwatch(final Handler<AsyncResult<Response>> handler) {
        this.delegate.unwatch((Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI unwatch() {
        return this.unwatch(ar -> {});
    }

    public Single<Response> rxUnwatch() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unwatch((Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI wait(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.wait(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI wait(String arg0, String arg1) {
        return this.wait(arg0, arg1, ar -> {});
    }

    public Single<Response> rxWait(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.wait(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI watch(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.watch(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI watch(List<String> args2) {
        return this.watch(args2, ar -> {});
    }

    public Single<Response> rxWatch(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.watch(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xack(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xack(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xack(List<String> args2) {
        return this.xack(args2, ar -> {});
    }

    public Single<Response> rxXack(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xack(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xadd(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xadd(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xadd(List<String> args2) {
        return this.xadd(args2, ar -> {});
    }

    public Single<Response> rxXadd(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xadd(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xautoclaim(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xautoclaim(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xautoclaim(List<String> args2) {
        return this.xautoclaim(args2, ar -> {});
    }

    public Single<Response> rxXautoclaim(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xautoclaim(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xclaim(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xclaim(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xclaim(List<String> args2) {
        return this.xclaim(args2, ar -> {});
    }

    public Single<Response> rxXclaim(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xclaim(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xdel(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xdel(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xdel(List<String> args2) {
        return this.xdel(args2, ar -> {});
    }

    public Single<Response> rxXdel(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xdel(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xgroup(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xgroup(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xgroup(List<String> args2) {
        return this.xgroup(args2, ar -> {});
    }

    public Single<Response> rxXgroup(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xgroup(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xinfo(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xinfo(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xinfo(List<String> args2) {
        return this.xinfo(args2, ar -> {});
    }

    public Single<Response> rxXinfo(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xinfo(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xlen(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xlen(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xlen(String arg0) {
        return this.xlen(arg0, ar -> {});
    }

    public Single<Response> rxXlen(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xlen(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xpending(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xpending(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xpending(List<String> args2) {
        return this.xpending(args2, ar -> {});
    }

    public Single<Response> rxXpending(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xpending(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xrange(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xrange(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xrange(List<String> args2) {
        return this.xrange(args2, ar -> {});
    }

    public Single<Response> rxXrange(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xrange(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xread(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xread(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xread(List<String> args2) {
        return this.xread(args2, ar -> {});
    }

    public Single<Response> rxXread(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xread(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xreadgroup(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xreadgroup(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xreadgroup(List<String> args2) {
        return this.xreadgroup(args2, ar -> {});
    }

    public Single<Response> rxXreadgroup(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xreadgroup(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xrevrange(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xrevrange(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xrevrange(List<String> args2) {
        return this.xrevrange(args2, ar -> {});
    }

    public Single<Response> rxXrevrange(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xrevrange(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xsetid(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xsetid(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xsetid(String arg0, String arg1) {
        return this.xsetid(arg0, arg1, ar -> {});
    }

    public Single<Response> rxXsetid(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xsetid(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI xtrim(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.xtrim(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI xtrim(List<String> args2) {
        return this.xtrim(args2, ar -> {});
    }

    public Single<Response> rxXtrim(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.xtrim(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zadd(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zadd(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zadd(List<String> args2) {
        return this.zadd(args2, ar -> {});
    }

    public Single<Response> rxZadd(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zadd(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zcard(String arg0, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zcard(arg0, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zcard(String arg0) {
        return this.zcard(arg0, ar -> {});
    }

    public Single<Response> rxZcard(String arg0) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zcard(arg0, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zcount(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zcount(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zcount(String arg0, String arg1, String arg2) {
        return this.zcount(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxZcount(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zcount(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zdiff(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zdiff(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zdiff(List<String> args2) {
        return this.zdiff(args2, ar -> {});
    }

    public Single<Response> rxZdiff(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zdiff(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zdiffstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zdiffstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zdiffstore(List<String> args2) {
        return this.zdiffstore(args2, ar -> {});
    }

    public Single<Response> rxZdiffstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zdiffstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zincrby(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zincrby(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zincrby(String arg0, String arg1, String arg2) {
        return this.zincrby(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxZincrby(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zincrby(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zinter(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zinter(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zinter(List<String> args2) {
        return this.zinter(args2, ar -> {});
    }

    public Single<Response> rxZinter(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zinter(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zinterstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zinterstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zinterstore(List<String> args2) {
        return this.zinterstore(args2, ar -> {});
    }

    public Single<Response> rxZinterstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zinterstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zlexcount(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zlexcount(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zlexcount(String arg0, String arg1, String arg2) {
        return this.zlexcount(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxZlexcount(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zlexcount(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zmscore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zmscore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zmscore(List<String> args2) {
        return this.zmscore(args2, ar -> {});
    }

    public Single<Response> rxZmscore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zmscore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zpopmax(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zpopmax(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zpopmax(List<String> args2) {
        return this.zpopmax(args2, ar -> {});
    }

    public Single<Response> rxZpopmax(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zpopmax(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zpopmin(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zpopmin(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zpopmin(List<String> args2) {
        return this.zpopmin(args2, ar -> {});
    }

    public Single<Response> rxZpopmin(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zpopmin(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrandmember(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrandmember(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrandmember(List<String> args2) {
        return this.zrandmember(args2, ar -> {});
    }

    public Single<Response> rxZrandmember(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrandmember(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrange(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrange(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrange(List<String> args2) {
        return this.zrange(args2, ar -> {});
    }

    public Single<Response> rxZrange(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrange(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrangebylex(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrangebylex(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrangebylex(List<String> args2) {
        return this.zrangebylex(args2, ar -> {});
    }

    public Single<Response> rxZrangebylex(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrangebylex(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrangebyscore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrangebyscore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrangebyscore(List<String> args2) {
        return this.zrangebyscore(args2, ar -> {});
    }

    public Single<Response> rxZrangebyscore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrangebyscore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrangestore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrangestore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrangestore(List<String> args2) {
        return this.zrangestore(args2, ar -> {});
    }

    public Single<Response> rxZrangestore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrangestore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrank(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrank(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrank(String arg0, String arg1) {
        return this.zrank(arg0, arg1, ar -> {});
    }

    public Single<Response> rxZrank(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrank(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrem(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrem(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrem(List<String> args2) {
        return this.zrem(args2, ar -> {});
    }

    public Single<Response> rxZrem(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrem(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zremrangebylex(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zremrangebylex(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zremrangebylex(String arg0, String arg1, String arg2) {
        return this.zremrangebylex(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxZremrangebylex(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zremrangebylex(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zremrangebyrank(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zremrangebyrank(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zremrangebyrank(String arg0, String arg1, String arg2) {
        return this.zremrangebyrank(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxZremrangebyrank(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zremrangebyrank(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zremrangebyscore(String arg0, String arg1, String arg2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zremrangebyscore(arg0, arg1, arg2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zremrangebyscore(String arg0, String arg1, String arg2) {
        return this.zremrangebyscore(arg0, arg1, arg2, ar -> {});
    }

    public Single<Response> rxZremrangebyscore(String arg0, String arg1, String arg2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zremrangebyscore(arg0, arg1, arg2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrevrange(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrevrange(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrevrange(List<String> args2) {
        return this.zrevrange(args2, ar -> {});
    }

    public Single<Response> rxZrevrange(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrevrange(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrevrangebylex(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrevrangebylex(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrevrangebylex(List<String> args2) {
        return this.zrevrangebylex(args2, ar -> {});
    }

    public Single<Response> rxZrevrangebylex(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrevrangebylex(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrevrangebyscore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrevrangebyscore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrevrangebyscore(List<String> args2) {
        return this.zrevrangebyscore(args2, ar -> {});
    }

    public Single<Response> rxZrevrangebyscore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrevrangebyscore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zrevrank(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zrevrank(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zrevrank(String arg0, String arg1) {
        return this.zrevrank(arg0, arg1, ar -> {});
    }

    public Single<Response> rxZrevrank(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zrevrank(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zscan(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zscan(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zscan(List<String> args2) {
        return this.zscan(args2, ar -> {});
    }

    public Single<Response> rxZscan(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zscan(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zscore(String arg0, String arg1, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zscore(arg0, arg1, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zscore(String arg0, String arg1) {
        return this.zscore(arg0, arg1, ar -> {});
    }

    public Single<Response> rxZscore(String arg0, String arg1) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zscore(arg0, arg1, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zunion(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zunion(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zunion(List<String> args2) {
        return this.zunion(args2, ar -> {});
    }

    public Single<Response> rxZunion(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zunion(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisAPI zunionstore(List<String> args2, final Handler<AsyncResult<Response>> handler) {
        this.delegate.zunionstore(args2, (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public RedisAPI zunionstore(List<String> args2) {
        return this.zunionstore(args2, ar -> {});
    }

    public Single<Response> rxZunionstore(List<String> args2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.zunionstore(args2, (Handler<AsyncResult<Response>>)fut)));
    }

    public static RedisAPI api(Redis client) {
        RedisAPI ret = RedisAPI.newInstance(io.vertx.redis.client.RedisAPI.api((io.vertx.redis.client.Redis)client.getDelegate()));
        return ret;
    }

    public static RedisAPI api(RedisConnection connection) {
        RedisAPI ret = RedisAPI.newInstance(io.vertx.redis.client.RedisAPI.api((io.vertx.redis.client.RedisConnection)connection.getDelegate()));
        return ret;
    }

    public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
        return arg != null ? new RedisAPI(arg) : null;
    }
}

