/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.redis.client.RedisOptions;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.redis.client.RedisConnection;
import io.vertx.rxjava.redis.client.Request;
import io.vertx.rxjava.redis.client.Response;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg<Redis>(obj2 -> new Redis((io.vertx.redis.client.Redis)obj2), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public Redis(Object delegate) {
        this.delegate = (io.vertx.redis.client.Redis)delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public static Redis createClient(io.vertx.rxjava.core.Vertx vertx) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava.core.Vertx vertx, String connectionString) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (String)connectionString));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava.core.Vertx vertx, RedisOptions options2) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options2));
        return ret;
    }

    public Redis connect(final Handler<AsyncResult<RedisConnection>> handler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.redis.client.RedisConnection>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.RedisConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(RedisConnection.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Redis connect() {
        return this.connect(ar -> {});
    }

    public Single<RedisConnection> rxConnect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<RedisConnection>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public Redis send(Request command2, final Handler<AsyncResult<Response>> onSend2) {
        this.delegate.send(command2.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend2.handle(Future.succeededFuture(Response.newInstance(ar.result())));
                } else {
                    onSend2.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Redis send(Request command2) {
        return this.send(command2, ar -> {});
    }

    public Single<Response> rxSend(Request command2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(command2, (Handler<AsyncResult<Response>>)fut)));
    }

    public Redis batch(List<Request> commands, final Handler<AsyncResult<List<Response>>> onSend2) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            @Override
            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    onSend2.handle(Future.succeededFuture(ar.result().stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    onSend2.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Redis batch(List<Request> commands) {
        return this.batch(commands, ar -> {});
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)fut)));
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

