/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.rabbitmq.RabbitMQConsumer;
import io.vertx.rxjava.rabbitmq.RabbitMQMessage;
import java.util.Map;
import rx.Single;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg<RabbitMQClient>(obj2 -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj2), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        this.basicAck(deliveryTag, multiple, ar -> {});
    }

    public Single<Void> rxBasicAck(long deliveryTag, boolean multiple) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.basicNack(deliveryTag, multiple, requeue, ar -> {});
    }

    public Single<Void> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicGet(String queue2, boolean autoAck, final Handler<AsyncResult<RabbitMQMessage>> resultHandler) {
        this.delegate.basicGet(queue2, autoAck, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQMessage>>(){

            @Override
            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQMessage> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(RabbitMQMessage.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void basicGet(String queue2, boolean autoAck) {
        this.basicGet(queue2, autoAck, ar -> {});
    }

    public Single<RabbitMQMessage> rxBasicGet(String queue2, boolean autoAck) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicGet(queue2, autoAck, (Handler<AsyncResult<RabbitMQMessage>>)fut)));
    }

    public void basicConsumer(String queue2, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue2, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(RabbitMQConsumer.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void basicConsumer(String queue2) {
        this.basicConsumer(queue2, (AsyncResult<RabbitMQConsumer> ar) -> {});
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicConsumer(queue2, (Handler<AsyncResult<RabbitMQConsumer>>)fut)));
    }

    public void basicConsumer(String queue2, QueueOptions options2, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue2, options2, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(RabbitMQConsumer.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void basicConsumer(String queue2, QueueOptions options2) {
        this.basicConsumer(queue2, options2, ar -> {});
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue2, QueueOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicConsumer(queue2, options2, (Handler<AsyncResult<RabbitMQConsumer>>)fut)));
    }

    public void basicPublish(String exchange, String routingKey, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler);
    }

    public void basicPublish(String exchange, String routingKey, Buffer body) {
        this.basicPublish(exchange, routingKey, body, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxBasicPublish(String exchange, String routingKey, Buffer body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicPublish(exchange, routingKey, body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void addConfirmListener(int maxQueueSize, final Handler<AsyncResult<ReadStream<RabbitMQConfirmation>>> resultHandler) {
        this.delegate.addConfirmListener(maxQueueSize, (Handler)new Handler<AsyncResult<io.vertx.core.streams.ReadStream<RabbitMQConfirmation>>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.streams.ReadStream<RabbitMQConfirmation>> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(ReadStream.newInstance(ar.result(), TypeArg.unknown())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void addConfirmListener(int maxQueueSize) {
        this.addConfirmListener(maxQueueSize, ar -> {});
    }

    public Single<ReadStream<RabbitMQConfirmation>> rxAddConfirmListener(int maxQueueSize) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.addConfirmListener(maxQueueSize, (Handler<AsyncResult<ReadStream<RabbitMQConfirmation>>>)fut)));
    }

    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.confirmSelect(resultHandler);
    }

    public void confirmSelect() {
        this.confirmSelect(ar -> {});
    }

    public Single<Void> rxConfirmSelect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.confirmSelect((Handler<AsyncResult<Void>>)fut)));
    }

    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(resultHandler);
    }

    public void waitForConfirms() {
        this.waitForConfirms(ar -> {});
    }

    public Single<Void> rxWaitForConfirms() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.waitForConfirms((Handler<AsyncResult<Void>>)fut)));
    }

    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(timeout, resultHandler);
    }

    public void waitForConfirms(long timeout) {
        this.waitForConfirms(timeout, ar -> {});
    }

    public Single<Void> rxWaitForConfirms(long timeout) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, resultHandler);
    }

    public void basicQos(int prefetchCount) {
        this.basicQos(prefetchCount, ar -> {});
    }

    public Single<Void> rxBasicQos(int prefetchCount) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, global, resultHandler);
    }

    public void basicQos(int prefetchCount, boolean global) {
        this.basicQos(prefetchCount, global, ar -> {});
    }

    public Single<Void> rxBasicQos(int prefetchCount, boolean global) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
        this.basicQos(prefetchSize, prefetchCount, global, ar -> {});
    }

    public Single<Void> rxBasicQos(int prefetchSize, int prefetchCount, boolean global) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDeclare(String exchange, String type2, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type2, durable, autoDelete, resultHandler);
    }

    public void exchangeDeclare(String exchange, String type2, boolean durable, boolean autoDelete) {
        this.exchangeDeclare(exchange, type2, durable, autoDelete, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxExchangeDeclare(String exchange, String type2, boolean durable, boolean autoDelete) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeDeclare(exchange, type2, durable, autoDelete, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDeclare(String exchange, String type2, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type2, durable, autoDelete, config, resultHandler);
    }

    public void exchangeDeclare(String exchange, String type2, boolean durable, boolean autoDelete, JsonObject config) {
        this.exchangeDeclare(exchange, type2, durable, autoDelete, config, ar -> {});
    }

    public Single<Void> rxExchangeDeclare(String exchange, String type2, boolean durable, boolean autoDelete, JsonObject config) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeDeclare(exchange, type2, durable, autoDelete, config, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, resultHandler);
    }

    public void exchangeDelete(String exchange) {
        this.exchangeDelete(exchange, ar -> {});
    }

    public Single<Void> rxExchangeDelete(String exchange) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeBind(String destination, String source2, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source2, routingKey, resultHandler);
    }

    public void exchangeBind(String destination, String source2, String routingKey) {
        this.exchangeBind(destination, source2, routingKey, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxExchangeBind(String destination, String source2, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeBind(destination, source2, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeBind(String destination, String source2, String routingKey, Map<String, Object> arguments2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source2, routingKey, arguments2, resultHandler);
    }

    public void exchangeBind(String destination, String source2, String routingKey, Map<String, Object> arguments2) {
        this.exchangeBind(destination, source2, routingKey, arguments2, ar -> {});
    }

    public Single<Void> rxExchangeBind(String destination, String source2, String routingKey, Map<String, Object> arguments2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeBind(destination, source2, routingKey, arguments2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeUnbind(String destination, String source2, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source2, routingKey, resultHandler);
    }

    public void exchangeUnbind(String destination, String source2, String routingKey) {
        this.exchangeUnbind(destination, source2, routingKey, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxExchangeUnbind(String destination, String source2, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeUnbind(destination, source2, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeUnbind(String destination, String source2, String routingKey, Map<String, Object> arguments2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source2, routingKey, arguments2, resultHandler);
    }

    public void exchangeUnbind(String destination, String source2, String routingKey, Map<String, Object> arguments2) {
        this.exchangeUnbind(destination, source2, routingKey, arguments2, ar -> {});
    }

    public Single<Void> rxExchangeUnbind(String destination, String source2, String routingKey, Map<String, Object> arguments2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeUnbind(destination, source2, routingKey, arguments2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    public void queueDeclareAuto() {
        this.queueDeclareAuto(ar -> {});
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueBind(String queue2, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue2, exchange, routingKey, resultHandler);
    }

    public void queueBind(String queue2, String exchange, String routingKey) {
        this.queueBind(queue2, exchange, routingKey, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxQueueBind(String queue2, String exchange, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueBind(queue2, exchange, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueBind(String queue2, String exchange, String routingKey, Map<String, Object> arguments2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue2, exchange, routingKey, arguments2, resultHandler);
    }

    public void queueBind(String queue2, String exchange, String routingKey, Map<String, Object> arguments2) {
        this.queueBind(queue2, exchange, routingKey, arguments2, ar -> {});
    }

    public Single<Void> rxQueueBind(String queue2, String exchange, String routingKey, Map<String, Object> arguments2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueBind(queue2, exchange, routingKey, arguments2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueUnbind(String queue2, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue2, exchange, routingKey, resultHandler);
    }

    public void queueUnbind(String queue2, String exchange, String routingKey) {
        this.queueUnbind(queue2, exchange, routingKey, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxQueueUnbind(String queue2, String exchange, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueUnbind(queue2, exchange, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueUnbind(String queue2, String exchange, String routingKey, Map<String, Object> arguments2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue2, exchange, routingKey, arguments2, resultHandler);
    }

    public void queueUnbind(String queue2, String exchange, String routingKey, Map<String, Object> arguments2) {
        this.queueUnbind(queue2, exchange, routingKey, arguments2, ar -> {});
    }

    public Single<Void> rxQueueUnbind(String queue2, String exchange, String routingKey, Map<String, Object> arguments2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueUnbind(queue2, exchange, routingKey, arguments2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void messageCount(String queue2, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.messageCount(queue2, resultHandler);
    }

    public void messageCount(String queue2) {
        this.messageCount(queue2, ar -> {});
    }

    public Single<Long> rxMessageCount(String queue2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.messageCount(queue2, (Handler<AsyncResult<Long>>)fut)));
    }

    public void start(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(resultHandler);
    }

    public void start() {
        this.start(ar -> {});
    }

    public Single<Void> rxStart() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.start((Handler<AsyncResult<Void>>)fut)));
    }

    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(resultHandler);
    }

    public void stop() {
        this.stop(ar -> {});
    }

    public Single<Void> rxStop() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.stop((Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public void restartConnect(int attempts, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.restartConnect(attempts, resultHandler);
    }

    public void restartConnect(int attempts) {
        this.restartConnect(attempts, ar -> {});
    }

    public Single<Void> rxRestartConnect(int attempts) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.restartConnect(attempts, (Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public void basicPublish(String exchange, String routingKey, BasicProperties properties2, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, properties2, body.getDelegate(), resultHandler);
    }

    public void basicPublish(String exchange, String routingKey, BasicProperties properties2, Buffer body) {
        this.basicPublish(exchange, routingKey, properties2, body, ar -> {});
    }

    public Single<Void> rxBasicPublish(String exchange, String routingKey, BasicProperties properties2, Buffer body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicPublish(exchange, routingKey, properties2, body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties2, Buffer body, Handler<Long> deliveryTagHandler, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties2, body.getDelegate(), deliveryTagHandler, resultHandler);
    }

    public void basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties2, Buffer body, Handler<Long> deliveryTagHandler) {
        this.basicPublishWithDeliveryTag(exchange, routingKey, properties2, body, deliveryTagHandler, ar -> {});
    }

    public Single<Void> rxBasicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties2, Buffer body, Handler<Long> deliveryTagHandler) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicPublishWithDeliveryTag(exchange, routingKey, properties2, body, deliveryTagHandler, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueDeclare(String queue2, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.delegate.queueDeclare(queue2, durable, exclusive, autoDelete, resultHandler);
    }

    public void queueDeclare(String queue2, boolean durable, boolean exclusive, boolean autoDelete) {
        this.queueDeclare(queue2, durable, exclusive, autoDelete, (AsyncResult<AMQP.Queue.DeclareOk> ar) -> {});
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue2, boolean durable, boolean exclusive, boolean autoDelete) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeclare(queue2, durable, exclusive, autoDelete, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)fut)));
    }

    public void queueDeclare(String queue2, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.delegate.queueDeclare(queue2, durable, exclusive, autoDelete, config, resultHandler);
    }

    public void queueDeclare(String queue2, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        this.queueDeclare(queue2, durable, exclusive, autoDelete, config, ar -> {});
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue2, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeclare(queue2, durable, exclusive, autoDelete, config, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)fut)));
    }

    public void queueDelete(String queue2, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.delegate.queueDelete(queue2, resultHandler);
    }

    public void queueDelete(String queue2) {
        this.queueDelete(queue2, ar -> {});
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDelete(String queue2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDelete(queue2, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)fut)));
    }

    public void queueDeleteIf(String queue2, boolean ifUnused, boolean ifEmpty2, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.delegate.queueDeleteIf(queue2, ifUnused, ifEmpty2, resultHandler);
    }

    public void queueDeleteIf(String queue2, boolean ifUnused, boolean ifEmpty2) {
        this.queueDeleteIf(queue2, ifUnused, ifEmpty2, ar -> {});
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDeleteIf(String queue2, boolean ifUnused, boolean ifEmpty2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeleteIf(queue2, ifUnused, ifEmpty2, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)fut)));
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

