/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.json.schema;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.json.pointer.JsonPointer;
import io.vertx.rxjava.json.schema.Schema;
import io.vertx.rxjava.json.schema.SchemaParser;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.json.schema.SchemaRouter.class)
public class SchemaRouter {
    public static final TypeArg<SchemaRouter> __TYPE_ARG = new TypeArg<SchemaRouter>(obj2 -> new SchemaRouter((io.vertx.json.schema.SchemaRouter)obj2), SchemaRouter::getDelegate);
    private final io.vertx.json.schema.SchemaRouter delegate;
    private static final TypeArg<Schema> TYPE_ARG_0 = new TypeArg<Schema>(o1 -> Schema.newInstance((io.vertx.json.schema.Schema)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRouter that = (SchemaRouter)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SchemaRouter(io.vertx.json.schema.SchemaRouter delegate) {
        this.delegate = delegate;
    }

    public SchemaRouter(Object delegate) {
        this.delegate = (io.vertx.json.schema.SchemaRouter)delegate;
    }

    public io.vertx.json.schema.SchemaRouter getDelegate() {
        return this.delegate;
    }

    public Schema resolveCachedSchema(JsonPointer refPointer, JsonPointer schemaScope, SchemaParser parser) {
        Schema ret = Schema.newInstance(this.delegate.resolveCachedSchema(refPointer.getDelegate(), schemaScope.getDelegate(), parser.getDelegate()));
        return ret;
    }

    public void resolveRef(JsonPointer pointer, JsonPointer scope2, SchemaParser schemaParser, final Handler<AsyncResult<Schema>> handler) {
        this.delegate.resolveRef(pointer.getDelegate(), scope2.getDelegate(), schemaParser.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.json.schema.Schema>>(){

            @Override
            public void handle(AsyncResult<io.vertx.json.schema.Schema> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Schema.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void resolveRef(JsonPointer pointer, JsonPointer scope2, SchemaParser schemaParser) {
        this.resolveRef(pointer, scope2, schemaParser, ar -> {});
    }

    public Single<Schema> rxResolveRef(JsonPointer pointer, JsonPointer scope2, SchemaParser schemaParser) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveRef(pointer, scope2, schemaParser, (Handler<AsyncResult<Schema>>)fut)));
    }

    public SchemaRouter addSchemaWithScope(Schema schema2, JsonPointer scope2) {
        this.delegate.addSchemaWithScope(schema2.getDelegate(), scope2.getDelegate());
        return this;
    }

    public SchemaRouter addSchemaAlias(Schema schema2, String alias2) {
        this.delegate.addSchemaAlias(schema2.getDelegate(), alias2);
        return this;
    }

    public SchemaRouter addJson(String uri, JsonObject object) {
        this.delegate.addJson(uri, object);
        return this;
    }

    public List<Schema> registeredSchemas() {
        List<Schema> ret = this.delegate.registeredSchemas().stream().map(elt -> Schema.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public static SchemaRouter create(io.vertx.rxjava.core.Vertx vertx, SchemaRouterOptions schemaRouterOptions) {
        SchemaRouter ret = SchemaRouter.newInstance(io.vertx.json.schema.SchemaRouter.create((Vertx)vertx.getDelegate(), (SchemaRouterOptions)schemaRouterOptions));
        return ret;
    }

    public static SchemaRouter create(io.vertx.rxjava.core.Vertx vertx, io.vertx.rxjava.core.http.HttpClient client, io.vertx.rxjava.core.file.FileSystem fs, SchemaRouterOptions schemaRouterOptions) {
        SchemaRouter ret = SchemaRouter.newInstance(io.vertx.json.schema.SchemaRouter.create((Vertx)vertx.getDelegate(), (HttpClient)client.getDelegate(), (FileSystem)fs.getDelegate(), (SchemaRouterOptions)schemaRouterOptions));
        return ret;
    }

    public SchemaRouter addSchema(Schema schema2, io.vertx.core.json.pointer.JsonPointer[] aliasScopes) {
        this.delegate.addSchema(schema2.getDelegate(), aliasScopes);
        return this;
    }

    public SchemaRouter addJson(URI uri, JsonObject object) {
        this.delegate.addJson(uri, object);
        return this;
    }

    public static SchemaRouter newInstance(io.vertx.json.schema.SchemaRouter arg) {
        return arg != null ? new SchemaRouter(arg) : null;
    }
}

