/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.web;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava.ext.web.Router;
import io.vertx.rxjava.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@RxGen(value=io.vertx.ext.web.Route.class)
public class Route {
    public static final TypeArg<Route> __TYPE_ARG = new TypeArg<Route>(obj2 -> new Route((io.vertx.ext.web.Route)obj2), Route::getDelegate);
    private final io.vertx.ext.web.Route delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route that = (Route)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Route(io.vertx.ext.web.Route delegate) {
        this.delegate = delegate;
    }

    public Route(Object delegate) {
        this.delegate = (io.vertx.ext.web.Route)delegate;
    }

    public io.vertx.ext.web.Route getDelegate() {
        return this.delegate;
    }

    public Route method(HttpMethod method) {
        this.delegate.method(method);
        return this;
    }

    public Route path(String path2) {
        this.delegate.path(path2);
        return this;
    }

    public Route pathRegex(String path2) {
        this.delegate.pathRegex(path2);
        return this;
    }

    public Route produces(String contentType) {
        this.delegate.produces(contentType);
        return this;
    }

    public Route consumes(String contentType) {
        this.delegate.consumes(contentType);
        return this;
    }

    public Route virtualHost(String hostnamePattern) {
        this.delegate.virtualHost(hostnamePattern);
        return this;
    }

    public Route order(int order) {
        this.delegate.order(order);
        return this;
    }

    public Route last() {
        this.delegate.last();
        return this;
    }

    public Route handler(final Handler<RoutingContext> requestHandler) {
        this.delegate.handler(new Handler<io.vertx.ext.web.RoutingContext>(){

            @Override
            public void handle(io.vertx.ext.web.RoutingContext event) {
                requestHandler.handle(RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public Route blockingHandler(final Handler<RoutingContext> requestHandler) {
        this.delegate.blockingHandler(new Handler<io.vertx.ext.web.RoutingContext>(){

            @Override
            public void handle(io.vertx.ext.web.RoutingContext event) {
                requestHandler.handle(RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public Route subRouter(Router subRouter) {
        this.delegate.subRouter(subRouter.getDelegate());
        return this;
    }

    public Route blockingHandler(final Handler<RoutingContext> requestHandler, boolean ordered) {
        this.delegate.blockingHandler(new Handler<io.vertx.ext.web.RoutingContext>(){

            @Override
            public void handle(io.vertx.ext.web.RoutingContext event) {
                requestHandler.handle(RoutingContext.newInstance(event));
            }
        }, ordered);
        return this;
    }

    public Route failureHandler(final Handler<RoutingContext> failureHandler) {
        this.delegate.failureHandler(new Handler<io.vertx.ext.web.RoutingContext>(){

            @Override
            public void handle(io.vertx.ext.web.RoutingContext event) {
                failureHandler.handle(RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public Route remove() {
        this.delegate.remove();
        return this;
    }

    public Route disable() {
        this.delegate.disable();
        return this;
    }

    public Route enable() {
        this.delegate.enable();
        return this;
    }

    @Deprecated
    public Route useNormalisedPath(boolean useNormalizedPath) {
        this.delegate.useNormalisedPath(useNormalizedPath);
        return this;
    }

    public Route useNormalizedPath(boolean useNormalizedPath) {
        this.delegate.useNormalizedPath(useNormalizedPath);
        return this;
    }

    public <T> T getMetadata(String key2) {
        Object ret = this.delegate.getMetadata(key2);
        return ret;
    }

    public String getPath() {
        String ret = this.delegate.getPath();
        return ret;
    }

    public boolean isRegexPath() {
        boolean ret = this.delegate.isRegexPath();
        return ret;
    }

    public boolean isExactPath() {
        boolean ret = this.delegate.isExactPath();
        return ret;
    }

    public Set<HttpMethod> methods() {
        Set<HttpMethod> ret = this.delegate.methods();
        return ret;
    }

    public Route setRegexGroupsNames(List<String> groups2) {
        this.delegate.setRegexGroupsNames(groups2);
        return this;
    }

    public Route setName(String name2) {
        this.delegate.setName(name2);
        return this;
    }

    public String getName() {
        String ret = this.delegate.getName();
        return ret;
    }

    public <T> Route respond(final Function<RoutingContext, Future<T>> function) {
        this.delegate.respond(new Function<io.vertx.ext.web.RoutingContext, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.ext.web.RoutingContext arg) {
                Future ret = (Future)function.apply(RoutingContext.newInstance(arg));
                return ret.map(val2 -> val2);
            }
        });
        return this;
    }

    public Route putMetadata(String key2, Object value) {
        this.delegate.putMetadata(key2, value);
        return this;
    }

    public Map<String, Object> metadata() {
        Map<String, Object> ret = this.delegate.metadata();
        return ret;
    }

    public static Route newInstance(io.vertx.ext.web.Route arg) {
        return arg != null ? new Route(arg) : null;
    }
}

