/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.ext.mongo.MongoGridFsClient;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.ext.mongo.MongoClient.class)
public class MongoClient {
    public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg<MongoClient>(obj2 -> new MongoClient((io.vertx.ext.mongo.MongoClient)obj2), MongoClient::getDelegate);
    private final io.vertx.ext.mongo.MongoClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClient that = (MongoClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
        this.delegate = delegate;
    }

    public MongoClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
    }

    public io.vertx.ext.mongo.MongoClient getDelegate() {
        return this.delegate;
    }

    public static MongoClient create(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.create((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config, String dataSourceName) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)dataSourceName));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public MongoClient save(String collection2, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.save(collection2, document, resultHandler);
        return this;
    }

    public MongoClient save(String collection2, JsonObject document) {
        return this.save(collection2, document, ar -> {});
    }

    public Single<String> rxSave(String collection2, JsonObject document) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.save(collection2, document, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient saveWithOptions(String collection2, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.saveWithOptions(collection2, document, writeOption, resultHandler);
        return this;
    }

    public MongoClient saveWithOptions(String collection2, JsonObject document, WriteOption writeOption) {
        return this.saveWithOptions(collection2, document, writeOption, ar -> {});
    }

    public Single<String> rxSaveWithOptions(String collection2, JsonObject document, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.saveWithOptions(collection2, document, writeOption, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient insert(String collection2, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insert(collection2, document, resultHandler);
        return this;
    }

    public MongoClient insert(String collection2, JsonObject document) {
        return this.insert(collection2, document, ar -> {});
    }

    public Single<String> rxInsert(String collection2, JsonObject document) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.insert(collection2, document, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient insertWithOptions(String collection2, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insertWithOptions(collection2, document, writeOption, resultHandler);
        return this;
    }

    public MongoClient insertWithOptions(String collection2, JsonObject document, WriteOption writeOption) {
        return this.insertWithOptions(collection2, document, writeOption, ar -> {});
    }

    public Single<String> rxInsertWithOptions(String collection2, JsonObject document, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.insertWithOptions(collection2, document, writeOption, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoClient updateCollection(String collection2, JsonObject query, JsonObject update2, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollection(collection2, query, update2, resultHandler);
        return this;
    }

    public MongoClient updateCollection(String collection2, JsonObject query, JsonObject update2) {
        return this.updateCollection(collection2, query, update2, (AsyncResult<MongoClientUpdateResult> ar) -> {});
    }

    public Single<MongoClientUpdateResult> rxUpdateCollection(String collection2, JsonObject query, JsonObject update2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateCollection(collection2, query, update2, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient updateCollection(String collection2, JsonObject query, JsonArray update2, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollection(collection2, query, update2, resultHandler);
        return this;
    }

    public MongoClient updateCollection(String collection2, JsonObject query, JsonArray update2) {
        return this.updateCollection(collection2, query, update2, (AsyncResult<MongoClientUpdateResult> ar) -> {});
    }

    public Single<MongoClientUpdateResult> rxUpdateCollection(String collection2, JsonObject query, JsonArray update2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateCollection(collection2, query, update2, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient updateCollectionWithOptions(String collection2, JsonObject query, JsonObject update2, UpdateOptions options2, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollectionWithOptions(collection2, query, update2, options2, resultHandler);
        return this;
    }

    public MongoClient updateCollectionWithOptions(String collection2, JsonObject query, JsonObject update2, UpdateOptions options2) {
        return this.updateCollectionWithOptions(collection2, query, update2, options2, (AsyncResult<MongoClientUpdateResult> ar) -> {});
    }

    public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection2, JsonObject query, JsonObject update2, UpdateOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateCollectionWithOptions(collection2, query, update2, options2, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient updateCollectionWithOptions(String collection2, JsonObject query, JsonArray update2, UpdateOptions options2, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollectionWithOptions(collection2, query, update2, options2, resultHandler);
        return this;
    }

    public MongoClient updateCollectionWithOptions(String collection2, JsonObject query, JsonArray update2, UpdateOptions options2) {
        return this.updateCollectionWithOptions(collection2, query, update2, options2, (AsyncResult<MongoClientUpdateResult> ar) -> {});
    }

    public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection2, JsonObject query, JsonArray update2, UpdateOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateCollectionWithOptions(collection2, query, update2, options2, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient replaceDocuments(String collection2, JsonObject query, JsonObject replace2, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocuments(collection2, query, replace2, resultHandler);
        return this;
    }

    public MongoClient replaceDocuments(String collection2, JsonObject query, JsonObject replace2) {
        return this.replaceDocuments(collection2, query, replace2, ar -> {});
    }

    public Single<MongoClientUpdateResult> rxReplaceDocuments(String collection2, JsonObject query, JsonObject replace2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replaceDocuments(collection2, query, replace2, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient replaceDocumentsWithOptions(String collection2, JsonObject query, JsonObject replace2, UpdateOptions options2, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocumentsWithOptions(collection2, query, replace2, options2, resultHandler);
        return this;
    }

    public MongoClient replaceDocumentsWithOptions(String collection2, JsonObject query, JsonObject replace2, UpdateOptions options2) {
        return this.replaceDocumentsWithOptions(collection2, query, replace2, options2, ar -> {});
    }

    public Single<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection2, JsonObject query, JsonObject replace2, UpdateOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.replaceDocumentsWithOptions(collection2, query, replace2, options2, (Handler<AsyncResult<MongoClientUpdateResult>>)fut)));
    }

    public MongoClient bulkWrite(String collection2, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWrite(collection2, operations, resultHandler);
        return this;
    }

    public MongoClient bulkWrite(String collection2, List<BulkOperation> operations) {
        return this.bulkWrite(collection2, operations, ar -> {});
    }

    public Single<MongoClientBulkWriteResult> rxBulkWrite(String collection2, List<BulkOperation> operations) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bulkWrite(collection2, operations, (Handler<AsyncResult<MongoClientBulkWriteResult>>)fut)));
    }

    public MongoClient bulkWriteWithOptions(String collection2, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWriteWithOptions(collection2, operations, bulkWriteOptions, resultHandler);
        return this;
    }

    public MongoClient bulkWriteWithOptions(String collection2, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return this.bulkWriteWithOptions(collection2, operations, bulkWriteOptions, ar -> {});
    }

    public Single<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection2, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.bulkWriteWithOptions(collection2, operations, bulkWriteOptions, (Handler<AsyncResult<MongoClientBulkWriteResult>>)fut)));
    }

    public MongoClient find(String collection2, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.find(collection2, query, resultHandler);
        return this;
    }

    public MongoClient find(String collection2, JsonObject query) {
        return this.find(collection2, query, ar -> {});
    }

    public Single<List<JsonObject>> rxFind(String collection2, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.find(collection2, query, (Handler<AsyncResult<List<JsonObject>>>)fut)));
    }

    public ReadStream<JsonObject> findBatch(String collection2, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatch(collection2, query), TypeArg.unknown());
        return ret;
    }

    public MongoClient findWithOptions(String collection2, JsonObject query, FindOptions options2, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.findWithOptions(collection2, query, options2, resultHandler);
        return this;
    }

    public MongoClient findWithOptions(String collection2, JsonObject query, FindOptions options2) {
        return this.findWithOptions(collection2, query, options2, ar -> {});
    }

    public Single<List<JsonObject>> rxFindWithOptions(String collection2, JsonObject query, FindOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findWithOptions(collection2, query, options2, (Handler<AsyncResult<List<JsonObject>>>)fut)));
    }

    public ReadStream<JsonObject> findBatchWithOptions(String collection2, JsonObject query, FindOptions options2) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatchWithOptions(collection2, query, options2), TypeArg.unknown());
        return ret;
    }

    public MongoClient findOne(String collection2, JsonObject query, JsonObject fields2, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOne(collection2, query, fields2, resultHandler);
        return this;
    }

    public MongoClient findOne(String collection2, JsonObject query, JsonObject fields2) {
        return this.findOne(collection2, query, fields2, ar -> {});
    }

    public Single<JsonObject> rxFindOne(String collection2, JsonObject query, JsonObject fields2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOne(collection2, query, fields2, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndUpdate(String collection2, JsonObject query, JsonObject update2, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdate(collection2, query, update2, resultHandler);
        return this;
    }

    public MongoClient findOneAndUpdate(String collection2, JsonObject query, JsonObject update2) {
        return this.findOneAndUpdate(collection2, query, update2, ar -> {});
    }

    public Single<JsonObject> rxFindOneAndUpdate(String collection2, JsonObject query, JsonObject update2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndUpdate(collection2, query, update2, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndUpdateWithOptions(String collection2, JsonObject query, JsonObject update2, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdateWithOptions(collection2, query, update2, findOptions, updateOptions, resultHandler);
        return this;
    }

    public MongoClient findOneAndUpdateWithOptions(String collection2, JsonObject query, JsonObject update2, FindOptions findOptions, UpdateOptions updateOptions) {
        return this.findOneAndUpdateWithOptions(collection2, query, update2, findOptions, updateOptions, ar -> {});
    }

    public Single<JsonObject> rxFindOneAndUpdateWithOptions(String collection2, JsonObject query, JsonObject update2, FindOptions findOptions, UpdateOptions updateOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndUpdateWithOptions(collection2, query, update2, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndReplace(String collection2, JsonObject query, JsonObject replace2, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplace(collection2, query, replace2, resultHandler);
        return this;
    }

    public MongoClient findOneAndReplace(String collection2, JsonObject query, JsonObject replace2) {
        return this.findOneAndReplace(collection2, query, replace2, ar -> {});
    }

    public Single<JsonObject> rxFindOneAndReplace(String collection2, JsonObject query, JsonObject replace2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndReplace(collection2, query, replace2, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndReplaceWithOptions(String collection2, JsonObject query, JsonObject replace2, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplaceWithOptions(collection2, query, replace2, findOptions, updateOptions, resultHandler);
        return this;
    }

    public MongoClient findOneAndReplaceWithOptions(String collection2, JsonObject query, JsonObject replace2, FindOptions findOptions, UpdateOptions updateOptions) {
        return this.findOneAndReplaceWithOptions(collection2, query, replace2, findOptions, updateOptions, ar -> {});
    }

    public Single<JsonObject> rxFindOneAndReplaceWithOptions(String collection2, JsonObject query, JsonObject replace2, FindOptions findOptions, UpdateOptions updateOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndReplaceWithOptions(collection2, query, replace2, findOptions, updateOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndDelete(String collection2, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDelete(collection2, query, resultHandler);
        return this;
    }

    public MongoClient findOneAndDelete(String collection2, JsonObject query) {
        return this.findOneAndDelete(collection2, query, ar -> {});
    }

    public Single<JsonObject> rxFindOneAndDelete(String collection2, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndDelete(collection2, query, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient findOneAndDeleteWithOptions(String collection2, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDeleteWithOptions(collection2, query, findOptions, resultHandler);
        return this;
    }

    public MongoClient findOneAndDeleteWithOptions(String collection2, JsonObject query, FindOptions findOptions) {
        return this.findOneAndDeleteWithOptions(collection2, query, findOptions, ar -> {});
    }

    public Single<JsonObject> rxFindOneAndDeleteWithOptions(String collection2, JsonObject query, FindOptions findOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.findOneAndDeleteWithOptions(collection2, query, findOptions, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient count(String collection2, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.count(collection2, query, resultHandler);
        return this;
    }

    public MongoClient count(String collection2, JsonObject query) {
        return this.count(collection2, query, ar -> {});
    }

    public Single<Long> rxCount(String collection2, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.count(collection2, query, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoClient countWithOptions(String collection2, JsonObject query, CountOptions countOptions, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.countWithOptions(collection2, query, countOptions, resultHandler);
        return this;
    }

    public MongoClient countWithOptions(String collection2, JsonObject query, CountOptions countOptions) {
        return this.countWithOptions(collection2, query, countOptions, ar -> {});
    }

    public Single<Long> rxCountWithOptions(String collection2, JsonObject query, CountOptions countOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.countWithOptions(collection2, query, countOptions, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoClient removeDocuments(String collection2, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocuments(collection2, query, resultHandler);
        return this;
    }

    public MongoClient removeDocuments(String collection2, JsonObject query) {
        return this.removeDocuments(collection2, query, ar -> {});
    }

    public Single<MongoClientDeleteResult> rxRemoveDocuments(String collection2, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocuments(collection2, query, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient removeDocumentsWithOptions(String collection2, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentsWithOptions(collection2, query, writeOption, resultHandler);
        return this;
    }

    public MongoClient removeDocumentsWithOptions(String collection2, JsonObject query, WriteOption writeOption) {
        return this.removeDocumentsWithOptions(collection2, query, writeOption, ar -> {});
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection2, JsonObject query, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocumentsWithOptions(collection2, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient removeDocument(String collection2, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocument(collection2, query, resultHandler);
        return this;
    }

    public MongoClient removeDocument(String collection2, JsonObject query) {
        return this.removeDocument(collection2, query, ar -> {});
    }

    public Single<MongoClientDeleteResult> rxRemoveDocument(String collection2, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocument(collection2, query, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient removeDocumentWithOptions(String collection2, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentWithOptions(collection2, query, writeOption, resultHandler);
        return this;
    }

    public MongoClient removeDocumentWithOptions(String collection2, JsonObject query, WriteOption writeOption) {
        return this.removeDocumentWithOptions(collection2, query, writeOption, ar -> {});
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection2, JsonObject query, WriteOption writeOption) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.removeDocumentWithOptions(collection2, query, writeOption, (Handler<AsyncResult<MongoClientDeleteResult>>)fut)));
    }

    public MongoClient createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createCollection(collectionName, resultHandler);
        return this;
    }

    public MongoClient createCollection(String collectionName) {
        return this.createCollection(collectionName, ar -> {});
    }

    public Single<Void> rxCreateCollection(String collectionName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createCollection(collectionName, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler);
        return this;
    }

    public MongoClient createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return this.createCollectionWithOptions(collectionName, collectionOptions, ar -> {});
    }

    public Single<Void> rxCreateCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createCollectionWithOptions(collectionName, collectionOptions, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.getCollections(resultHandler);
        return this;
    }

    public MongoClient getCollections() {
        return this.getCollections(ar -> {});
    }

    public Single<List<String>> rxGetCollections() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.getCollections((Handler<AsyncResult<List<String>>>)fut)));
    }

    public MongoClient dropCollection(String collection2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropCollection(collection2, resultHandler);
        return this;
    }

    public MongoClient dropCollection(String collection2) {
        return this.dropCollection(collection2, ar -> {});
    }

    public Single<Void> rxDropCollection(String collection2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.dropCollection(collection2, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndex(String collection2, JsonObject key2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndex(collection2, key2, resultHandler);
        return this;
    }

    public MongoClient createIndex(String collection2, JsonObject key2) {
        return this.createIndex(collection2, key2, ar -> {});
    }

    public Single<Void> rxCreateIndex(String collection2, JsonObject key2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createIndex(collection2, key2, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndexWithOptions(String collection2, JsonObject key2, IndexOptions options2, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndexWithOptions(collection2, key2, options2, resultHandler);
        return this;
    }

    public MongoClient createIndexWithOptions(String collection2, JsonObject key2, IndexOptions options2) {
        return this.createIndexWithOptions(collection2, key2, options2, ar -> {});
    }

    public Single<Void> rxCreateIndexWithOptions(String collection2, JsonObject key2, IndexOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createIndexWithOptions(collection2, key2, options2, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient createIndexes(String collection2, List<IndexModel> indexes, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndexes(collection2, indexes, resultHandler);
        return this;
    }

    public MongoClient createIndexes(String collection2, List<IndexModel> indexes) {
        return this.createIndexes(collection2, indexes, ar -> {});
    }

    public Single<Void> rxCreateIndexes(String collection2, List<IndexModel> indexes) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createIndexes(collection2, indexes, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient listIndexes(String collection2, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.listIndexes(collection2, resultHandler);
        return this;
    }

    public MongoClient listIndexes(String collection2) {
        return this.listIndexes(collection2, ar -> {});
    }

    public Single<JsonArray> rxListIndexes(String collection2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listIndexes(collection2, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient dropIndex(String collection2, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropIndex(collection2, indexName, resultHandler);
        return this;
    }

    public MongoClient dropIndex(String collection2, String indexName) {
        return this.dropIndex(collection2, indexName, ar -> {});
    }

    public Single<Void> rxDropIndex(String collection2, String indexName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.dropIndex(collection2, indexName, (Handler<AsyncResult<Void>>)fut)));
    }

    public MongoClient runCommand(String commandName, JsonObject command2, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.runCommand(commandName, command2, resultHandler);
        return this;
    }

    public MongoClient runCommand(String commandName, JsonObject command2) {
        return this.runCommand(commandName, command2, ar -> {});
    }

    public Single<JsonObject> rxRunCommand(String commandName, JsonObject command2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.runCommand(commandName, command2, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public MongoClient distinct(String collection2, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinct(collection2, fieldName, resultClassname, resultHandler);
        return this;
    }

    public MongoClient distinct(String collection2, String fieldName, String resultClassname) {
        return this.distinct(collection2, fieldName, resultClassname, (AsyncResult<JsonArray> ar) -> {});
    }

    public Single<JsonArray> rxDistinct(String collection2, String fieldName, String resultClassname) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.distinct(collection2, fieldName, resultClassname, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient distinct(String collection2, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler, DistinctOptions distinctOptions) {
        this.delegate.distinct(collection2, fieldName, resultClassname, resultHandler, distinctOptions);
        return this;
    }

    public Future<JsonArray> distinct(String collection2, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        AsyncResult ret = this.delegate.distinct(collection2, fieldName, resultClassname, distinctOptions).map(val2 -> val2);
        return ret;
    }

    public MongoClient distinctWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinctWithQuery(collection2, fieldName, resultClassname, query, resultHandler);
        return this;
    }

    public MongoClient distinctWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctWithQuery(collection2, fieldName, resultClassname, query, (AsyncResult<JsonArray> ar) -> {});
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.distinctWithQuery(collection2, fieldName, resultClassname, query, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public MongoClient distinctWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler, DistinctOptions distinctOptions) {
        this.delegate.distinctWithQuery(collection2, fieldName, resultClassname, query, resultHandler, distinctOptions);
        return this;
    }

    public Future<JsonArray> distinctWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        AsyncResult ret = this.delegate.distinctWithQuery(collection2, fieldName, resultClassname, query, distinctOptions).map(val2 -> val2);
        return ret;
    }

    public ReadStream<JsonObject> distinctBatch(String collection2, String fieldName, String resultClassname) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection2, fieldName, resultClassname), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatch(String collection2, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection2, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection2, fieldName, resultClassname, query), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection2, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection2, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection2, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection2, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregate(String collection2, JsonArray pipeline) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregate(collection2, pipeline), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregateWithOptions(String collection2, JsonArray pipeline, AggregateOptions options2) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregateWithOptions(collection2, pipeline, options2), TypeArg.unknown());
        return ret;
    }

    public MongoClient createDefaultGridFsBucketService(final Handler<AsyncResult<MongoGridFsClient>> resultHandler) {
        this.delegate.createDefaultGridFsBucketService((Handler)new Handler<AsyncResult<io.vertx.ext.mongo.MongoGridFsClient>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.mongo.MongoGridFsClient> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(MongoGridFsClient.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public MongoClient createDefaultGridFsBucketService() {
        return this.createDefaultGridFsBucketService(ar -> {});
    }

    public Single<MongoGridFsClient> rxCreateDefaultGridFsBucketService() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createDefaultGridFsBucketService((Handler<AsyncResult<MongoGridFsClient>>)fut)));
    }

    public MongoClient createGridFsBucketService(String bucketName, final Handler<AsyncResult<MongoGridFsClient>> resultHandler) {
        this.delegate.createGridFsBucketService(bucketName, (Handler)new Handler<AsyncResult<io.vertx.ext.mongo.MongoGridFsClient>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.mongo.MongoGridFsClient> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(MongoGridFsClient.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public MongoClient createGridFsBucketService(String bucketName) {
        return this.createGridFsBucketService(bucketName, ar -> {});
    }

    public Single<MongoGridFsClient> rxCreateGridFsBucketService(String bucketName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createGridFsBucketService(bucketName, (Handler<AsyncResult<MongoGridFsClient>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection2, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        ReadStream<ChangeStreamDocument<JsonObject>> ret = ReadStream.newInstance(this.delegate.watch(collection2, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
        return ret;
    }

    public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
        return arg != null ? new MongoClient(arg) : null;
    }
}

