/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.auth.User;
import io.vertx.rxjava.ext.auth.authentication.AuthenticationProvider;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends AuthenticationProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg<OAuth2Auth>(obj2 -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj2), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public OAuth2Auth(Object delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, OAuth2Options config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), (OAuth2Options)config));
        return ret;
    }

    public OAuth2Auth jWKSet(Handler<AsyncResult<Void>> handler) {
        this.delegate.jWKSet(handler);
        return this;
    }

    public OAuth2Auth jWKSet() {
        return this.jWKSet(ar -> {});
    }

    public Single<Void> rxJWKSet() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.jWKSet((Handler<AsyncResult<Void>>)fut)));
    }

    public OAuth2Auth missingKeyHandler(Handler<String> handler) {
        this.delegate.missingKeyHandler(handler);
        return this;
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    public OAuth2Auth refresh(User user, final Handler<AsyncResult<User>> handler) {
        this.delegate.refresh(user.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.auth.User>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(User.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public OAuth2Auth refresh(User user) {
        return this.refresh(user, ar -> {});
    }

    public Single<User> rxRefresh(User user) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.refresh(user, (Handler<AsyncResult<User>>)fut)));
    }

    public OAuth2Auth revoke(User user, String tokenType, Handler<AsyncResult<Void>> handler) {
        this.delegate.revoke(user.getDelegate(), tokenType, handler);
        return this;
    }

    public OAuth2Auth revoke(User user, String tokenType) {
        return this.revoke(user, tokenType, ar -> {});
    }

    public Single<Void> rxRevoke(User user, String tokenType) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.revoke(user, tokenType, (Handler<AsyncResult<Void>>)fut)));
    }

    public OAuth2Auth revoke(User user, Handler<AsyncResult<Void>> handler) {
        this.delegate.revoke(user.getDelegate(), handler);
        return this;
    }

    public OAuth2Auth revoke(User user) {
        return this.revoke(user, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxRevoke(User user) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.revoke(user, (Handler<AsyncResult<Void>>)fut)));
    }

    public OAuth2Auth userInfo(User user, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.userInfo(user.getDelegate(), handler);
        return this;
    }

    public OAuth2Auth userInfo(User user) {
        return this.userInfo(user, ar -> {});
    }

    public Single<JsonObject> rxUserInfo(User user) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.userInfo(user, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public String endSessionURL(User user, JsonObject params) {
        String ret = this.delegate.endSessionURL(user.getDelegate(), params);
        return ret;
    }

    public String endSessionURL(User user) {
        String ret = this.delegate.endSessionURL(user.getDelegate());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

