/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.authentication;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.auth.User;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.authentication.AuthenticationProvider.class)
public class AuthenticationProvider {
    public static final TypeArg<AuthenticationProvider> __TYPE_ARG = new TypeArg<AuthenticationProvider>(obj2 -> new AuthenticationProvider((io.vertx.ext.auth.authentication.AuthenticationProvider)obj2), AuthenticationProvider::getDelegate);
    private final io.vertx.ext.auth.authentication.AuthenticationProvider delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationProvider that = (AuthenticationProvider)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AuthenticationProvider(io.vertx.ext.auth.authentication.AuthenticationProvider delegate) {
        this.delegate = delegate;
    }

    public AuthenticationProvider(Object delegate) {
        this.delegate = (io.vertx.ext.auth.authentication.AuthenticationProvider)delegate;
    }

    public io.vertx.ext.auth.authentication.AuthenticationProvider getDelegate() {
        return this.delegate;
    }

    public void authenticate(JsonObject credentials, final Handler<AsyncResult<User>> resultHandler) {
        this.delegate.authenticate(credentials, new Handler<AsyncResult<io.vertx.ext.auth.User>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(User.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void authenticate(JsonObject credentials) {
        this.authenticate(credentials, (AsyncResult<User> ar) -> {});
    }

    public Single<User> rxAuthenticate(JsonObject credentials) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.authenticate(credentials, (Handler<AsyncResult<User>>)fut)));
    }

    public void authenticate(Credentials credentials, final Handler<AsyncResult<User>> resultHandler) {
        this.delegate.authenticate(credentials, new Handler<AsyncResult<io.vertx.ext.auth.User>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(User.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void authenticate(Credentials credentials) {
        this.authenticate(credentials, (AsyncResult<User> ar) -> {});
    }

    public Single<User> rxAuthenticate(Credentials credentials) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.authenticate(credentials, (Handler<AsyncResult<User>>)fut)));
    }

    public static AuthenticationProvider newInstance(io.vertx.ext.auth.authentication.AuthenticationProvider arg) {
        return arg != null ? new AuthenticationProvider(arg) : null;
    }
}

