/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import javax.net.ssl.SSLSession;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg<NetSocket>(obj2 -> new NetSocket((io.vertx.core.net.NetSocket)obj2), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private Observable<Buffer> observable;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public NetSocket(Object delegate) {
        this.delegate = (io.vertx.core.net.NetSocket)delegate;
    }

    @Override
    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(data2.getDelegate(), handler);
    }

    @Override
    public void end(Buffer data2) {
        this.end(data2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd(Buffer data2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(data2, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<Buffer> dst) {
        this.pipeTo(dst, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxPipeTo(WriteStream<Buffer> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    public NetSocket handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    @Override
    public void write(String str2, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(str2, handler);
    }

    @Override
    public void write(String str2) {
        this.write(str2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(String str2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(str2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void write(String str2, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(str2, enc, handler);
    }

    public void write(String str2, String enc) {
        this.write(str2, enc, ar -> {});
    }

    public Single<Void> rxWrite(String str2, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(str2, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void write(Buffer message, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(message.getDelegate(), handler);
    }

    @Override
    public void write(Buffer message) {
        this.write(message, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(Buffer message) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(message, (Handler<AsyncResult<Void>>)fut)));
    }

    public NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public NetSocket sendFile(String filename) {
        return this.sendFile(filename, ar -> {});
    }

    public Single<Void> rxSendFile(String filename) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, (Handler<AsyncResult<Void>>)fut)));
    }

    public NetSocket sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public NetSocket sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, ar -> {});
    }

    public Single<Void> rxSendFile(String filename, long offset) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)fut)));
    }

    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public NetSocket sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, ar -> {});
    }

    public Single<Void> rxSendFile(String filename, long offset, long length) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)fut)));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket upgradeToSsl(Handler<AsyncResult<Void>> handler) {
        this.delegate.upgradeToSsl(handler);
        return this;
    }

    public NetSocket upgradeToSsl() {
        return this.upgradeToSsl((AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxUpgradeToSsl() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.upgradeToSsl((Handler<AsyncResult<Void>>)fut)));
    }

    public NetSocket upgradeToSsl(String serverName, Handler<AsyncResult<Void>> handler) {
        this.delegate.upgradeToSsl(serverName, handler);
        return this;
    }

    public NetSocket upgradeToSsl(String serverName) {
        return this.upgradeToSsl(serverName, ar -> {});
    }

    public Single<Void> rxUpgradeToSsl(String serverName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.upgradeToSsl(serverName, (Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public String applicationLayerProtocol() {
        String ret = this.delegate.applicationLayerProtocol();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

