/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetSocket;
import io.vertx.rxjava.core.net.SocketAddress;
import rx.Single;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg<NetClient>(obj2 -> new NetClient((io.vertx.core.net.NetClient)obj2), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    @Override
    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetClient connect(int port, String host, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle(Future.succeededFuture(NetSocket.newInstance(ar.result())));
                } else {
                    connectHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(int port, String host) {
        return this.connect(port, host, (AsyncResult<NetSocket> ar) -> {});
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(port, host, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(int port, String host, String serverName, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(port, host, serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle(Future.succeededFuture(NetSocket.newInstance(ar.result())));
                } else {
                    connectHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(int port, String host, String serverName) {
        return this.connect(port, host, serverName, ar -> {});
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(port, host, serverName, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(SocketAddress remoteAddress, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle(Future.succeededFuture(NetSocket.newInstance(ar.result())));
                } else {
                    connectHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (AsyncResult<NetSocket> ar) -> {});
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(remoteAddress, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName, final Handler<AsyncResult<NetSocket>> connectHandler) {
        this.delegate.connect(remoteAddress.getDelegate(), serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle(Future.succeededFuture(NetSocket.newInstance(ar.result())));
                } else {
                    connectHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public NetClient connect(SocketAddress remoteAddress, String serverName) {
        return this.connect(remoteAddress, serverName, (AsyncResult<NetSocket> ar) -> {});
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(remoteAddress, serverName, (Handler<AsyncResult<NetSocket>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

