/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.Cookie;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg<HttpServerResponse>(obj2 -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj2), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private static final TypeArg<Cookie> TYPE_ARG_0 = new TypeArg<Cookie>(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Cookie> TYPE_ARG_1 = new TypeArg<Cookie>(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private MultiMap cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    @Override
    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data2.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data2) {
        this.write(data2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data2, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpServerResponse putHeader(String name2, String value) {
        this.delegate.putHeader(name2, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public HttpServerResponse putTrailer(String name2, String value) {
        this.delegate.putTrailer(name2, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public void write(String chunk2, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk2, enc, handler);
    }

    public void write(String chunk2, String enc) {
        this.write(chunk2, enc, ar -> {});
    }

    public Single<Void> rxWrite(String chunk2, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk2, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void write(String chunk2, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk2, handler);
    }

    @Override
    public void write(String chunk2) {
        this.write(chunk2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(String chunk2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk2, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse writeContinue() {
        this.delegate.writeContinue();
        return this;
    }

    @Override
    public void end(String chunk2, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk2, handler);
    }

    @Override
    public void end(String chunk2) {
        this.end(chunk2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd(String chunk2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk2, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk2, enc, handler);
    }

    public void end(String chunk2, String enc) {
        this.end(chunk2, enc, ar -> {});
    }

    public Single<Void> rxEnd(String chunk2, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk2, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk2, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk2.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk2) {
        this.end(chunk2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(Handler<AsyncResult<Void>> handler) {
        this.delegate.send(handler);
    }

    public void send() {
        this.send((AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxSend() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send((Handler<AsyncResult<Void>>)fut)));
    }

    public void send(String body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(body, handler);
    }

    public void send(String body) {
        this.send(body, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxSend(String body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(body.getDelegate(), handler);
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body) {
        this.send(body, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxSend(io.vertx.rxjava.core.buffer.Buffer body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(body.getDelegate(), handler);
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxSend(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj2 -> obj2.getDelegate()).resume(), handler);
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxSend(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public HttpServerResponse sendFile(String filename) {
        return this.sendFile(filename, ar -> {});
    }

    public Single<Void> rxSendFile(String filename) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public HttpServerResponse sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, ar -> {});
    }

    public Single<Void> rxSendFile(String filename, long offset) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public HttpServerResponse sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, ar -> {});
    }

    public Single<Void> rxSendFile(String filename, long offset, long length) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path2, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, host, path2, new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpServerResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path2) {
        return this.push(method, host, path2, (AsyncResult<HttpServerResponse> ar) -> {});
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, host, path2, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String path2, MultiMap headers, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, path2, headers.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpServerResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String path2, MultiMap headers) {
        return this.push(method, path2, headers, (AsyncResult<HttpServerResponse> ar) -> {});
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path2, MultiMap headers) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, path2, headers, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String path2, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, path2, new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpServerResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String path2) {
        return this.push(method, path2, (AsyncResult<HttpServerResponse> ar) -> {});
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, path2, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public HttpServerResponse push(HttpMethod method, String host, String path2, MultiMap headers, final Handler<AsyncResult<HttpServerResponse>> handler) {
        this.delegate.push(method, host, path2, headers.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServerResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpServerResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpServerResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpServerResponse push(HttpMethod method, String host, String path2, MultiMap headers) {
        return this.push(method, host, path2, headers, ar -> {});
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path2, MultiMap headers) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.push(method, host, path2, headers, (Handler<AsyncResult<HttpServerResponse>>)fut)));
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpServerResponse writeCustomFrame(int type2, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type2, flags, payload.getDelegate());
        return this;
    }

    public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie.getDelegate());
        return this;
    }

    public Cookie removeCookie(String name2) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name2));
        return ret;
    }

    public Cookie removeCookie(String name2, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name2, invalidate));
        return ret;
    }

    public Set<Cookie> removeCookies(String name2) {
        Set<Cookie> ret = this.delegate.removeCookies(name2).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Set<Cookie> removeCookies(String name2, boolean invalidate) {
        Set<Cookie> ret = this.delegate.removeCookies(name2, invalidate).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Cookie removeCookie(String name2, String domain, String path2) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name2, domain, path2));
        return ret;
    }

    public Cookie removeCookie(String name2, String domain, String path2, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name2, domain, path2, invalidate));
        return ret;
    }

    public HttpServerResponse putHeader(CharSequence name2, CharSequence value) {
        this.delegate.putHeader(name2, value);
        return this;
    }

    public HttpServerResponse putHeader(String name2, Iterable<String> values2) {
        this.delegate.putHeader(name2, values2);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name2, Iterable<CharSequence> values2) {
        this.delegate.putHeader(name2, values2);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name2, CharSequence value) {
        this.delegate.putTrailer(name2, value);
        return this;
    }

    public HttpServerResponse putTrailer(String name2, Iterable<String> values2) {
        this.delegate.putTrailer(name2, values2);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name2, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name2, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

