/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg<HttpClientRequest>(obj2 -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj2), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public HttpClientRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientRequest)delegate;
    }

    @Override
    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data2.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data2) {
        this.write(data2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data2, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public HttpClientRequest setPort(int port) {
        this.delegate.setPort(port);
        return this;
    }

    public int getPort() {
        int ret = this.delegate.getPort();
        return ret;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod getMethod() {
        HttpMethod ret = this.delegate.getMethod();
        return ret;
    }

    public HttpClientRequest setMethod(HttpMethod method) {
        this.delegate.setMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String getURI() {
        String ret = this.delegate.getURI();
        return ret;
    }

    public HttpClientRequest setURI(String uri) {
        this.delegate.setURI(uri);
        return this;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name2, String value) {
        this.delegate.putHeader(name2, value);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public void write(String chunk2, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk2, handler);
    }

    @Override
    public void write(String chunk2) {
        this.write(chunk2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(String chunk2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void write(String chunk2, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk2, enc, handler);
    }

    public void write(String chunk2, String enc) {
        this.write(chunk2, enc, ar -> {});
    }

    public Single<Void> rxWrite(String chunk2, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(chunk2, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest sendHead(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    public HttpClientRequest sendHead() {
        return this.sendHead(ar -> {});
    }

    public Single<Void> rxSendHead() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.sendHead((Handler<AsyncResult<Void>>)fut)));
    }

    public void connect(final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.connect(new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void connect() {
        this.connect(ar -> {});
    }

    public Single<HttpClientResponse> rxConnect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public HttpClientRequest response(final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.response(new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClientRequest response() {
        return this.response(ar -> {});
    }

    public Single<HttpClientResponse> rxResponse() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.response((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void send() {
        this.send((AsyncResult<HttpClientResponse> ar) -> {});
    }

    public Single<HttpClientResponse> rxSend() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(String body, final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(body, new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void send(String body) {
        this.send(body, (AsyncResult<HttpClientResponse> ar) -> {});
    }

    public Single<HttpClientResponse> rxSend(String body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body, final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(body.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body) {
        this.send(body, (AsyncResult<HttpClientResponse> ar) -> {});
    }

    public Single<HttpClientResponse> rxSend(io.vertx.rxjava.core.buffer.Buffer body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body, final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(body.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (AsyncResult<HttpClientResponse> ar) -> {});
    }

    public Single<HttpClientResponse> rxSend(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body, final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj2 -> obj2.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientResponse.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (AsyncResult<HttpClientResponse> ar) -> {});
    }

    public Single<HttpClientResponse> rxSend(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    @Override
    public void end(String chunk2, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk2, handler);
    }

    @Override
    public void end(String chunk2) {
        this.end(chunk2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd(String chunk2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk2, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk2, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk2, enc, handler);
    }

    public void end(String chunk2, String enc) {
        this.end(chunk2, enc, ar -> {});
    }

    public Single<Void> rxEnd(String chunk2, String enc) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk2, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk2, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk2.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk2) {
        this.end(chunk2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(chunk2, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler(new Handler<io.vertx.core.http.HttpClientRequest>(){

            @Override
            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle(HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public boolean reset(long code, Throwable cause) {
        boolean ret = this.delegate.reset(code, cause);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest writeCustomFrame(int type2, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type2, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest putHeader(CharSequence name2, CharSequence value) {
        this.delegate.putHeader(name2, value);
        return this;
    }

    public HttpClientRequest putHeader(String name2, Iterable<String> values2) {
        this.delegate.putHeader(name2, values2);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name2, Iterable<CharSequence> values2) {
        this.delegate.putHeader(name2, values2);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

