/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientRequest;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.WebSocket;
import io.vertx.rxjava.core.metrics.Measured;
import java.util.List;
import java.util.function.Function;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg<HttpClient>(obj2 -> new HttpClient((io.vertx.core.http.HttpClient)obj2), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpClient(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClient)delegate;
    }

    @Override
    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public void request(RequestOptions options2, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(options2, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientRequest.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void request(RequestOptions options2) {
        this.request(options2, (AsyncResult<HttpClientRequest> ar) -> {});
    }

    public Single<HttpClientRequest> rxRequest(RequestOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(options2, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void request(HttpMethod method, int port, String host, String requestURI, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, port, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientRequest.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void request(HttpMethod method, int port, String host, String requestURI) {
        this.request(method, port, host, requestURI, ar -> {});
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, int port, String host, String requestURI) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(method, port, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void request(HttpMethod method, String host, String requestURI, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientRequest.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void request(HttpMethod method, String host, String requestURI) {
        this.request(method, host, requestURI, (AsyncResult<HttpClientRequest> ar) -> {});
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String host, String requestURI) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(method, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void request(HttpMethod method, String requestURI, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, requestURI, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(HttpClientRequest.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void request(HttpMethod method, String requestURI) {
        this.request(method, requestURI, (AsyncResult<HttpClientRequest> ar) -> {});
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String requestURI) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(method, requestURI, (Handler<AsyncResult<HttpClientRequest>>)fut)));
    }

    public void webSocket(int port, String host, String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(port, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(WebSocket.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void webSocket(int port, String host, String requestURI) {
        this.webSocket(port, host, requestURI, ar -> {});
    }

    public Single<WebSocket> rxWebSocket(int port, String host, String requestURI) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void webSocket(String host, String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(host, requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(WebSocket.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void webSocket(String host, String requestURI) {
        this.webSocket(host, requestURI, (AsyncResult<WebSocket> ar) -> {});
    }

    public Single<WebSocket> rxWebSocket(String host, String requestURI) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void webSocket(String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(WebSocket.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void webSocket(String requestURI) {
        this.webSocket(requestURI, (AsyncResult<WebSocket> ar) -> {});
    }

    public Single<WebSocket> rxWebSocket(String requestURI) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void webSocket(WebSocketConnectOptions options2, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(options2, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(WebSocket.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void webSocket(WebSocketConnectOptions options2) {
        this.webSocket(options2, (AsyncResult<WebSocket> ar) -> {});
    }

    public Single<WebSocket> rxWebSocket(WebSocketConnectOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.webSocket(options2, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(WebSocket.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        this.webSocketAbs(url, headers, version, subProtocols, ar -> {});
    }

    public Single<WebSocket> rxWebSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public HttpClient connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>(){

            @Override
            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle(HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient redirectHandler(final Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.delegate.redirectHandler(new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.map(val2 -> val2);
            }
        });
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

