/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.file;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.file.AsyncFile;
import io.vertx.rxjava.core.file.FileProps;
import io.vertx.rxjava.core.file.FileSystemProps;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg<FileSystem>(obj2 -> new FileSystem((io.vertx.core.file.FileSystem)obj2), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public FileSystem(Object delegate) {
        this.delegate = (io.vertx.core.file.FileSystem)delegate;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, handler);
        return this;
    }

    public FileSystem copy(String from, String to) {
        return this.copy(from, to, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxCopy(String from, String to) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.copy(from, to, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem copy(String from, String to, CopyOptions options2, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, options2, handler);
        return this;
    }

    public FileSystem copy(String from, String to, CopyOptions options2) {
        return this.copy(from, to, options2, ar -> {});
    }

    public Single<Void> rxCopy(String from, String to, CopyOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.copy(from, to, options2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    public FileSystem copyRecursive(String from, String to, boolean recursive2, Handler<AsyncResult<Void>> handler) {
        this.delegate.copyRecursive(from, to, recursive2, handler);
        return this;
    }

    public FileSystem copyRecursive(String from, String to, boolean recursive2) {
        return this.copyRecursive(from, to, recursive2, ar -> {});
    }

    public Single<Void> rxCopyRecursive(String from, String to, boolean recursive2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.copyRecursive(from, to, recursive2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive2) {
        this.delegate.copyRecursiveBlocking(from, to, recursive2);
        return this;
    }

    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, handler);
        return this;
    }

    public FileSystem move(String from, String to) {
        return this.move(from, to, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxMove(String from, String to) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.move(from, to, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem move(String from, String to, CopyOptions options2, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, options2, handler);
        return this;
    }

    public FileSystem move(String from, String to, CopyOptions options2) {
        return this.move(from, to, options2, ar -> {});
    }

    public Single<Void> rxMove(String from, String to, CopyOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.move(from, to, options2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    public FileSystem truncate(String path2, long len, Handler<AsyncResult<Void>> handler) {
        this.delegate.truncate(path2, len, handler);
        return this;
    }

    public FileSystem truncate(String path2, long len) {
        return this.truncate(path2, len, ar -> {});
    }

    public Single<Void> rxTruncate(String path2, long len) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.truncate(path2, len, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem truncateBlocking(String path2, long len) {
        this.delegate.truncateBlocking(path2, len);
        return this;
    }

    public FileSystem chmod(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmod(path2, perms, handler);
        return this;
    }

    public FileSystem chmod(String path2, String perms) {
        return this.chmod(path2, perms, ar -> {});
    }

    public Single<Void> rxChmod(String path2, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.chmod(path2, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem chmodBlocking(String path2, String perms) {
        this.delegate.chmodBlocking(path2, perms);
        return this;
    }

    public FileSystem chmodRecursive(String path2, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmodRecursive(path2, perms, dirPerms, handler);
        return this;
    }

    public FileSystem chmodRecursive(String path2, String perms, String dirPerms) {
        return this.chmodRecursive(path2, perms, dirPerms, ar -> {});
    }

    public Single<Void> rxChmodRecursive(String path2, String perms, String dirPerms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.chmodRecursive(path2, perms, dirPerms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem chmodRecursiveBlocking(String path2, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path2, perms, dirPerms);
        return this;
    }

    public FileSystem chown(String path2, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.delegate.chown(path2, user, group, handler);
        return this;
    }

    public FileSystem chown(String path2, String user, String group) {
        return this.chown(path2, user, group, ar -> {});
    }

    public Single<Void> rxChown(String path2, String user, String group) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.chown(path2, user, group, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem chownBlocking(String path2, String user, String group) {
        this.delegate.chownBlocking(path2, user, group);
        return this;
    }

    public FileSystem props(String path2, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.props(path2, new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public FileSystem props(String path2) {
        return this.props(path2, ar -> {});
    }

    public Single<FileProps> rxProps(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.props(path2, (Handler<AsyncResult<FileProps>>)fut)));
    }

    public FileProps propsBlocking(String path2) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path2));
        return ret;
    }

    public FileSystem lprops(String path2, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.lprops(path2, new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public FileSystem lprops(String path2) {
        return this.lprops(path2, ar -> {});
    }

    public Single<FileProps> rxLprops(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lprops(path2, (Handler<AsyncResult<FileProps>>)fut)));
    }

    public FileProps lpropsBlocking(String path2) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path2));
        return ret;
    }

    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.link(link, existing, handler);
        return this;
    }

    public FileSystem link(String link, String existing) {
        return this.link(link, existing, ar -> {});
    }

    public Single<Void> rxLink(String link, String existing) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.link(link, existing, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.symlink(link, existing, handler);
        return this;
    }

    public FileSystem symlink(String link, String existing) {
        return this.symlink(link, existing, ar -> {});
    }

    public Single<Void> rxSymlink(String link, String existing) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.symlink(link, existing, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlink(link, handler);
        return this;
    }

    public FileSystem unlink(String link) {
        return this.unlink(link, ar -> {});
    }

    public Single<Void> rxUnlink(String link) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unlink(link, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.delegate.readSymlink(link, handler);
        return this;
    }

    public FileSystem readSymlink(String link) {
        return this.readSymlink(link, ar -> {});
    }

    public Single<String> rxReadSymlink(String link) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.readSymlink(link, (Handler<AsyncResult<String>>)fut)));
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    public FileSystem delete(String path2, Handler<AsyncResult<Void>> handler) {
        this.delegate.delete(path2, handler);
        return this;
    }

    public FileSystem delete(String path2) {
        return this.delete(path2, ar -> {});
    }

    public Single<Void> rxDelete(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.delete(path2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem deleteBlocking(String path2) {
        this.delegate.deleteBlocking(path2);
        return this;
    }

    public FileSystem deleteRecursive(String path2, boolean recursive2, Handler<AsyncResult<Void>> handler) {
        this.delegate.deleteRecursive(path2, recursive2, handler);
        return this;
    }

    public FileSystem deleteRecursive(String path2, boolean recursive2) {
        return this.deleteRecursive(path2, recursive2, ar -> {});
    }

    public Single<Void> rxDeleteRecursive(String path2, boolean recursive2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.deleteRecursive(path2, recursive2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem deleteRecursiveBlocking(String path2, boolean recursive2) {
        this.delegate.deleteRecursiveBlocking(path2, recursive2);
        return this;
    }

    public FileSystem mkdir(String path2, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path2, handler);
        return this;
    }

    public FileSystem mkdir(String path2) {
        return this.mkdir(path2, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxMkdir(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.mkdir(path2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirBlocking(String path2) {
        this.delegate.mkdirBlocking(path2);
        return this;
    }

    public FileSystem mkdir(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path2, perms, handler);
        return this;
    }

    public FileSystem mkdir(String path2, String perms) {
        return this.mkdir(path2, perms, ar -> {});
    }

    public Single<Void> rxMkdir(String path2, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.mkdir(path2, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirBlocking(String path2, String perms) {
        this.delegate.mkdirBlocking(path2, perms);
        return this;
    }

    public FileSystem mkdirs(String path2, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path2, handler);
        return this;
    }

    public FileSystem mkdirs(String path2) {
        return this.mkdirs(path2, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxMkdirs(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.mkdirs(path2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirsBlocking(String path2) {
        this.delegate.mkdirsBlocking(path2);
        return this;
    }

    public FileSystem mkdirs(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path2, perms, handler);
        return this;
    }

    public FileSystem mkdirs(String path2, String perms) {
        return this.mkdirs(path2, perms, ar -> {});
    }

    public Single<Void> rxMkdirs(String path2, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.mkdirs(path2, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem mkdirsBlocking(String path2, String perms) {
        this.delegate.mkdirsBlocking(path2, perms);
        return this;
    }

    public FileSystem readDir(String path2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path2, handler);
        return this;
    }

    public FileSystem readDir(String path2) {
        return this.readDir(path2, (AsyncResult<List<String>> ar) -> {});
    }

    public Single<List<String>> rxReadDir(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.readDir(path2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public List<String> readDirBlocking(String path2) {
        List<String> ret = this.delegate.readDirBlocking(path2);
        return ret;
    }

    public FileSystem readDir(String path2, String filter2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path2, filter2, handler);
        return this;
    }

    public FileSystem readDir(String path2, String filter2) {
        return this.readDir(path2, filter2, ar -> {});
    }

    public Single<List<String>> rxReadDir(String path2, String filter2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.readDir(path2, filter2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public List<String> readDirBlocking(String path2, String filter2) {
        List<String> ret = this.delegate.readDirBlocking(path2, filter2);
        return ret;
    }

    public FileSystem readFile(String path2, final Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>> handler) {
        this.delegate.readFile(path2, new Handler<AsyncResult<Buffer>>(){

            @Override
            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(io.vertx.rxjava.core.buffer.Buffer.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public FileSystem readFile(String path2) {
        return this.readFile(path2, ar -> {});
    }

    public Single<io.vertx.rxjava.core.buffer.Buffer> rxReadFile(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.readFile(path2, (Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>>)fut)));
    }

    public io.vertx.rxjava.core.buffer.Buffer readFileBlocking(String path2) {
        io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance(this.delegate.readFileBlocking(path2));
        return ret;
    }

    public FileSystem writeFile(String path2, io.vertx.rxjava.core.buffer.Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFile(path2, data2.getDelegate(), handler);
        return this;
    }

    public FileSystem writeFile(String path2, io.vertx.rxjava.core.buffer.Buffer data2) {
        return this.writeFile(path2, data2, ar -> {});
    }

    public Single<Void> rxWriteFile(String path2, io.vertx.rxjava.core.buffer.Buffer data2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.writeFile(path2, data2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem writeFileBlocking(String path2, io.vertx.rxjava.core.buffer.Buffer data2) {
        this.delegate.writeFileBlocking(path2, data2.getDelegate());
        return this;
    }

    public FileSystem open(String path2, OpenOptions options2, final Handler<AsyncResult<AsyncFile>> handler) {
        this.delegate.open(path2, options2, new Handler<AsyncResult<io.vertx.core.file.AsyncFile>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.AsyncFile> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(AsyncFile.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public FileSystem open(String path2, OpenOptions options2) {
        return this.open(path2, options2, ar -> {});
    }

    public Single<AsyncFile> rxOpen(String path2, OpenOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.open(path2, options2, (Handler<AsyncResult<AsyncFile>>)fut)));
    }

    public AsyncFile openBlocking(String path2, OpenOptions options2) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path2, options2));
        return ret;
    }

    public FileSystem createFile(String path2, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path2, handler);
        return this;
    }

    public FileSystem createFile(String path2) {
        return this.createFile(path2, (AsyncResult<Void> ar) -> {});
    }

    public Single<Void> rxCreateFile(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createFile(path2, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem createFileBlocking(String path2) {
        this.delegate.createFileBlocking(path2);
        return this;
    }

    public FileSystem createFile(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path2, perms, handler);
        return this;
    }

    public FileSystem createFile(String path2, String perms) {
        return this.createFile(path2, perms, ar -> {});
    }

    public Single<Void> rxCreateFile(String path2, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createFile(path2, perms, (Handler<AsyncResult<Void>>)fut)));
    }

    public FileSystem createFileBlocking(String path2, String perms) {
        this.delegate.createFileBlocking(path2, perms);
        return this;
    }

    public FileSystem exists(String path2, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.exists(path2, handler);
        return this;
    }

    public FileSystem exists(String path2) {
        return this.exists(path2, ar -> {});
    }

    public Single<Boolean> rxExists(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exists(path2, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public boolean existsBlocking(String path2) {
        boolean ret = this.delegate.existsBlocking(path2);
        return ret;
    }

    public FileSystem fsProps(String path2, final Handler<AsyncResult<FileSystemProps>> handler) {
        this.delegate.fsProps(path2, new Handler<AsyncResult<io.vertx.core.file.FileSystemProps>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.file.FileSystemProps> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(FileSystemProps.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public FileSystem fsProps(String path2) {
        return this.fsProps(path2, ar -> {});
    }

    public Single<FileSystemProps> rxFsProps(String path2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.fsProps(path2, (Handler<AsyncResult<FileSystemProps>>)fut)));
    }

    public FileSystemProps fsPropsBlocking(String path2) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path2));
        return ret;
    }

    public FileSystem createTempDirectory(String prefix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, handler);
        return this;
    }

    public FileSystem createTempDirectory(String prefix) {
        return this.createTempDirectory(prefix, (AsyncResult<String> ar) -> {});
    }

    public Single<String> rxCreateTempDirectory(String prefix) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createTempDirectory(prefix, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    public FileSystem createTempDirectory(String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(prefix, perms, handler);
        return this;
    }

    public FileSystem createTempDirectory(String prefix, String perms) {
        return this.createTempDirectory(prefix, perms, (AsyncResult<String> ar) -> {});
    }

    public Single<String> rxCreateTempDirectory(String prefix, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createTempDirectory(prefix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    public FileSystem createTempDirectory(String dir2, String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempDirectory(dir2, prefix, perms, handler);
        return this;
    }

    public FileSystem createTempDirectory(String dir2, String prefix, String perms) {
        return this.createTempDirectory(dir2, prefix, perms, ar -> {});
    }

    public Single<String> rxCreateTempDirectory(String dir2, String prefix, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createTempDirectory(dir2, prefix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempDirectoryBlocking(String dir2, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir2, prefix, perms);
        return ret;
    }

    public FileSystem createTempFile(String prefix, String suffix, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, handler);
        return this;
    }

    public FileSystem createTempFile(String prefix, String suffix) {
        return this.createTempFile(prefix, suffix, (AsyncResult<String> ar) -> {});
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createTempFile(prefix, suffix, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    public FileSystem createTempFile(String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(prefix, suffix, perms, handler);
        return this;
    }

    public FileSystem createTempFile(String prefix, String suffix, String perms) {
        return this.createTempFile(prefix, suffix, perms, (AsyncResult<String> ar) -> {});
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createTempFile(prefix, suffix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    public FileSystem createTempFile(String dir2, String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.delegate.createTempFile(dir2, prefix, suffix, perms, handler);
        return this;
    }

    public FileSystem createTempFile(String dir2, String prefix, String suffix, String perms) {
        return this.createTempFile(dir2, prefix, suffix, perms, ar -> {});
    }

    public Single<String> rxCreateTempFile(String dir2, String prefix, String suffix, String perms) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createTempFile(dir2, prefix, suffix, perms, (Handler<AsyncResult<String>>)fut)));
    }

    public String createTempFileBlocking(String dir2, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir2, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

