/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.file;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg<AsyncFile>(obj2 -> new AsyncFile((io.vertx.core.file.AsyncFile)obj2), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    private Observable<Buffer> observable;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public AsyncFile(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFile)delegate;
    }

    @Override
    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data2.getDelegate(), handler);
    }

    @Override
    public void write(Buffer data2) {
        this.write(data2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxWrite(Buffer data2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data2, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(data2.getDelegate(), handler);
    }

    @Override
    public void end(Buffer data2) {
        this.end(data2, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxEnd(Buffer data2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(data2, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<Buffer> dst) {
        this.pipeTo(dst, (AsyncResult<Void> ar) -> {});
    }

    @Override
    public Single<Void> rxPipeTo(WriteStream<Buffer> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public void write(Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(buffer.getDelegate(), position, handler);
    }

    public void write(Buffer buffer, long position) {
        this.write(buffer, position, ar -> {});
    }

    public Single<Void> rxWrite(Buffer buffer, long position) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(buffer, position, (Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile read(Buffer buffer, int offset, long position, int length, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.read(buffer.getDelegate(), offset, position, length, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Buffer.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AsyncFile read(Buffer buffer, int offset, long position, int length) {
        return this.read(buffer, offset, position, length, ar -> {});
    }

    public Single<Buffer> rxRead(Buffer buffer, int offset, long position, int length) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.read(buffer, offset, position, length, (Handler<AsyncResult<Buffer>>)fut)));
    }

    public AsyncFile flush(Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(handler);
        return this;
    }

    public AsyncFile flush() {
        return this.flush(ar -> {});
    }

    public Single<Void> rxFlush() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.flush((Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public long getReadLength() {
        long ret = this.delegate.getReadLength();
        return ret;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public long sizeBlocking() {
        long ret = this.delegate.sizeBlocking();
        return ret;
    }

    public void size(Handler<AsyncResult<Long>> handler) {
        this.delegate.size(handler);
    }

    public void size() {
        this.size(ar -> {});
    }

    public Single<Long> rxSize() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.size((Handler<AsyncResult<Long>>)fut)));
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

