/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.eventbus.DeliveryContext;
import io.vertx.rxjava.core.eventbus.Message;
import io.vertx.rxjava.core.eventbus.MessageConsumer;
import io.vertx.rxjava.core.eventbus.MessageProducer;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Single;

@RxGen(value=io.vertx.core.eventbus.EventBus.class)
public class EventBus
implements Measured {
    public static final TypeArg<EventBus> __TYPE_ARG = new TypeArg<EventBus>(obj2 -> new EventBus((io.vertx.core.eventbus.EventBus)obj2), EventBus::getDelegate);
    private final io.vertx.core.eventbus.EventBus delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBus that = (EventBus)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public EventBus(io.vertx.core.eventbus.EventBus delegate) {
        this.delegate = delegate;
    }

    public EventBus(Object delegate) {
        this.delegate = (io.vertx.core.eventbus.EventBus)delegate;
    }

    @Override
    public io.vertx.core.eventbus.EventBus getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public EventBus send(String address, Object message) {
        this.delegate.send(address, message);
        return this;
    }

    public EventBus send(String address, Object message, DeliveryOptions options2) {
        this.delegate.send(address, message, options2);
        return this;
    }

    public <T> EventBus request(String address, Object message, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.request(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle(Future.succeededFuture(Message.newInstance(ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public <T> EventBus request(String address, Object message) {
        return this.request(address, message, (AsyncResult<Message<T>> ar) -> {});
    }

    public <T> Single<Message<T>> rxRequest(String address, Object message) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(address, message, (Handler)fut)));
    }

    public <T> EventBus request(String address, Object message, DeliveryOptions options2, final Handler<AsyncResult<Message<T>>> replyHandler) {
        this.delegate.request(address, message, options2, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle(Future.succeededFuture(Message.newInstance(ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public <T> EventBus request(String address, Object message, DeliveryOptions options2) {
        return this.request(address, message, options2, ar -> {});
    }

    public <T> Single<Message<T>> rxRequest(String address, Object message, DeliveryOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.request(address, message, options2, (Handler)fut)));
    }

    public EventBus publish(String address, Object message) {
        this.delegate.publish(address, message);
        return this;
    }

    public EventBus publish(String address, Object message, DeliveryOptions options2) {
        this.delegate.publish(address, message, options2);
        return this;
    }

    public <T> MessageConsumer<T> consumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> consumer(String address, final Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.consumer(address, new Handler<io.vertx.core.eventbus.Message<T>>(){

            @Override
            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle(Message.newInstance(event, TypeArg.unknown()));
            }
        }), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageConsumer<T> localConsumer(String address, final Handler<Message<T>> handler) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.localConsumer(address, new Handler<io.vertx.core.eventbus.Message<T>>(){

            @Override
            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle(Message.newInstance(event, TypeArg.unknown()));
            }
        }), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> sender(String address, DeliveryOptions options2) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.sender(address, options2), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options2) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.publisher(address, options2), TypeArg.unknown());
        return ret;
    }

    public <T> EventBus addOutboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            @Override
            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public <T> EventBus removeOutboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            @Override
            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public <T> EventBus addInboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.addInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            @Override
            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public <T> EventBus removeInboundInterceptor(final Handler<DeliveryContext<T>> interceptor) {
        this.delegate.removeInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>(){

            @Override
            public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
                interceptor.handle(DeliveryContext.newInstance(event, TypeArg.unknown()));
            }
        });
        return this;
    }

    public EventBus registerCodec(MessageCodec codec) {
        EventBus ret = EventBus.newInstance(this.delegate.registerCodec(codec));
        return ret;
    }

    public EventBus unregisterCodec(String name2) {
        EventBus ret = EventBus.newInstance(this.delegate.unregisterCodec(name2));
        return ret;
    }

    public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
        return arg != null ? new EventBus(arg) : null;
    }
}

