/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.dns;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.dns.MxRecord;
import io.vertx.rxjava.core.dns.SrvRecord;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<DnsClient>(obj2 -> new DnsClient((io.vertx.core.dns.DnsClient)obj2), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public DnsClient(Object delegate) {
        this.delegate = (io.vertx.core.dns.DnsClient)delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public DnsClient lookup(String name2, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name2, handler);
        return this;
    }

    public DnsClient lookup(String name2) {
        return this.lookup(name2, ar -> {});
    }

    public Single<String> rxLookup(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lookup(name2, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient lookup4(String name2, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name2, handler);
        return this;
    }

    public DnsClient lookup4(String name2) {
        return this.lookup4(name2, ar -> {});
    }

    public Single<String> rxLookup4(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lookup4(name2, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient lookup6(String name2, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name2, handler);
        return this;
    }

    public DnsClient lookup6(String name2) {
        return this.lookup6(name2, ar -> {});
    }

    public Single<String> rxLookup6(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lookup6(name2, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient resolveA(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name2, handler);
        return this;
    }

    public DnsClient resolveA(String name2) {
        return this.resolveA(name2, ar -> {});
    }

    public Single<List<String>> rxResolveA(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveA(name2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveAAAA(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name2, handler);
        return this;
    }

    public DnsClient resolveAAAA(String name2) {
        return this.resolveAAAA(name2, ar -> {});
    }

    public Single<List<String>> rxResolveAAAA(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveAAAA(name2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveCNAME(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name2, handler);
        return this;
    }

    public DnsClient resolveCNAME(String name2) {
        return this.resolveCNAME(name2, ar -> {});
    }

    public Single<List<String>> rxResolveCNAME(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveCNAME(name2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveMX(String name2, final Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name2, new Handler<AsyncResult<List<io.vertx.core.dns.MxRecord>>>(){

            @Override
            public void handle(AsyncResult<List<io.vertx.core.dns.MxRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(ar.result().stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public DnsClient resolveMX(String name2) {
        return this.resolveMX(name2, ar -> {});
    }

    public Single<List<MxRecord>> rxResolveMX(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveMX(name2, (Handler<AsyncResult<List<MxRecord>>>)fut)));
    }

    public DnsClient resolveTXT(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name2, handler);
        return this;
    }

    public DnsClient resolveTXT(String name2) {
        return this.resolveTXT(name2, ar -> {});
    }

    public Single<List<String>> rxResolveTXT(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveTXT(name2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolvePTR(String name2, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name2, handler);
        return this;
    }

    public DnsClient resolvePTR(String name2) {
        return this.resolvePTR(name2, ar -> {});
    }

    public Single<String> rxResolvePTR(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolvePTR(name2, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient resolveNS(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name2, handler);
        return this;
    }

    public DnsClient resolveNS(String name2) {
        return this.resolveNS(name2, ar -> {});
    }

    public Single<List<String>> rxResolveNS(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveNS(name2, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveSRV(String name2, final Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name2, new Handler<AsyncResult<List<io.vertx.core.dns.SrvRecord>>>(){

            @Override
            public void handle(AsyncResult<List<io.vertx.core.dns.SrvRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(ar.result().stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public DnsClient resolveSRV(String name2) {
        return this.resolveSRV(name2, ar -> {});
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveSRV(name2, (Handler<AsyncResult<List<SrvRecord>>>)fut)));
    }

    public DnsClient reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    public DnsClient reverseLookup(String ipaddress) {
        return this.reverseLookup(ipaddress, ar -> {});
    }

    public Single<String> rxReverseLookup(String ipaddress) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.reverseLookup(ipaddress, (Handler<AsyncResult<String>>)fut)));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

