/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.buffer;

import io.netty.buffer.ByteBuf;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@RxGen(value=io.vertx.core.buffer.Buffer.class)
public class Buffer
implements ClusterSerializable {
    public static final TypeArg<Buffer> __TYPE_ARG = new TypeArg<Buffer>(obj2 -> new Buffer((io.vertx.core.buffer.Buffer)obj2), Buffer::getDelegate);
    private final io.vertx.core.buffer.Buffer delegate;

    @Override
    public void writeToBuffer(io.vertx.core.buffer.Buffer buffer) {
        this.delegate.writeToBuffer(buffer);
    }

    @Override
    public int readFromBuffer(int pos, io.vertx.core.buffer.Buffer buffer) {
        return this.delegate.readFromBuffer(pos, buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Buffer that = (Buffer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Buffer(io.vertx.core.buffer.Buffer delegate) {
        this.delegate = delegate;
    }

    public Buffer(Object delegate) {
        this.delegate = (io.vertx.core.buffer.Buffer)delegate;
    }

    public io.vertx.core.buffer.Buffer getDelegate() {
        return this.delegate;
    }

    public static Buffer buffer() {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer());
        return ret;
    }

    public static Buffer buffer(int initialSizeHint) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer(initialSizeHint));
        return ret;
    }

    public static Buffer buffer(String string2) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer(string2));
        return ret;
    }

    public static Buffer buffer(String string2, String enc) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer(string2, enc));
        return ret;
    }

    public String toString() {
        String ret = this.delegate.toString();
        return ret;
    }

    public String toString(String enc) {
        String ret = this.delegate.toString(enc);
        return ret;
    }

    public JsonObject toJsonObject() {
        JsonObject ret = this.delegate.toJsonObject();
        return ret;
    }

    public JsonArray toJsonArray() {
        JsonArray ret = this.delegate.toJsonArray();
        return ret;
    }

    public Object toJson() {
        Object ret = this.delegate.toJson();
        return ret;
    }

    public byte getByte(int pos) {
        byte ret = this.delegate.getByte(pos);
        return ret;
    }

    public short getUnsignedByte(int pos) {
        short ret = this.delegate.getUnsignedByte(pos);
        return ret;
    }

    public int getInt(int pos) {
        int ret = this.delegate.getInt(pos);
        return ret;
    }

    public int getIntLE(int pos) {
        int ret = this.delegate.getIntLE(pos);
        return ret;
    }

    public long getUnsignedInt(int pos) {
        long ret = this.delegate.getUnsignedInt(pos);
        return ret;
    }

    public long getUnsignedIntLE(int pos) {
        long ret = this.delegate.getUnsignedIntLE(pos);
        return ret;
    }

    public long getLong(int pos) {
        long ret = this.delegate.getLong(pos);
        return ret;
    }

    public long getLongLE(int pos) {
        long ret = this.delegate.getLongLE(pos);
        return ret;
    }

    public double getDouble(int pos) {
        double ret = this.delegate.getDouble(pos);
        return ret;
    }

    public float getFloat(int pos) {
        float ret = this.delegate.getFloat(pos);
        return ret;
    }

    public short getShort(int pos) {
        short ret = this.delegate.getShort(pos);
        return ret;
    }

    public short getShortLE(int pos) {
        short ret = this.delegate.getShortLE(pos);
        return ret;
    }

    public int getUnsignedShort(int pos) {
        int ret = this.delegate.getUnsignedShort(pos);
        return ret;
    }

    public int getUnsignedShortLE(int pos) {
        int ret = this.delegate.getUnsignedShortLE(pos);
        return ret;
    }

    public int getMedium(int pos) {
        int ret = this.delegate.getMedium(pos);
        return ret;
    }

    public int getMediumLE(int pos) {
        int ret = this.delegate.getMediumLE(pos);
        return ret;
    }

    public int getUnsignedMedium(int pos) {
        int ret = this.delegate.getUnsignedMedium(pos);
        return ret;
    }

    public int getUnsignedMediumLE(int pos) {
        int ret = this.delegate.getUnsignedMediumLE(pos);
        return ret;
    }

    public Buffer getBuffer(int start2, int end2) {
        Buffer ret = Buffer.newInstance(this.delegate.getBuffer(start2, end2));
        return ret;
    }

    public String getString(int start2, int end2, String enc) {
        String ret = this.delegate.getString(start2, end2, enc);
        return ret;
    }

    public String getString(int start2, int end2) {
        String ret = this.delegate.getString(start2, end2);
        return ret;
    }

    public Buffer appendBuffer(Buffer buff) {
        this.delegate.appendBuffer(buff.getDelegate());
        return this;
    }

    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        this.delegate.appendBuffer(buff.getDelegate(), offset, len);
        return this;
    }

    public Buffer appendByte(byte b) {
        this.delegate.appendByte(b);
        return this;
    }

    public Buffer appendUnsignedByte(short b) {
        this.delegate.appendUnsignedByte(b);
        return this;
    }

    public Buffer appendInt(int i) {
        this.delegate.appendInt(i);
        return this;
    }

    public Buffer appendIntLE(int i) {
        this.delegate.appendIntLE(i);
        return this;
    }

    public Buffer appendUnsignedInt(long i) {
        this.delegate.appendUnsignedInt(i);
        return this;
    }

    public Buffer appendUnsignedIntLE(long i) {
        this.delegate.appendUnsignedIntLE(i);
        return this;
    }

    public Buffer appendMedium(int i) {
        this.delegate.appendMedium(i);
        return this;
    }

    public Buffer appendMediumLE(int i) {
        this.delegate.appendMediumLE(i);
        return this;
    }

    public Buffer appendLong(long l) {
        this.delegate.appendLong(l);
        return this;
    }

    public Buffer appendLongLE(long l) {
        this.delegate.appendLongLE(l);
        return this;
    }

    public Buffer appendShort(short s2) {
        this.delegate.appendShort(s2);
        return this;
    }

    public Buffer appendShortLE(short s2) {
        this.delegate.appendShortLE(s2);
        return this;
    }

    public Buffer appendUnsignedShort(int s2) {
        this.delegate.appendUnsignedShort(s2);
        return this;
    }

    public Buffer appendUnsignedShortLE(int s2) {
        this.delegate.appendUnsignedShortLE(s2);
        return this;
    }

    public Buffer appendFloat(float f) {
        this.delegate.appendFloat(f);
        return this;
    }

    public Buffer appendDouble(double d) {
        this.delegate.appendDouble(d);
        return this;
    }

    public Buffer appendString(String str2, String enc) {
        this.delegate.appendString(str2, enc);
        return this;
    }

    public Buffer appendString(String str2) {
        this.delegate.appendString(str2);
        return this;
    }

    public Buffer setByte(int pos, byte b) {
        this.delegate.setByte(pos, b);
        return this;
    }

    public Buffer setUnsignedByte(int pos, short b) {
        this.delegate.setUnsignedByte(pos, b);
        return this;
    }

    public Buffer setInt(int pos, int i) {
        this.delegate.setInt(pos, i);
        return this;
    }

    public Buffer setIntLE(int pos, int i) {
        this.delegate.setIntLE(pos, i);
        return this;
    }

    public Buffer setUnsignedInt(int pos, long i) {
        this.delegate.setUnsignedInt(pos, i);
        return this;
    }

    public Buffer setUnsignedIntLE(int pos, long i) {
        this.delegate.setUnsignedIntLE(pos, i);
        return this;
    }

    public Buffer setMedium(int pos, int i) {
        this.delegate.setMedium(pos, i);
        return this;
    }

    public Buffer setMediumLE(int pos, int i) {
        this.delegate.setMediumLE(pos, i);
        return this;
    }

    public Buffer setLong(int pos, long l) {
        this.delegate.setLong(pos, l);
        return this;
    }

    public Buffer setLongLE(int pos, long l) {
        this.delegate.setLongLE(pos, l);
        return this;
    }

    public Buffer setDouble(int pos, double d) {
        this.delegate.setDouble(pos, d);
        return this;
    }

    public Buffer setFloat(int pos, float f) {
        this.delegate.setFloat(pos, f);
        return this;
    }

    public Buffer setShort(int pos, short s2) {
        this.delegate.setShort(pos, s2);
        return this;
    }

    public Buffer setShortLE(int pos, short s2) {
        this.delegate.setShortLE(pos, s2);
        return this;
    }

    public Buffer setUnsignedShort(int pos, int s2) {
        this.delegate.setUnsignedShort(pos, s2);
        return this;
    }

    public Buffer setUnsignedShortLE(int pos, int s2) {
        this.delegate.setUnsignedShortLE(pos, s2);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b) {
        this.delegate.setBuffer(pos, b.getDelegate());
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.delegate.setBuffer(pos, b.getDelegate(), offset, len);
        return this;
    }

    public Buffer setString(int pos, String str2) {
        this.delegate.setString(pos, str2);
        return this;
    }

    public Buffer setString(int pos, String str2, String enc) {
        this.delegate.setString(pos, str2, enc);
        return this;
    }

    public int length() {
        int ret = this.delegate.length();
        return ret;
    }

    public Buffer copy() {
        Buffer ret = Buffer.newInstance(this.delegate.copy());
        return ret;
    }

    public Buffer slice() {
        Buffer ret = Buffer.newInstance(this.delegate.slice());
        return ret;
    }

    public Buffer slice(int start2, int end2) {
        Buffer ret = Buffer.newInstance(this.delegate.slice(start2, end2));
        return ret;
    }

    public static Buffer buffer(byte[] bytes2) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer(bytes2));
        return ret;
    }

    public static Buffer buffer(ByteBuf byteBuf) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer(byteBuf));
        return ret;
    }

    public String toString(Charset enc) {
        String ret = this.delegate.toString(enc);
        return ret;
    }

    public byte[] getBytes() {
        byte[] ret = this.delegate.getBytes();
        return ret;
    }

    public byte[] getBytes(int start2, int end2) {
        byte[] ret = this.delegate.getBytes(start2, end2);
        return ret;
    }

    public Buffer getBytes(byte[] dst) {
        this.delegate.getBytes(dst);
        return this;
    }

    public Buffer getBytes(byte[] dst, int dstIndex) {
        this.delegate.getBytes(dst, dstIndex);
        return this;
    }

    public Buffer getBytes(int start2, int end2, byte[] dst) {
        this.delegate.getBytes(start2, end2, dst);
        return this;
    }

    public Buffer getBytes(int start2, int end2, byte[] dst, int dstIndex) {
        this.delegate.getBytes(start2, end2, dst, dstIndex);
        return this;
    }

    public Buffer appendBytes(byte[] bytes2) {
        this.delegate.appendBytes(bytes2);
        return this;
    }

    public Buffer appendBytes(byte[] bytes2, int offset, int len) {
        this.delegate.appendBytes(bytes2, offset, len);
        return this;
    }

    public Buffer setBytes(int pos, ByteBuffer b) {
        this.delegate.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b) {
        this.delegate.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b, int offset, int len) {
        this.delegate.setBytes(pos, b, offset, len);
        return this;
    }

    public ByteBuf getByteBuf() {
        ByteBuf ret = this.delegate.getByteBuf();
        return ret;
    }

    public static Buffer newInstance(io.vertx.core.buffer.Buffer arg) {
        return arg != null ? new Buffer(arg) : null;
    }
}

