/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.cassandra.CassandraRowStream;
import io.vertx.rxjava.cassandra.ResultSet;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg<CassandraClient>(obj2 -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj2), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    public CassandraClient(Object delegate) {
        this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public static CassandraClient create(io.vertx.rxjava.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient create(io.vertx.rxjava.core.Vertx vertx, CassandraClientOptions options2) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate(), (CassandraClientOptions)options2));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx, String clientName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx, CassandraClientOptions options2) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options2));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx, String clientName, CassandraClientOptions options2) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName, (CassandraClientOptions)options2));
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public CassandraClient execute(String query, final Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(query, (Handler)new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>(){

            @Override
            public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(ResultSet.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CassandraClient execute(String query) {
        return this.execute(query, (AsyncResult<ResultSet> ar) -> {});
    }

    public Single<ResultSet> rxExecute(String query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.execute(query, (Handler<AsyncResult<ResultSet>>)fut)));
    }

    public CassandraClient queryStream(String sql, final Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(sql, (Handler)new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>(){

            @Override
            public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
                if (ar.succeeded()) {
                    rowStreamHandler.handle(Future.succeededFuture(CassandraRowStream.newInstance(ar.result())));
                } else {
                    rowStreamHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CassandraClient queryStream(String sql) {
        return this.queryStream(sql, (AsyncResult<CassandraRowStream> ar) -> {});
    }

    public Single<CassandraRowStream> rxQueryStream(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryStream(sql, (Handler<AsyncResult<CassandraRowStream>>)fut)));
    }

    public CassandraClient close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
        return this;
    }

    public CassandraClient close() {
        return this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public CassandraClient executeWithFullFetch(String query, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(query, resultHandler);
        return this;
    }

    public CassandraClient executeWithFullFetch(String query) {
        return this.executeWithFullFetch(query, (AsyncResult<List<Row>> ar) -> {});
    }

    public Single<List<Row>> rxExecuteWithFullFetch(String query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.executeWithFullFetch(query, (Handler<AsyncResult<List<Row>>>)fut)));
    }

    public CassandraClient executeWithFullFetch(Statement statement, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(statement, resultHandler);
        return this;
    }

    public CassandraClient executeWithFullFetch(Statement statement) {
        return this.executeWithFullFetch(statement, (AsyncResult<List<Row>> ar) -> {});
    }

    public Single<List<Row>> rxExecuteWithFullFetch(Statement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.executeWithFullFetch(statement, (Handler<AsyncResult<List<Row>>>)fut)));
    }

    public CassandraClient execute(Statement statement, final Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(statement, (Handler)new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>(){

            @Override
            public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle(Future.succeededFuture(ResultSet.newInstance(ar.result())));
                } else {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CassandraClient execute(Statement statement) {
        return this.execute(statement, (AsyncResult<ResultSet> ar) -> {});
    }

    public Single<ResultSet> rxExecute(Statement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.execute(statement, (Handler<AsyncResult<ResultSet>>)fut)));
    }

    public CassandraClient prepare(String query, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        this.delegate.prepare(query, resultHandler);
        return this;
    }

    public CassandraClient prepare(String query) {
        return this.prepare(query, (AsyncResult<PreparedStatement> ar) -> {});
    }

    public Single<PreparedStatement> rxPrepare(String query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(query, (Handler<AsyncResult<PreparedStatement>>)fut)));
    }

    public CassandraClient prepare(SimpleStatement statement, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        this.delegate.prepare(statement, resultHandler);
        return this;
    }

    public CassandraClient prepare(SimpleStatement statement) {
        return this.prepare(statement, (AsyncResult<PreparedStatement> ar) -> {});
    }

    public Single<PreparedStatement> rxPrepare(SimpleStatement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(statement, (Handler<AsyncResult<PreparedStatement>>)fut)));
    }

    public CassandraClient queryStream(Statement statement, final Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(statement, (Handler)new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>(){

            @Override
            public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
                if (ar.succeeded()) {
                    rowStreamHandler.handle(Future.succeededFuture(CassandraRowStream.newInstance(ar.result())));
                } else {
                    rowStreamHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public CassandraClient queryStream(Statement statement) {
        return this.queryStream(statement, (AsyncResult<CassandraRowStream> ar) -> {});
    }

    public Single<CassandraRowStream> rxQueryStream(Statement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryStream(statement, (Handler<AsyncResult<CassandraRowStream>>)fut)));
    }

    public void metadata(Handler<AsyncResult<Metadata>> handler) {
        this.delegate.metadata(handler);
    }

    public void metadata() {
        this.metadata(ar -> {});
    }

    public Single<Metadata> rxMetadata() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.metadata((Handler<AsyncResult<Metadata>>)fut)));
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

