/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.amqp;

import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.amqp.AmqpReceiver;
import io.vertx.rxjava.amqp.AmqpSender;
import rx.Single;

@RxGen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg<AmqpConnection>(obj2 -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj2), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    public AmqpConnection(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    public AmqpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpConnection close(Handler<AsyncResult<Void>> done) {
        this.delegate.close(done);
        return this;
    }

    public AmqpConnection close() {
        return this.close(ar -> {});
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public AmqpConnection createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            @Override
            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture(AmqpReceiver.newInstance(ar.result())));
                } else {
                    completionHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createReceiver(String address) {
        return this.createReceiver(address, (AsyncResult<AmqpReceiver> ar) -> {});
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)fut)));
    }

    public AmqpConnection createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            @Override
            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture(AmqpReceiver.newInstance(ar.result())));
                } else {
                    completionHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return this.createReceiver(address, receiverOptions, ar -> {});
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)fut)));
    }

    public AmqpConnection createDynamicReceiver(final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createDynamicReceiver((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            @Override
            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture(AmqpReceiver.newInstance(ar.result())));
                } else {
                    completionHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createDynamicReceiver() {
        return this.createDynamicReceiver(ar -> {});
    }

    public Single<AmqpReceiver> rxCreateDynamicReceiver() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createDynamicReceiver((Handler<AsyncResult<AmqpReceiver>>)fut)));
    }

    public AmqpConnection createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            @Override
            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture(AmqpSender.newInstance(ar.result())));
                } else {
                    completionHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createSender(String address) {
        return this.createSender(address, (AsyncResult<AmqpSender> ar) -> {});
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createSender(address, (Handler<AsyncResult<AmqpSender>>)fut)));
    }

    public AmqpConnection createSender(String address, AmqpSenderOptions options2, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options2, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            @Override
            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture(AmqpSender.newInstance(ar.result())));
                } else {
                    completionHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createSender(String address, AmqpSenderOptions options2) {
        return this.createSender(address, options2, ar -> {});
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options2) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createSender(address, options2, (Handler<AsyncResult<AmqpSender>>)fut)));
    }

    public AmqpConnection createAnonymousSender(final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createAnonymousSender((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            @Override
            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture(AmqpSender.newInstance(ar.result())));
                } else {
                    completionHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createAnonymousSender() {
        return this.createAnonymousSender(ar -> {});
    }

    public Single<AmqpSender> rxCreateAnonymousSender() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.createAnonymousSender((Handler<AsyncResult<AmqpSender>>)fut)));
    }

    public boolean isDisconnected() {
        boolean ret = this.delegate.isDisconnected();
        return ret;
    }

    public Future<Void> closeFuture() {
        AsyncResult ret = this.delegate.closeFuture().map(val2 -> val2);
        return ret;
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

