/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import rx.Observable;
import rx.Subscriber;

public class ReadStreamSubscriber<R, J>
extends Subscriber<R>
implements ReadStream<J> {
    private static final Runnable NOOP_ACTION = () -> {};
    private static final Throwable DONE_SENTINEL = new Throwable();
    public static final int BUFFER_SIZE = 16;
    private Consumer<Subscriber<R>> execOnHandler;
    private final Function<R, J> adapter;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<J> elementHandler;
    private long demand = Long.MAX_VALUE;
    private Throwable completed;
    private ArrayDeque<R> pending = new ArrayDeque();
    private int requested = 0;

    public static <R, J> ReadStream<J> asReadStream(Observable<R> observable2, Function<R, J> adapter) {
        return new ReadStreamSubscriber<R, J>(adapter, observable2::subscribe);
    }

    public ReadStreamSubscriber(Function<R, J> adapter) {
        this(adapter, s2 -> {});
    }

    public ReadStreamSubscriber(Function<R, J> adapter, Consumer<Subscriber<R>> execOnHandler) {
        this.adapter = adapter;
        this.execOnHandler = execOnHandler;
        this.request(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadStream<J> handler(Handler<J> handler) {
        Consumer<Subscriber<R>> action;
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            this.elementHandler = handler;
            action = this.execOnHandler;
            this.execOnHandler = s2 -> {};
        }
        action.accept(this);
        this.checkStatus();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadStream<J> pause() {
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            this.demand = 0L;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadStream<J> fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Invalid amount: " + amount);
        }
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
        }
        this.checkStatus();
        return this;
    }

    @Override
    public ReadStream<J> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus() {
        Runnable action = NOOP_ACTION;
        while (true) {
            J adapted;
            Handler<J> handler;
            ReadStreamSubscriber readStreamSubscriber = this;
            synchronized (readStreamSubscriber) {
                if (this.demand <= 0L || (handler = this.elementHandler) == null || this.pending.size() <= 0) {
                    if (this.completed != null) {
                        if (this.pending.isEmpty()) {
                            Throwable result2;
                            Handler<Throwable> onError;
                            if (this.completed != DONE_SENTINEL) {
                                onError = this.exceptionHandler;
                                result2 = this.completed;
                                this.exceptionHandler = null;
                            } else {
                                onError = null;
                                result2 = null;
                            }
                            Handler<Void> onCompleted = this.endHandler;
                            this.endHandler = null;
                            action = () -> {
                                try {
                                    if (onError != null) {
                                        onError.handle(result2);
                                    }
                                }
                                finally {
                                    if (onCompleted != null) {
                                        onCompleted.handle(null);
                                    }
                                }
                            };
                        }
                    } else if (this.elementHandler != null && this.requested < 8) {
                        int request = 16 - this.requested;
                        action = () -> this.request(request);
                        this.requested = 16;
                    }
                    break;
                }
                if (this.demand != Long.MAX_VALUE) {
                    --this.demand;
                }
                --this.requested;
                R item = this.pending.poll();
                adapted = this.adapter.apply(item);
            }
            handler.handle(adapted);
        }
        action.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadStream<J> endHandler(Handler<Void> handler) {
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            if (this.completed == null || this.pending.size() > 0) {
                this.endHandler = handler;
            } else if (handler != null) {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadStream<J> exceptionHandler(Handler<Throwable> handler) {
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            if (this.completed == null || this.pending.size() > 0) {
                this.exceptionHandler = handler;
            } else if (handler != null) {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    @Override
    public void onCompleted() {
        this.onError(DONE_SENTINEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e2) {
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            if (this.completed != null) {
                return;
            }
            this.completed = e2;
        }
        this.checkStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(R item) {
        ReadStreamSubscriber readStreamSubscriber = this;
        synchronized (readStreamSubscriber) {
            this.pending.add(item);
        }
        this.checkStatus();
    }
}

