/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

public class ObservableOnSubscribeAdapter<T>
implements Observable.OnSubscribe<T> {
    protected final AtomicReference<SingleSubscription> subRef = new AtomicReference();

    @Override
    public void call(Subscriber<? super T> sub) {
        SingleSubscription singleSub = new SingleSubscription(sub);
        if (!this.subRef.compareAndSet(null, singleSub)) {
            throw new IllegalStateException("Cannot have multiple subscriptions");
        }
        sub.add(singleSub);
        try {
            this.onSubscribed();
        }
        catch (Throwable t3) {
            this.fireError(t3);
        }
    }

    protected void onSubscribed() {
    }

    protected void onUnsubscribed() {
    }

    protected final void fireNext(T next2) {
        Subscriber<T> s2 = this.getSubscriber();
        if (s2 != null) {
            s2.onNext(next2);
        }
    }

    protected final void fireResult(T res) {
        Subscriber<T> s2 = this.getSubscriber();
        if (s2 != null) {
            s2.onNext(res);
            this.subRef.set(null);
            s2.onCompleted();
        }
    }

    protected void fireComplete() {
        Subscriber<T> s2 = this.getSubscriber();
        if (s2 != null) {
            this.subRef.set(null);
            s2.onCompleted();
        }
    }

    protected void fireError(Throwable t3) {
        Subscriber<T> s2 = this.getSubscriber();
        if (s2 != null) {
            this.subRef.set(null);
            s2.onError(t3);
        }
    }

    protected Subscriber<? super T> getSubscriber() {
        SingleSubscription singleSub = this.subRef.get();
        return singleSub != null ? singleSub.subscriber : null;
    }

    class SingleSubscription
    implements Subscription {
        final Subscriber<? super T> subscriber;

        SingleSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void unsubscribe() {
            if (this.isUnsubscribed()) {
                return;
            }
            if (ObservableOnSubscribeAdapter.this.subRef.compareAndSet(this, null)) {
                ObservableOnSubscribeAdapter.this.onUnsubscribed();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return ObservableOnSubscribeAdapter.this.subRef.get() != this;
        }
    }
}

