/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableOnSubscribeAdapter;
import rx.Observable;

public class ObservableHandler<T>
extends Observable<T> {
    private HandlerAdapter<T> adapter;

    public ObservableHandler() {
        this(true);
    }

    public ObservableHandler(boolean multi) {
        this(new HandlerAdapter<T>(multi){

            @Override
            protected void dispatch(T event) {
                this.fireNext(event);
            }
        });
    }

    private ObservableHandler(HandlerAdapter<T> adapter) {
        super(adapter);
        this.adapter = adapter;
    }

    public Handler<T> toHandler() {
        return this.adapter;
    }

    private static abstract class HandlerAdapter<T>
    extends ObservableOnSubscribeAdapter<T>
    implements Handler<T> {
        private static final int STATUS_MULTI = 0;
        private static final int STATUS_SINGLE = 1;
        private static final int STATUS_DISPATCHED = 2;
        private boolean subscribed;
        private int status;

        private HandlerAdapter(boolean multi) {
            this.status = multi ? 0 : 1;
        }

        @Override
        public void onSubscribed() {
            this.subscribed = true;
            if (this.status == 2) {
                this.fireComplete();
            }
        }

        @Override
        public void handle(T event) {
            if (this.status == 0) {
                if (this.subscribed) {
                    this.dispatch(event);
                }
            } else if (this.status == 1) {
                if (this.subscribed) {
                    this.dispatch(event);
                    this.fireComplete();
                }
                this.status = 2;
            }
        }

        @Override
        protected void onUnsubscribed() {
            this.subscribed = false;
        }

        protected abstract void dispatch(T var1);
    }
}

