/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rxjava;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.lang.rx.Vertx3RxGeneratorBase;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

class RxJavaGenerator
extends Vertx3RxGeneratorBase {
    RxJavaGenerator() {
        super("rxjava");
        this.name = "RxJava";
    }

    @Override
    protected boolean isImported(TypeInfo type2) {
        return type2.getName().startsWith("rx.") || super.isImported(type2);
    }

    @Override
    protected void genImports(ClassModel model, PrintWriter writer2) {
        writer2.println("import rx.Observable;");
        writer2.println("import rx.Single;");
        writer2.println("import io.vertx.rx.java.RxHelper;");
        writer2.println("import io.vertx.rx.java.WriteStreamSubscriber;");
        writer2.println("import io.vertx.rx.java.SingleOnSubscribeAdapter;");
        super.genImports(model, writer2);
    }

    @Override
    protected void genToObservable(TypeInfo streamType, PrintWriter writer2) {
        writer2.print("  private Observable<");
        writer2.print(this.genTranslatedTypeName(streamType));
        writer2.println("> observable;");
        writer2.println();
        writer2.print("  public synchronized Observable<");
        writer2.print(this.genTranslatedTypeName(streamType));
        writer2.println("> toObservable() {");
        writer2.print("    ");
        writer2.println("if (observable == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer2.print("      Function<");
            writer2.print(streamType.getName());
            writer2.print(", ");
            writer2.print(this.genTranslatedTypeName(streamType));
            writer2.print("> conv = ");
            writer2.print(this.genTranslatedTypeName((TypeInfo)streamType.getRaw()));
            writer2.println("::newInstance;");
            writer2.println("      observable = RxHelper.toObservable(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer2.print("      Function<");
            writer2.print(typeVar);
            writer2.print(", ");
            writer2.print(typeVar);
            writer2.print("> conv = (Function<");
            writer2.print(typeVar);
            writer2.print(", ");
            writer2.print(typeVar);
            writer2.println(">) __typeArg_0.wrap;");
            writer2.println("      observable = RxHelper.toObservable(delegate, conv);");
        } else {
            writer2.println("      observable = RxHelper.toObservable(this.getDelegate());");
        }
        writer2.println("    }");
        writer2.println("    return observable;");
        writer2.println("  }");
        writer2.println();
    }

    @Override
    protected void genToSubscriber(TypeInfo streamType, PrintWriter writer2) {
        writer2.format("  private WriteStreamSubscriber<%s> subscriber;%n", this.genTranslatedTypeName(streamType));
        writer2.println();
        writer2.format("  public synchronized WriteStreamSubscriber<%s> toSubscriber() {%n", this.genTranslatedTypeName(streamType));
        writer2.println("    if (subscriber == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer2.format("      Function<%s, %s> conv = %s::getDelegate;%n", this.genTranslatedTypeName((TypeInfo)streamType.getRaw()), streamType.getName(), this.genTranslatedTypeName(streamType));
            writer2.println("      subscriber = RxHelper.toSubscriber(getDelegate(), conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer2.format("      Function<%s, %s> conv = (Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
            writer2.println("      subscriber = RxHelper.toSubscriber(getDelegate(), conv);");
        } else {
            writer2.println("      subscriber = RxHelper.toSubscriber(getDelegate());");
        }
        writer2.println("    }");
        writer2.println("    return subscriber;");
        writer2.println("  }");
        writer2.println();
    }

    private static TypeInfo unwrap(TypeInfo type2) {
        if (type2 instanceof ParameterizedTypeInfo) {
            return type2.getRaw();
        }
        return type2;
    }

    @Override
    protected void genRxMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer2) {
        ClassTypeInfo type2 = model.getType();
        String packageName = type2.getPackageName();
        writer2.print("  ");
        MethodInfo futMethod = this.genFutureMethod(method);
        this.startMethodTemplate("public", type2, futMethod, "", writer2);
        if (genBody) {
            writer2.println(" { ");
            writer2.println("    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {");
            writer2.print("      ");
            writer2.print(method.getName());
            writer2.print("(");
            writer2.print(futMethod.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
            if (futMethod.getParams().size() > 0) {
                writer2.print(", ");
            }
            writer2.println("fut);");
            writer2.println("    }));");
            writer2.println("  }");
        } else {
            writer2.println(";");
        }
        writer2.println();
    }

    private MethodInfo genFutureMethod(MethodInfo method) {
        String futMethodName = this.genFutureMethodName(method);
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count2 = 0; count2 < size; ++count2) {
            ParamInfo param = method.getParam(count2);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        ParameterizedTypeInfo futReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Single.class).getRaw(), false, Collections.singletonList(futType));
        return method.copy().setName(futMethodName).setParams(futParams).setReturnType((TypeInfo)futReturnType);
    }

    @Override
    protected MethodInfo genOverloadedMethod(MethodInfo method) {
        ArrayList<ParamInfo> params = null;
        int count2 = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Observable.class).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count2, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), (TypeInfo)paramType));
            }
            ++count2;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }

    @Override
    protected void genReadStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer2) {
        writer2.print("  rx.Observable<");
        writer2.print(typeParams.get(0).getName());
        writer2.println("> toObservable();");
        writer2.println();
    }

    @Override
    protected String genConvParam(TypeInfo type2, MethodInfo method, String expr) {
        if (type2.isParameterized() && type2.getRaw().getName().equals("rx.Observable")) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type2;
            String adapterFunction = parameterizedType.getArg(0).isVariable() ? "Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ")obj.getDelegate()";
            return "io.vertx.rx.java.ReadStreamSubscriber.asReadStream(" + expr + "," + adapterFunction + ").resume()";
        }
        return super.genConvParam(type2, method, expr);
    }
}

