/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.lang.rx.AbstractRxGenerator;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Vertx3RxGeneratorBase
extends AbstractRxGenerator {
    public Vertx3RxGeneratorBase(String id) {
        super(id);
    }

    protected abstract MethodInfo genOverloadedMethod(MethodInfo var1);

    protected abstract void genRxMethod(ClassModel var1, MethodInfo var2, List<String> var3, boolean var4, PrintWriter var5);

    @Override
    protected final void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer2) {
        this.genMethod(model, method, cacheDecls, genBody, writer2);
        MethodInfo overload = this.genOverloadedMethod(method);
        if (overload != null) {
            this.genMethod(model, overload, cacheDecls, genBody, writer2);
        }
    }

    private void genMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer2) {
        if (method.getKind() == MethodKind.CALLBACK) {
            this.genSimpleMethod("public", model, method, cacheDecls, genBody, writer2);
            MethodInfo copy2 = method.copy();
            copy2.getParams().remove(copy2.getParams().size() - 1);
            Optional<MethodInfo> any2 = Stream.concat(model.getMethods().stream(), model.getAnyJavaTypeMethods().stream()).filter(m4 -> this.foo((MethodInfo)m4, copy2)).findAny();
            if (!any2.isPresent()) {
                this.startMethodTemplate("public", model.getType(), copy2, "", writer2);
                if (genBody) {
                    writer2.println(" {");
                    writer2.print("    ");
                    if (!copy2.getReturnType().isVoid()) {
                        writer2.println("return ");
                    }
                    writer2.print(method.getName());
                    writer2.print("(");
                    writer2.print(copy2.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
                    if (copy2.getParams().size() > 0) {
                        writer2.print(", ");
                    }
                    writer2.println("ar -> { });");
                    writer2.println("  }");
                    writer2.println();
                } else {
                    writer2.println(";");
                    writer2.println();
                }
            }
            this.genRxMethod(model, method, cacheDecls, genBody, writer2);
        } else {
            this.genSimpleMethod("public", model, method, cacheDecls, genBody, writer2);
        }
    }

    private boolean foo(MethodInfo m1, MethodInfo m22) {
        int numParams = m1.getParams().size();
        if (m1.getName().equals(m22.getName()) && numParams == m22.getParams().size()) {
            for (int index2 = 0; index2 < numParams; ++index2) {
                TypeInfo t22;
                TypeInfo t12 = Vertx3RxGeneratorBase.unwrap(m1.getParam(index2).getType());
                if (t12.equals((Object)(t22 = Vertx3RxGeneratorBase.unwrap(m22.getParam(index2).getType())))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static TypeInfo unwrap(TypeInfo type2) {
        if (type2 instanceof ParameterizedTypeInfo) {
            return type2.getRaw();
        }
        return type2;
    }
}

