/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeArgExpression;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.PrimitiveTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public abstract class AbstractRxGenerator
extends Generator<ClassModel> {
    private String id;
    private Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap = new HashMap<MethodInfo, Map<TypeInfo, String>>();

    public AbstractRxGenerator(String id) {
        this.id = id;
        this.kinds = Collections.singleton("class");
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class, ModuleGen.class);
    }

    public String filename(ClassModel model) {
        ModuleInfo module = model.getModule();
        return module.translateQualifiedName(model.getFqn(), this.id) + ".java";
    }

    public String render(ClassModel model, int index2, int size, Map<String, Object> session) {
        StringWriter sw = new StringWriter();
        PrintWriter writer2 = new PrintWriter(sw);
        this.methodTypeArgMap.clear();
        this.generateClass(model, writer2);
        return sw.toString();
    }

    private void generateClass(ClassModel model, PrintWriter writer2) {
        ClassTypeInfo type2 = model.getType();
        this.generateLicense(writer2);
        writer2.print("package ");
        writer2.print(type2.translatePackageName(this.id));
        writer2.println(";");
        writer2.println();
        this.genImports(model, writer2);
        writer2.println();
        this.generateDoc(model, writer2);
        writer2.println();
        writer2.print("@RxGen(");
        writer2.print(type2.getName());
        writer2.println(".class)");
        writer2.print("public ");
        if (model.isConcrete()) {
            writer2.print("class");
        } else {
            writer2.print("interface");
        }
        writer2.print(" ");
        writer2.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer2.print(" extends ");
            writer2.print(this.genTranslatedTypeName(model.getConcreteSuperType()));
        }
        ArrayList<String> interfaces = new ArrayList<String>();
        if ("io.vertx.core.buffer.Buffer".equals(type2.getName())) {
            interfaces.add("io.vertx.core.shareddata.impl.ClusterSerializable");
        }
        interfaces.addAll(model.getAbstractSuperTypes().stream().map(this::genTranslatedTypeName).collect(Collectors.toList()));
        if (model.isHandler()) {
            interfaces.add("Handler<" + this.genTranslatedTypeName(model.getHandlerArg()) + ">");
        }
        if (model.isIterable()) {
            interfaces.add("Iterable<" + this.genTranslatedTypeName(model.getIterableArg()) + ">");
        }
        if (model.isIterator()) {
            interfaces.add("Iterator<" + this.genTranslatedTypeName(model.getIteratorArg()) + ">");
        }
        if (model.isFunction()) {
            TypeInfo[] functionArgs = model.getFunctionArgs();
            interfaces.add("Function<" + this.genTranslatedTypeName(functionArgs[0]) + ", " + this.genTranslatedTypeName(functionArgs[1]) + ">");
        }
        if (!interfaces.isEmpty()) {
            writer2.print(interfaces.stream().collect(Collectors.joining(", ", model.isConcrete() ? " implements " : " extends ", "")));
        }
        writer2.println(" {");
        writer2.println();
        if (model.isConcrete()) {
            List methods2;
            if ("io.vertx.core.buffer.Buffer".equals(type2.getName())) {
                writer2.println("  @Override");
                writer2.println("  public void writeToBuffer(io.vertx.core.buffer.Buffer buffer) {");
                writer2.println("    delegate.writeToBuffer(buffer);");
                writer2.println("  }");
                writer2.println();
                writer2.println("  @Override");
                writer2.println("  public int readFromBuffer(int pos, io.vertx.core.buffer.Buffer buffer) {");
                writer2.println("    return delegate.readFromBuffer(pos, buffer);");
                writer2.println("  }");
                writer2.println();
            }
            if ((methods2 = model.getMethods()).stream().noneMatch(it -> it.getParams().isEmpty() && "toString".equals(it.getName()))) {
                writer2.println("  @Override");
                writer2.println("  public String toString() {");
                writer2.println("    return delegate.toString();");
                writer2.println("  }");
                writer2.println();
            }
            writer2.println("  @Override");
            writer2.println("  public boolean equals(Object o) {");
            writer2.println("    if (this == o) return true;");
            writer2.println("    if (o == null || getClass() != o.getClass()) return false;");
            writer2.print("    ");
            writer2.print(type2.getSimpleName());
            writer2.print(" that = (");
            writer2.print(type2.getSimpleName());
            writer2.println(") o;");
            writer2.println("    return delegate.equals(that.delegate);");
            writer2.println("  }");
            writer2.println("  ");
            writer2.println("  @Override");
            writer2.println("  public int hashCode() {");
            writer2.println("    return delegate.hashCode();");
            writer2.println("  }");
            writer2.println();
            if (model.isIterable()) {
                this.generateIterableMethod(model, writer2);
            }
            if (model.isIterator()) {
                this.generateIteratorMethods(model, writer2);
            }
            if (model.isFunction()) {
                this.generateFunctionMethod(model, writer2);
            }
            this.generateClassBody(model, model.getIfaceSimpleName(), writer2);
        } else {
            writer2.print("  ");
            writer2.print(type2.getName());
            writer2.println(" getDelegate();");
            writer2.println();
            for (MethodInfo method : model.getMethods()) {
                this.genMethods(model, method, Collections.emptyList(), false, writer2);
            }
            if (type2.getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                this.genReadStream(type2.getParams(), writer2);
            }
        }
        writer2.print("  public static ");
        if (type2.getParams().size() > 0) {
            writer2.print(this.genTypeParamsDecl(type2));
            writer2.print(" ");
        }
        writer2.print(type2.getSimpleName());
        writer2.print(this.genTypeParamsDecl(type2));
        writer2.print(" newInstance(");
        writer2.print(type2.getName());
        writer2.println(" arg) {");
        writer2.print("    return arg != null ? new ");
        writer2.print(type2.getSimpleName());
        if (!model.isConcrete()) {
            writer2.print("Impl");
        }
        writer2.print(this.genTypeParamsDecl(type2));
        writer2.println("(arg) : null;");
        writer2.println("  }");
        writer2.println();
        if (type2.getParams().size() > 0) {
            writer2.print("  public static ");
            writer2.print(this.genTypeParamsDecl(type2));
            writer2.print(" ");
            writer2.print(type2.getSimpleName());
            writer2.print(this.genTypeParamsDecl(type2));
            writer2.print(" newInstance(");
            writer2.print(type2.getName());
            writer2.print(" arg");
            for (TypeParamInfo typeParam : type2.getParams()) {
                writer2.print(", TypeArg<");
                writer2.print(typeParam.getName());
                writer2.print("> __typeArg_");
                writer2.print(typeParam.getName());
            }
            writer2.println(") {");
            writer2.print("    return arg != null ? new ");
            writer2.print(type2.getSimpleName());
            if (!model.isConcrete()) {
                writer2.print("Impl");
            }
            writer2.print(this.genTypeParamsDecl(type2));
            writer2.print("(arg");
            for (TypeParamInfo typeParam : type2.getParams()) {
                writer2.print(", __typeArg_");
                writer2.print(typeParam.getName());
            }
            writer2.println(") : null;");
            writer2.println("  }");
            writer2.println();
        }
        writer2.println("}");
        if (!model.isConcrete()) {
            writer2.println();
            writer2.print("class ");
            writer2.print(type2.getSimpleName());
            writer2.print("Impl");
            writer2.print(this.genTypeParamsDecl(type2));
            writer2.print(" implements ");
            writer2.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
            writer2.println(" {");
            this.generateClassBody(model, type2.getSimpleName() + "Impl", writer2);
            writer2.println("}");
        }
    }

    private void generateIterableMethod(ClassModel model, PrintWriter writer2) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "iterator".equals(it.getName()))) {
            TypeInfo iterableArg = model.getIterableArg();
            writer2.println("  @Override");
            writer2.printf("  public Iterator<%s> iterator() {%n", this.genTranslatedTypeName(iterableArg));
            if (iterableArg.getKind() == ClassKind.API) {
                writer2.format("    Function<%s, %s> conv = %s::newInstance;%n", iterableArg.getName(), this.genTranslatedTypeName((TypeInfo)iterableArg.getRaw()), this.genTranslatedTypeName(iterableArg));
                writer2.println("    return new MappingIterator<>(delegate.iterator(), conv);");
            } else if (iterableArg.isVariable()) {
                String typeVar = iterableArg.getSimpleName();
                writer2.format("    Function<%s, %s> conv = (Function<%s, %s>) __typeArg_0.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer2.println("    return new MappingIterator<>(delegate.iterator(), conv);");
            } else {
                writer2.println("    return delegate.iterator();");
            }
            writer2.println("  }");
            writer2.println();
        }
    }

    private void generateIteratorMethods(ClassModel model, PrintWriter writer2) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "hasNext".equals(it.getName()))) {
            writer2.println("  @Override");
            writer2.println("  public boolean hasNext() {");
            writer2.println("    return delegate.hasNext();");
            writer2.println("  }");
            writer2.println();
        }
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "next".equals(it.getName()))) {
            TypeInfo iteratorArg = model.getIteratorArg();
            writer2.println("  @Override");
            writer2.printf("  public %s next() {%n", this.genTranslatedTypeName(iteratorArg));
            if (iteratorArg.getKind() == ClassKind.API) {
                writer2.format("    return %s.newInstance(delegate.next());%n", this.genTranslatedTypeName(iteratorArg));
            } else if (iteratorArg.isVariable()) {
                writer2.println("    return __typeArg_0.wrap(delegate.next());");
            } else {
                writer2.println("    return delegate.next();");
            }
            writer2.println("  }");
            writer2.println();
        }
    }

    private void generateFunctionMethod(ClassModel model, PrintWriter writer2) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().size() == 1 && "apply".equals(it.getName()))) {
            String typeVar;
            TypeInfo[] functionArgs = model.getFunctionArgs();
            TypeInfo inArg = functionArgs[0];
            TypeInfo outArg = functionArgs[1];
            writer2.println("  @Override");
            writer2.printf("  public %s apply(%s in) {%n", this.genTranslatedTypeName(outArg), this.genTranslatedTypeName(inArg));
            writer2.printf("    %s ret;%n", outArg.getName());
            if (inArg.getKind() == ClassKind.API) {
                writer2.println("    ret = getDelegate().apply(in.getDelegate());");
            } else if (inArg.isVariable()) {
                typeVar = inArg.getSimpleName();
                writer2.format("    Function<%s, %s> inConv = (Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer2.println("    ret = getDelegate().apply(inConv.apply);");
            } else {
                writer2.println("    ret = getDelegate().apply(in);");
            }
            if (outArg.getKind() == ClassKind.API) {
                writer2.format("    Function<%s, %s> outConv = %s::newInstance;%n", outArg.getName(), this.genTranslatedTypeName((TypeInfo)outArg.getRaw()), this.genTranslatedTypeName(outArg));
                writer2.println("    return outConv.apply(ret);");
            } else if (outArg.isVariable()) {
                typeVar = outArg.getSimpleName();
                writer2.format("    Function<%s, %s> outConv = (Function<%s, %s>) __typeArg_1.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer2.println("    return outConv.apply(ret);");
            } else {
                writer2.println("    return delegate.iterator();");
            }
            writer2.println("  }");
            writer2.println();
        }
    }

    protected abstract void genReadStream(List<? extends TypeParamInfo> var1, PrintWriter var2);

    private void generateClassBody(ClassModel model, String constructor, PrintWriter writer2) {
        ClassTypeInfo type2 = model.getType();
        String simpleName2 = type2.getSimpleName();
        if (model.isConcrete()) {
            writer2.print("  public static final TypeArg<");
            writer2.print(simpleName2);
            writer2.print("> __TYPE_ARG = new TypeArg<>(");
            writer2.print("    obj -> new ");
            writer2.print(simpleName2);
            writer2.print("((");
            writer2.print(type2.getName());
            writer2.println(") obj),");
            writer2.print("    ");
            writer2.print(simpleName2);
            writer2.println("::getDelegate");
            writer2.println("  );");
            writer2.println();
        }
        writer2.print("  private final ");
        writer2.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        List typeParams = model.getTypeParams();
        if (typeParams.size() > 0) {
            writer2.print(typeParams.stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">")));
        }
        writer2.println(" delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer2.print("  public final TypeArg<");
            writer2.print(typeParam.getName());
            writer2.print("> __typeArg_");
            writer2.print(typeParam.getIndex());
            writer2.println(";");
        }
        writer2.println("  ");
        writer2.print("  public ");
        writer2.print(constructor);
        writer2.print("(");
        writer2.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer2.println(" delegate) {");
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer2.println("    super(delegate);");
        }
        writer2.println("    this.delegate = delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer2.print("    this.__typeArg_");
            writer2.print(typeParam.getIndex());
            writer2.print(" = TypeArg.unknown();");
        }
        writer2.println("  }");
        writer2.println();
        writer2.print("  public ");
        writer2.print(constructor);
        writer2.print("(Object delegate");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer2.print(", TypeArg<");
            writer2.print(typeParam.getName());
            writer2.print("> typeArg_");
            writer2.print(typeParam.getIndex());
        }
        writer2.println(") {");
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer2.print("    super((");
            writer2.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
            writer2.println(")delegate);");
        }
        writer2.print("    this.delegate = (");
        writer2.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer2.println(")delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer2.print("    this.__typeArg_");
            writer2.print(typeParam.getIndex());
            writer2.print(" = typeArg_");
            writer2.print(typeParam.getIndex());
            writer2.println(";");
        }
        writer2.println("  }");
        writer2.println();
        writer2.print("  public ");
        writer2.print(type2.getName());
        writer2.println(" getDelegate() {");
        writer2.println("    return delegate;");
        writer2.println("  }");
        writer2.println();
        if (model.isReadStream()) {
            this.genToObservable(model.getReadStreamArg(), writer2);
        }
        if (model.isWriteStream()) {
            this.genToSubscriber(model.getWriteStreamArg(), writer2);
        }
        ArrayList methods2 = new ArrayList();
        methods2.addAll(model.getMethods());
        methods2.addAll(model.getAnyJavaTypeMethods());
        int count2 = 0;
        for (MethodInfo method : methods2) {
            TypeInfo returnType = method.getReturnType();
            if (!(returnType instanceof ParameterizedTypeInfo)) continue;
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)returnType;
            List typeArgs = parameterizedType.getArgs();
            HashMap<TypeInfo, String> typeArgMap = new HashMap<TypeInfo, String>();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.getKind() != ClassKind.API || this.containsTypeVariableArgument(typeArg)) continue;
                String typeArgRef = "TYPE_ARG_" + count2++;
                typeArgMap.put(typeArg, typeArgRef);
                this.genTypeArgDecl(typeArg, method, typeArgRef, writer2);
            }
            this.methodTypeArgMap.put(method, typeArgMap);
        }
        if (this.methodTypeArgMap.size() > 0) {
            writer2.println();
        }
        ArrayList<String> cacheDecls = new ArrayList<String>();
        for (MethodInfo method : methods2) {
            this.genMethods(model, method, cacheDecls, true, writer2);
        }
        for (ConstantInfo constant : model.getConstants()) {
            this.genConstant(model, constant, writer2);
        }
        for (String cacheDecl : cacheDecls) {
            writer2.print("  ");
            writer2.print(cacheDecl);
            writer2.println(";");
        }
    }

    protected abstract void genToObservable(TypeInfo var1, PrintWriter var2);

    protected abstract void genToSubscriber(TypeInfo var1, PrintWriter var2);

    protected abstract void genMethods(ClassModel var1, MethodInfo var2, List<String> var3, boolean var4, PrintWriter var5);

    private void genConstant(ClassModel model, ConstantInfo constant, PrintWriter writer2) {
        Doc doc2 = constant.getDoc();
        if (doc2 != null) {
            writer2.println("  /**");
            Token.toHtml((List)doc2.getTokens(), (String)"   *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer2);
            writer2.println("   */");
        }
        writer2.print(model.isConcrete() ? "  public static final" : "");
        writer2.format(" %s %s = %s;\n", this.genTranslatedTypeName(constant.getType()), constant.getName(), this.genConvReturn(constant.getType(), null, model.getType().getName() + "." + constant.getName()));
    }

    protected void startMethodTemplate(String visibility, ClassTypeInfo type2, MethodInfo method, String deprecated2, PrintWriter writer2) {
        Doc doc2 = method.getDoc();
        if (doc2 != null) {
            writer2.println("  /**");
            Token.toHtml((List)doc2.getTokens(), (String)"   *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer2);
            for (ParamInfo param : method.getParams()) {
                writer2.print("   * @param ");
                writer2.print(param.getName());
                writer2.print(" ");
                if (param.getDescription() != null) {
                    Token.toHtml((List)param.getDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer2);
                }
                writer2.println();
            }
            if (!method.getReturnType().getName().equals("void")) {
                writer2.print("   * @return ");
                if (method.getReturnDescription() != null) {
                    Token.toHtml((List)method.getReturnDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer2);
                }
                writer2.println();
            }
            if (deprecated2 != null && deprecated2.length() > 0) {
                writer2.print("   * @deprecated ");
                writer2.println(deprecated2);
            }
            writer2.println("   */");
        }
        if (method.isDeprecated() || deprecated2 != null && deprecated2.length() > 0) {
            writer2.println("  @Deprecated()");
        }
        writer2.print("  ");
        writer2.print(visibility);
        writer2.print(" ");
        if (method.isStaticMethod()) {
            writer2.print("static ");
        }
        if (method.getTypeParams().size() > 0) {
            writer2.print(method.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(", ", "<", ">")));
            writer2.print(" ");
        }
        writer2.print(this.genReturnTypeDecl(method.getReturnType()));
        writer2.print(" ");
        writer2.print(method.getName());
        writer2.print("(");
        writer2.print(method.getParams().stream().map(it -> this.genParamTypeDecl(it.getType()) + " " + it.getName()).collect(Collectors.joining(", ")));
        writer2.print(")");
    }

    protected boolean isImported(TypeInfo type2) {
        switch (type2.getKind()) {
            case JSON_OBJECT: 
            case JSON_ARRAY: 
            case ASYNC_RESULT: 
            case HANDLER: 
            case LIST: 
            case SET: 
            case BOXED_PRIMITIVE: 
            case STRING: 
            case VOID: 
            case FUNCTION: {
                return true;
            }
        }
        return false;
    }

    protected final String genTranslatedTypeName(TypeInfo type2) {
        return this.genTypeName(this.translateType(type2));
    }

    protected String genTypeName(TypeInfo type2) {
        return type2.getName();
    }

    protected TypeInfo translateType(TypeInfo type2) {
        if (type2.isParameterized()) {
            ParameterizedTypeInfo parameterized = (ParameterizedTypeInfo)type2;
            TypeInfo raw = this.translateType((TypeInfo)parameterized.getRaw());
            ArrayList<TypeInfo> args2 = parameterized.getArgs();
            if (raw != parameterized.getRaw()) {
                args2 = new ArrayList<TypeInfo>(args2);
                for (int i = 0; i < args2.size(); ++i) {
                    args2.set(i, this.translateType((TypeInfo)args2.get(i)));
                }
                return new ParameterizedTypeInfo((ClassTypeInfo)raw, parameterized.isNullable(), args2);
            }
            for (int i = 0; i < args2.size(); ++i) {
                TypeInfo arg = this.translateType((TypeInfo)args2.get(i));
                if (arg == args2.get(i)) continue;
                if (args2 == parameterized.getArgs()) {
                    args2 = new ArrayList(parameterized.getArgs());
                }
                args2.set(i, arg);
            }
            if (args2 != parameterized.getArgs()) {
                return new ParameterizedTypeInfo((ClassTypeInfo)raw, parameterized.isNullable(), args2);
            }
        } else if (type2.getKind() == ClassKind.API) {
            ApiTypeInfo api2 = (ApiTypeInfo)type2;
            return new ApiTypeInfo(api2.translateName(this.id), api2.isConcrete(), api2.getParams(), api2.getHandlerArg(), api2.getModule(), api2.isNullable(), api2.isProxyGen(), api2.getDataObject());
        }
        return type2;
    }

    protected final void genSimpleMethod(String visibility, ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer2) {
        ClassTypeInfo type2 = model.getType();
        this.startMethodTemplate(visibility, type2, method, "", writer2);
        if (genBody) {
            writer2.println(" { ");
            if (method.isFluent()) {
                writer2.print("    ");
                writer2.print(this.genInvokeDelegate(model, method));
                writer2.println(";");
                if (method.getReturnType().isVariable()) {
                    writer2.print("    return (");
                    writer2.print(method.getReturnType().getName());
                    writer2.println(") this;");
                } else {
                    writer2.println("    return this;");
                }
            } else if (method.getReturnType().getName().equals("void")) {
                writer2.print("    ");
                writer2.print(this.genInvokeDelegate(model, method));
                writer2.println(";");
            } else {
                if (method.isCacheReturn()) {
                    writer2.print("    if (cached_");
                    writer2.print(cacheDecls.size());
                    writer2.println(" != null) {");
                    writer2.print("      return cached_");
                    writer2.print(cacheDecls.size());
                    writer2.println(";");
                    writer2.println("    }");
                }
                TypeInfo returnType = method.getReturnType();
                String cachedType = method.getReturnType().getKind() == ClassKind.PRIMITIVE ? ((PrimitiveTypeInfo)returnType).getBoxed().getName() : this.genReturnTypeDecl(returnType);
                writer2.print("    ");
                writer2.print(this.genReturnTypeDecl(returnType));
                writer2.print(" ret = ");
                writer2.print(this.genConvReturn(returnType, method, this.genInvokeDelegate(model, method)));
                writer2.println(";");
                if (method.isCacheReturn()) {
                    writer2.print("    cached_");
                    writer2.print(cacheDecls.size());
                    writer2.println(" = ret;");
                    cacheDecls.add("private" + (method.isStaticMethod() ? " static" : "") + " " + cachedType + " cached_" + cacheDecls.size());
                }
                writer2.println("    return ret;");
            }
            writer2.println("  }");
        } else {
            writer2.println(";");
        }
        writer2.println();
    }

    private void generateDoc(ClassModel model, PrintWriter writer2) {
        ClassTypeInfo type2 = model.getType();
        Doc doc2 = model.getDoc();
        if (doc2 != null) {
            writer2.println("/**");
            Token.toHtml((List)doc2.getTokens(), (String)" *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer2);
            writer2.println(" *");
            writer2.println(" * <p/>");
            writer2.print(" * NOTE: This class has been automatically generated from the {@link ");
            writer2.print(type2.getName());
            writer2.println(" original} non RX-ified interface using Vert.x codegen.");
            writer2.println(" */");
        }
    }

    protected void genImports(ClassModel model, PrintWriter writer2) {
        writer2.println("import java.util.Map;");
        writer2.println("import java.util.Set;");
        writer2.println("import java.util.List;");
        writer2.println("import java.util.Iterator;");
        writer2.println("import java.util.function.Function;");
        writer2.println("import java.util.stream.Collectors;");
        writer2.println("import io.vertx.core.Handler;");
        writer2.println("import io.vertx.core.AsyncResult;");
        writer2.println("import io.vertx.core.json.JsonObject;");
        writer2.println("import io.vertx.core.json.JsonArray;");
        writer2.println("import io.vertx.lang.rx.RxGen;");
        writer2.println("import io.vertx.lang.rx.TypeArg;");
        writer2.println("import io.vertx.lang.rx.MappingIterator;");
    }

    protected final String genInvokeDelegate(ClassModel model, MethodInfo method) {
        StringBuilder ret = method.isStaticMethod() ? new StringBuilder(Helper.getNonGenericType((String)model.getIfaceFQCN())) : new StringBuilder("delegate");
        ret.append(".").append(method.getName()).append("(");
        int index2 = 0;
        for (ParamInfo param : method.getParams()) {
            if (index2 > 0) {
                ret.append(", ");
            }
            TypeInfo type2 = param.getType();
            ret.append(this.genConvParam(type2, method, param.getName()));
            ++index2;
        }
        ret.append(")");
        return ret.toString();
    }

    private boolean isSameType(TypeInfo type2, MethodInfo method) {
        ClassKind kind = type2.getKind();
        if (type2.isDataObjectHolder() || kind.basic || kind.json || kind == ClassKind.ENUM || kind == ClassKind.OTHER || kind == ClassKind.THROWABLE || kind == ClassKind.VOID) {
            return true;
        }
        if (kind == ClassKind.OBJECT) {
            if (type2.isVariable()) {
                return !this.isReified((TypeVariableInfo)type2, method);
            }
            return true;
        }
        if (type2.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type2;
            if (kind == ClassKind.LIST || kind == ClassKind.SET || kind == ClassKind.ASYNC_RESULT) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.MAP) {
                return this.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
            if (kind == ClassKind.HANDLER) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.FUNCTION) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method) && this.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
        }
        return false;
    }

    protected String genParamTypeDecl(TypeInfo type2) {
        return this.genTranslatedTypeName(type2);
    }

    protected String genReturnTypeDecl(TypeInfo type2) {
        return this.genTranslatedTypeName(type2);
    }

    protected String genConvParam(TypeInfo type2, MethodInfo method, String expr) {
        ClassKind kind = type2.getKind();
        if (this.isSameType(type2, method)) {
            return expr;
        }
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type2.isVariable() && (typeArg = this.genTypeArg((TypeVariableInfo)type2, method)) != null) {
                return typeArg + ".<" + type2.getName() + ">unwrap(" + expr + ")";
            }
            return expr;
        }
        if (kind == ClassKind.API) {
            return expr + ".getDelegate()";
        }
        if (kind == ClassKind.CLASS_TYPE) {
            return "io.vertx.lang." + this.id + ".Helper.unwrap(" + expr + ")";
        }
        if (type2.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type2;
            if (kind == ClassKind.HANDLER) {
                TypeInfo eventType = parameterizedTypeInfo.getArg(0);
                ClassKind eventKind = eventType.getKind();
                if (eventKind == ClassKind.ASYNC_RESULT) {
                    TypeInfo resultType = ((ParameterizedTypeInfo)eventType).getArg(0);
                    String resultName = this.genTypeName(resultType);
                    return "new Handler<AsyncResult<" + resultName + ">>() {\n      public void handle(AsyncResult<" + resultName + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + this.genConvReturn(resultType, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                String eventName = this.genTypeName(eventType);
                return "new Handler<" + eventName + ">() {\n      public void handle(" + eventName + " event) {\n        " + expr + ".handle(" + this.genConvReturn(eventType, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.FUNCTION) {
                TypeInfo argType = parameterizedTypeInfo.getArg(0);
                TypeInfo retType = parameterizedTypeInfo.getArg(1);
                String argName = this.genTypeName(argType);
                String retName = this.genTypeName(retType);
                return "new Function<" + argName + "," + retName + ">() {\n      public " + retName + " apply(" + argName + " arg) {\n        " + this.genParamTypeDecl(retType) + " ret = " + expr + ".apply(" + this.genConvReturn(argType, method, "arg") + ");\n        return " + this.genConvParam(retType, method, "ret") + ";\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + this.genConvParam(parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(Collectors.to" + type2.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> " + this.genConvParam(parameterizedTypeInfo.getArg(1), method, "e.getValue()") + "))";
            }
            if (kind == ClassKind.FUTURE) {
                ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)type2;
                return expr + ".map(val -> " + this.genConvParam(futureType.getArg(0), method, "val") + ")";
            }
        }
        return expr;
    }

    private boolean isReified(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return true;
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        return typeArg != null && typeArg.isClassType();
    }

    private String genTypeArg(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return "__typeArg_" + typeVar.getParam().getIndex();
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        if (typeArg != null) {
            if (typeArg.isClassType()) {
                return "TypeArg.of(" + typeArg.getParam().getName() + ")";
            }
            if (!method.isStaticMethod()) {
                return typeArg.getParam().getName() + ".__typeArg_" + typeArg.getIndex();
            }
        }
        return null;
    }

    private void genTypeArgDecl(TypeInfo typeArg, MethodInfo method, String typeArgRef, PrintWriter writer2) {
        StringBuilder sb = new StringBuilder();
        this.genTypeArg(typeArg, method, 1, sb);
        writer2.print("  private static final TypeArg<");
        writer2.print(typeArg.translateName(this.id));
        writer2.print("> ");
        writer2.print(typeArgRef);
        writer2.print(" = ");
        writer2.print(sb);
        writer2.println(";");
    }

    private void genTypeArg(TypeInfo arg, MethodInfo method, int depth, StringBuilder sb) {
        ClassKind argKind = arg.getKind();
        if (argKind == ClassKind.API) {
            sb.append("new TypeArg<").append(arg.translateName(this.id)).append(">(o").append(depth).append(" -> ");
            sb.append(arg.getRaw().translateName(this.id)).append(".newInstance((").append(arg.getRaw()).append(")o").append(depth);
            if (arg instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)arg;
                List args2 = parameterizedType.getArgs();
                for (int i = 0; i < args2.size(); ++i) {
                    sb.append(", ");
                    this.genTypeArg((TypeInfo)args2.get(i), method, depth + 1, sb);
                }
            }
            sb.append(")");
            sb.append(", o").append(depth).append(" -> o").append(depth).append(".getDelegate())");
        } else {
            String resolved;
            String typeArg = "TypeArg.unknown()";
            if (argKind == ClassKind.OBJECT && arg.isVariable() && (resolved = this.genTypeArg((TypeVariableInfo)arg, method)) != null) {
                typeArg = resolved;
            }
            sb.append(typeArg);
        }
    }

    private String genTypeArg(TypeInfo arg, MethodInfo method) {
        String typeArgRef;
        Map<TypeInfo, String> typeArgMap = this.methodTypeArgMap.get(method);
        if (typeArgMap != null && (typeArgRef = typeArgMap.get(arg)) != null) {
            return typeArgRef;
        }
        StringBuilder sb = new StringBuilder();
        this.genTypeArg(arg, method, 0, sb);
        return sb.toString();
    }

    protected String genConvReturn(TypeInfo type2, MethodInfo method, String expr) {
        ClassKind kind = type2.getKind();
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type2.isVariable() && (typeArg = this.genTypeArg((TypeVariableInfo)type2, method)) != null) {
                return "(" + type2.getName() + ")" + typeArg + ".wrap(" + expr + ")";
            }
            return "(" + type2.getSimpleName() + ") " + expr;
        }
        if (this.isSameType(type2, method)) {
            return expr;
        }
        if (kind == ClassKind.API) {
            StringBuilder tmp = new StringBuilder(type2.getRaw().translateName(this.id));
            tmp.append(".newInstance((");
            tmp.append(type2.getRaw());
            tmp.append(")");
            tmp.append(expr);
            if (type2.isParameterized()) {
                ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type2;
                for (TypeInfo arg : parameterizedTypeInfo.getArgs()) {
                    tmp.append(", ");
                    tmp.append(this.genTypeArg(arg, method));
                }
            }
            tmp.append(")");
            return tmp.toString();
        }
        if (type2.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type2;
            if (kind == ClassKind.HANDLER) {
                TypeInfo abc = parameterizedTypeInfo.getArg(0);
                if (abc.getKind() == ClassKind.ASYNC_RESULT) {
                    TypeInfo tutu = ((ParameterizedTypeInfo)abc).getArg(0);
                    return "new Handler<AsyncResult<" + this.genParamTypeDecl(tutu) + ">>() {\n      public void handle(AsyncResult<" + this.genParamTypeDecl(tutu) + "> ar) {\n        if (ar.succeeded()) {\n          " + expr + ".handle(io.vertx.core.Future.succeededFuture(" + this.genConvParam(tutu, method, "ar.result()") + "));\n        } else {\n          " + expr + ".handle(io.vertx.core.Future.failedFuture(ar.cause()));\n        }\n      }\n    }";
                }
                return "new Handler<" + this.genParamTypeDecl(abc) + ">() {\n      public void handle(" + this.genParamTypeDecl(abc) + " event) {\n          " + expr + ".handle(" + this.genConvParam(abc, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + this.genConvReturn(parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(Collectors.to" + type2.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> " + this.genConvReturn(parameterizedTypeInfo.getArg(1), method, "_e.getValue()") + "))";
            }
            if (kind == ClassKind.FUTURE) {
                ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)type2;
                return expr + ".map(val -> " + this.genConvReturn(futureType.getArg(0), method, "val") + ")";
            }
        }
        return expr;
    }

    protected final String genFutureMethodName(MethodInfo method) {
        return "rx" + Character.toUpperCase(method.getName().charAt(0)) + method.getName().substring(1);
    }

    private String genTypeParamsDecl(ClassTypeInfo type2) {
        if (type2.getParams().size() > 0) {
            return type2.getParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">"));
        }
        return "";
    }

    private void generateLicense(PrintWriter writer2) {
        writer2.println("/*");
        writer2.println(" * Copyright 2014 Red Hat, Inc.");
        writer2.println(" *");
        writer2.println(" * Red Hat licenses this file to you under the Apache License, version 2.0");
        writer2.println(" * (the \"License\"); you may not use this file except in compliance with the");
        writer2.println(" * License.  You may obtain a copy of the License at:");
        writer2.println(" *");
        writer2.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        writer2.println(" *");
        writer2.println(" * Unless required by applicable law or agreed to in writing, software");
        writer2.println(" * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        writer2.println(" * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        writer2.println(" * License for the specific language governing permissions and limitations");
        writer2.println(" * under the License.");
        writer2.println(" */");
        writer2.println();
    }

    private String renderLinkToHtml(Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.API) {
                Element elt = link.getTargetElement();
                String eltKind = elt.getKind().name();
                String ret = "{@link " + rawType.translateName(this.id);
                if ("METHOD".equals(eltKind)) {
                    ret = ret + "#" + elt.getSimpleName().toString();
                }
                if (label.length() > 0) {
                    ret = ret + " " + label;
                }
                ret = ret + "}";
                return ret;
            }
        }
        return "{@link " + rawType.getName() + "}";
    }

    private boolean containsTypeVariableArgument(TypeInfo type2) {
        if (type2.isVariable()) {
            return true;
        }
        if (type2.isParameterized()) {
            List typeArgs = ((ParameterizedTypeInfo)type2).getArgs();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.isVariable()) {
                    return true;
                }
                if (!typeArg.isParameterized() || !this.containsTypeVariableArgument(typeArg)) continue;
                return true;
            }
        }
        return false;
    }
}

