/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.sstore.impl.SessionInternal;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class AbstractSession
implements Session,
SessionInternal {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_INT = 2;
    private static final byte TYPE_SHORT = 3;
    private static final byte TYPE_BYTE = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_FLOAT = 6;
    private static final byte TYPE_CHAR = 7;
    private static final byte TYPE_BOOLEAN = 8;
    private static final byte TYPE_STRING = 9;
    private static final byte TYPE_BUFFER = 10;
    private static final byte TYPE_BYTES = 11;
    private static final byte TYPE_CLUSTER_SERIALIZABLE = 13;
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private VertxContextPRNG prng;
    private String id;
    private long timeout;
    private volatile Map<String, Object> data;
    private long lastAccessed;
    private int version;
    private boolean destroyed;
    private boolean renewed;
    private String oldId;
    private int crc;

    protected void setId(String id) {
        this.id = id;
    }

    protected void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void setData(Map<String, Object> data2) {
        if (data2 != null) {
            this.data = data2;
            this.crc = this.checksum();
        }
    }

    protected void setData(JsonObject data2) {
        if (data2 != null) {
            this.setData(data2.getMap());
        }
    }

    protected void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public AbstractSession() {
    }

    public AbstractSession(VertxContextPRNG random) {
        this.prng = random;
    }

    public AbstractSession(VertxContextPRNG random, long timeout, int length) {
        this.prng = random;
        this.id = AbstractSession.generateId(this.prng, length);
        this.timeout = timeout;
        this.lastAccessed = System.currentTimeMillis();
    }

    public void setPRNG(VertxContextPRNG prng) {
        this.prng = prng;
    }

    @Override
    public void flushed(boolean skipCrc) {
        this.renewed = false;
        if (this.oldId != null) {
            if (!skipCrc) {
                this.crc = this.checksum();
            }
            this.oldId = null;
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Session regenerateId() {
        if (this.oldId == null) {
            this.oldId = this.id;
        }
        this.id = AbstractSession.generateId(this.prng, this.oldId.length() / 2);
        this.renewed = true;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public <T> @Nullable T get(String key2) {
        if (this.isEmpty()) {
            return null;
        }
        Object obj2 = this.data().get(key2);
        return (T)obj2;
    }

    @Override
    public Session put(String key2, Object obj2) {
        Map<String, Object> data2 = this.data();
        if (obj2 == null) {
            data2.remove(key2);
        } else {
            data2.put(key2, obj2);
        }
        return this;
    }

    @Override
    public Session putIfAbsent(String key2, Object obj2) {
        this.data().putIfAbsent(key2, obj2);
        return this;
    }

    @Override
    public Session computeIfAbsent(String key2, Function<String, Object> mappingFunction) {
        this.data().computeIfAbsent(key2, mappingFunction);
        return this;
    }

    @Override
    public <T> @Nullable T remove(String key2) {
        if (this.isEmpty()) {
            return null;
        }
        Object obj2 = this.data().remove(key2);
        return (T)obj2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> data() {
        if (this.data == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.data == null) {
                    if (this.destroyed) {
                        this.regenerateId();
                        this.destroyed = false;
                    }
                    this.data = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null || this.data.size() == 0;
    }

    @Override
    public long lastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public void setAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.destroyed = true;
            this.data = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isRegenerated() {
        return this.renewed;
    }

    @Override
    public String oldId() {
        return this.oldId;
    }

    public int version() {
        return this.version;
    }

    public void incrementVersion() {
        int old = this.crc;
        this.crc = this.checksum();
        if (this.crc != old) {
            ++this.version;
        }
    }

    private static String generateId(VertxContextPRNG rng, int length) {
        byte[] bytes2 = new byte[length];
        rng.nextBytes(bytes2);
        char[] hex = new char[length * 2];
        for (int j = 0; j < length; ++j) {
            int v = bytes2[j] & 0xFF;
            hex[j * 2] = HEX[v >>> 4];
            hex[j * 2 + 1] = HEX[v & 0xF];
        }
        return new String(hex);
    }

    protected int crc() {
        return this.crc;
    }

    protected int checksum() {
        if (this.isEmpty()) {
            return 0;
        }
        int result2 = 1;
        for (Map.Entry<String, Object> kv : this.data.entrySet()) {
            String key2 = kv.getKey();
            result2 = 31 * result2 + key2.hashCode();
            Object value = kv.getValue();
            if (value == null) continue;
            result2 = 31 * result2 + value.hashCode();
        }
        return result2;
    }

    protected void writeDataToBuffer(Buffer buffer) {
        if (this.isEmpty()) {
            buffer.appendInt(0);
        } else {
            Map<String, Object> data2 = this.data();
            buffer.appendInt(data2.size());
            for (Map.Entry<String, Object> entry : data2.entrySet()) {
                byte[] bytes2;
                String key2 = entry.getKey();
                byte[] keyBytes = key2.getBytes(UTF8);
                buffer.appendInt(keyBytes.length).appendBytes(keyBytes);
                Object val2 = entry.getValue();
                if (val2 instanceof Long) {
                    buffer.appendByte((byte)1).appendLong((Long)val2);
                    continue;
                }
                if (val2 instanceof Integer) {
                    buffer.appendByte((byte)2).appendInt((Integer)val2);
                    continue;
                }
                if (val2 instanceof Short) {
                    buffer.appendByte((byte)3).appendShort((Short)val2);
                    continue;
                }
                if (val2 instanceof Byte) {
                    buffer.appendByte((byte)4).appendByte((Byte)val2);
                    continue;
                }
                if (val2 instanceof Double) {
                    buffer.appendByte((byte)5).appendDouble((Double)val2);
                    continue;
                }
                if (val2 instanceof Float) {
                    buffer.appendByte((byte)6).appendFloat(((Float)val2).floatValue());
                    continue;
                }
                if (val2 instanceof Character) {
                    buffer.appendByte((byte)7).appendShort((short)((Character)val2).charValue());
                    continue;
                }
                if (val2 instanceof Boolean) {
                    buffer.appendByte((byte)8).appendByte((byte)((Boolean)val2 != false ? 1 : 0));
                    continue;
                }
                if (val2 instanceof String) {
                    bytes2 = ((String)val2).getBytes(UTF8);
                    buffer.appendByte((byte)9).appendInt(bytes2.length).appendBytes(bytes2);
                    continue;
                }
                if (val2 instanceof Buffer) {
                    Buffer buff = (Buffer)val2;
                    buffer.appendByte((byte)10).appendInt(buff.length()).appendBuffer(buff);
                    continue;
                }
                if (val2 instanceof byte[]) {
                    bytes2 = (byte[])val2;
                    buffer.appendByte((byte)11).appendInt(bytes2.length).appendBytes(bytes2);
                    continue;
                }
                if (val2 instanceof ClusterSerializable) {
                    buffer.appendByte((byte)13);
                    String className = val2.getClass().getName();
                    byte[] classNameBytes = className.getBytes(UTF8);
                    buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
                    ((ClusterSerializable)val2).writeToBuffer(buffer);
                    continue;
                }
                if (val2 == null) continue;
                throw new IllegalStateException("Invalid type for data in session: " + val2.getClass());
            }
        }
    }

    protected int readDataFromBuffer(int pos, Buffer buffer) {
        try {
            int entries2 = buffer.getInt(pos);
            pos += 4;
            if (entries2 > 0) {
                ConcurrentHashMap<String, Object> data2 = new ConcurrentHashMap<String, Object>(entries2);
                for (int i = 0; i < entries2; ++i) {
                    Object val2;
                    int keylen = buffer.getInt(pos);
                    byte[] keyBytes = buffer.getBytes(pos += 4, pos + keylen);
                    pos += keylen;
                    String key2 = new String(keyBytes, UTF8);
                    byte type2 = buffer.getByte(pos++);
                    switch (type2) {
                        case 1: {
                            val2 = buffer.getLong(pos);
                            pos += 8;
                            break;
                        }
                        case 2: {
                            val2 = buffer.getInt(pos);
                            pos += 4;
                            break;
                        }
                        case 3: {
                            val2 = buffer.getShort(pos);
                            pos += 2;
                            break;
                        }
                        case 4: {
                            val2 = buffer.getByte(pos);
                            ++pos;
                            break;
                        }
                        case 6: {
                            val2 = Float.valueOf(buffer.getFloat(pos));
                            pos += 4;
                            break;
                        }
                        case 5: {
                            val2 = buffer.getDouble(pos);
                            pos += 8;
                            break;
                        }
                        case 7: {
                            short s2 = buffer.getShort(pos);
                            pos += 2;
                            val2 = Character.valueOf((char)s2);
                            break;
                        }
                        case 8: {
                            byte b = buffer.getByte(pos);
                            ++pos;
                            val2 = b == 1;
                            break;
                        }
                        case 9: {
                            int len = buffer.getInt(pos);
                            byte[] bytes2 = buffer.getBytes(pos += 4, pos + len);
                            val2 = new String(bytes2, UTF8);
                            pos += len;
                            break;
                        }
                        case 10: {
                            int len = buffer.getInt(pos);
                            byte[] bytes2 = buffer.getBytes(pos += 4, pos + len);
                            val2 = Buffer.buffer(bytes2);
                            pos += len;
                            break;
                        }
                        case 11: {
                            int len = buffer.getInt(pos);
                            val2 = buffer.getBytes(pos += 4, pos + len);
                            pos += len;
                            break;
                        }
                        case 13: {
                            int classNameLen = buffer.getInt(pos);
                            byte[] classNameBytes = buffer.getBytes(pos += 4, pos + classNameLen);
                            pos += classNameLen;
                            String className = new String(classNameBytes, UTF8);
                            Class<?> clazz = Utils.getClassLoader().loadClass(className);
                            if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                                throw new ClassCastException(new String(classNameBytes, StandardCharsets.UTF_8) + " is not assignable from ClusterSerializable");
                            }
                            ClusterSerializable obj2 = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            pos = obj2.readFromBuffer(pos, buffer);
                            val2 = obj2;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid serialized type: " + type2);
                        }
                    }
                    data2.put(key2, val2);
                }
                this.setData(data2);
            }
            return pos;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            throw new VertxException(e2);
        }
    }

    protected void readDataFromBuffer(Buffer buffer) {
        this.readDataFromBuffer(0, buffer);
    }
}

