/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.multipart.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.multipart.FormDataPart;
import io.vertx.ext.web.multipart.MultipartForm;
import io.vertx.ext.web.multipart.impl.FormDataPartImpl;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultipartFormImpl
implements MultipartForm {
    private Charset charset = StandardCharsets.UTF_8;
    private final List<FormDataPart> parts = new ArrayList<FormDataPart>();

    @Override
    public MultipartForm setCharset(String charset) {
        return this.setCharset(charset != null ? Charset.forName(charset) : null);
    }

    @Override
    public MultipartForm setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public MultipartForm attribute(String name2, String value) {
        this.parts.add(new FormDataPartImpl(name2, value));
        return this;
    }

    @Override
    public MultipartForm textFileUpload(String name2, String filename, String pathname, String mediaType) {
        this.parts.add(new FormDataPartImpl(name2, filename, pathname, mediaType, true));
        return this;
    }

    @Override
    public MultipartForm textFileUpload(String name2, String filename, Buffer content, String mediaType) {
        this.parts.add(new FormDataPartImpl(name2, filename, content, mediaType, true));
        return this;
    }

    @Override
    public MultipartForm binaryFileUpload(String name2, String filename, String pathname, String mediaType) {
        this.parts.add(new FormDataPartImpl(name2, filename, pathname, mediaType, false));
        return this;
    }

    @Override
    public MultipartForm binaryFileUpload(String name2, String filename, Buffer content, String mediaType) {
        this.parts.add(new FormDataPartImpl(name2, filename, content, mediaType, false));
        return this;
    }

    @Override
    public Iterator<FormDataPart> iterator() {
        return this.parts.iterator();
    }
}

