/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public class Utils {
    private static final ZoneId ZONE_GMT = ZoneId.of("GMT");
    private static final Pattern CACHE_CONTROL_NO_CACHE_REGEXP = Pattern.compile("(?:^|,)\\s*?no-cache\\s*?(?:,|$)");

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null && (cl = Utils.class.getClassLoader()) == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }

    public static String formatRFC1123DateTime(long time2) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(time2).atZone(ZONE_GMT));
    }

    public static long parseRFC1123DateTime(String header) {
        try {
            return header == null || header.isEmpty() ? -1L : LocalDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException ex) {
            return -1L;
        }
    }

    public static String pathOffset(String path2, RoutingContext context) {
        String routePath;
        String rest;
        Route route = context.currentRoute();
        if (route == null) {
            return path2;
        }
        if (!route.isExactPath() && (rest = context.pathParam("*")) != null) {
            if (rest.length() > 0) {
                if ((rest = HttpUtils.removeDots(rest.replace('\\', '/'))).charAt(0) == '/') {
                    return rest;
                }
                return "/" + rest;
            }
            return "/";
        }
        int prefixLen = 0;
        String mountPoint = context.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
            if (mountPoint.charAt(mountPoint.length() - 1) == '/') {
                --prefixLen;
            }
        }
        if (!route.isRegexPath() && (routePath = route.getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path2.substring(prefixLen) : path2;
    }

    public static long secondsFactor(long millis2) {
        return millis2 - millis2 % 1000L;
    }

    public static boolean isJsonContentType(String contentType) {
        return contentType.contains("application/json") || contentType.contains("+json");
    }

    public static boolean isXMLContentType(String contentType) {
        return contentType.contains("application/xml") || contentType.contains("text/xml") || contentType.contains("+xml");
    }

    public static void addToMapIfAbsent(MultiMap map2, CharSequence key2, CharSequence value) {
        if (!map2.contains(key2)) {
            map2.set(key2, value);
        }
    }

    public static void appendToMapIfAbsent(MultiMap map2, CharSequence key2, CharSequence sep, CharSequence value) {
        if (!map2.contains(key2)) {
            map2.set(key2, value);
        } else {
            String existing = map2.get(key2);
            map2.set(key2, (CharSequence)(existing + sep + value));
        }
    }

    public static boolean fresh(RoutingContext ctx) {
        return Utils.fresh(ctx, -1L);
    }

    public static boolean fresh(RoutingContext ctx, long lastModified) {
        HttpServerRequest req = ctx.request();
        HttpServerResponse res = ctx.response();
        String modifiedSince = req.getHeader(HttpHeaders.IF_MODIFIED_SINCE);
        String noneMatch = req.getHeader(HttpHeaders.IF_NONE_MATCH);
        if (modifiedSince == null && noneMatch == null) {
            return false;
        }
        String cacheControl = req.getHeader(HttpHeaders.CACHE_CONTROL);
        if (cacheControl != null && CACHE_CONTROL_NO_CACHE_REGEXP.matcher(cacheControl).find()) {
            return false;
        }
        if (noneMatch != null && !"*".equals(noneMatch)) {
            String match2;
            String etag = res.headers().get(HttpHeaders.ETAG);
            if (etag == null) {
                return false;
            }
            boolean etagStale = true;
            int end2 = 0;
            int start2 = 0;
            block4: for (int i = 0; i < noneMatch.length(); ++i) {
                switch (noneMatch.charAt(i)) {
                    case ' ': {
                        if (start2 != end2) continue block4;
                        start2 = end2 = i + 1;
                        continue block4;
                    }
                    case ',': {
                        String match3 = noneMatch.substring(start2, end2);
                        if (match3.equals(etag) || match3.equals("W/" + etag) || ("W/" + match3).equals(etag)) {
                            etagStale = false;
                            break block4;
                        }
                        start2 = end2 = i + 1;
                        continue block4;
                    }
                    default: {
                        end2 = i + 1;
                    }
                }
            }
            if (etagStale && !(match2 = noneMatch.substring(start2, end2)).equals(etag) && !match2.equals("W/" + etag) && !("W/" + match2).equals(etag)) {
                return false;
            }
        }
        if (modifiedSince != null) {
            if (lastModified == -1L) {
                lastModified = Utils.parseRFC1123DateTime(res.headers().get(HttpHeaders.LAST_MODIFIED));
            }
            boolean modifiedStale = lastModified == -1L || lastModified > Utils.parseRFC1123DateTime(modifiedSince);
            return !modifiedStale;
        }
        return true;
    }

    public static boolean canUpgradeToWebsocket(HttpServerRequest req) {
        MultiMap headers = req.headers();
        if (headers.contains(HttpHeaders.CONNECTION)) {
            for (String connection : headers.getAll(HttpHeaders.CONNECTION)) {
                if (!connection.toLowerCase().contains(HttpHeaders.UPGRADE) || !headers.contains(HttpHeaders.UPGRADE)) continue;
                for (String upgrade : headers.getAll(HttpHeaders.UPGRADE)) {
                    if (!upgrade.toLowerCase().contains(HttpHeaders.WEBSOCKET)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

