/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouteState;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class RoutingContextImplBase
implements RoutingContextInternal {
    private static final AtomicIntegerFieldUpdater<RoutingContextImplBase> CURRENT_ROUTE_NEXT_HANDLER_INDEX = AtomicIntegerFieldUpdater.newUpdater(RoutingContextImplBase.class, "currentRouteNextHandlerIndex");
    private static final AtomicIntegerFieldUpdater<RoutingContextImplBase> CURRENT_ROUTE_NEXT_FAILURE_HANDLER_INDEX = AtomicIntegerFieldUpdater.newUpdater(RoutingContextImplBase.class, "currentRouteNextFailureHandlerIndex");
    protected static final Logger LOG = LoggerFactory.getLogger(RoutingContext.class);
    private final Set<RouteImpl> routes;
    protected final Router currentRouter;
    protected final String mountPoint;
    private volatile int currentRouteNextHandlerIndex;
    private volatile int currentRouteNextFailureHandlerIndex;
    protected Iterator<RouteImpl> iter;
    protected RouteState currentRoute;
    int matchFailure;
    int matchRest = -1;
    boolean normalizedMatch;
    private volatile long seen;
    protected Set<HttpMethod> allowedMethods = new HashSet<HttpMethod>();

    RoutingContextImplBase(String mountPoint, Set<RouteImpl> routes, Router currentRouter) {
        this.mountPoint = mountPoint;
        this.routes = routes;
        this.iter = routes.iterator();
        this.currentRouter = currentRouter;
        this.resetMatchFailure();
    }

    @Override
    public synchronized RoutingContextInternal visitHandler(int id) {
        this.seen |= (long)id;
        return this;
    }

    @Override
    public boolean seenHandler(int id) {
        return (this.seen & (long)id) != 0L;
    }

    @Override
    public int restIndex() {
        return this.matchRest;
    }

    @Override
    public boolean normalizedMatch() {
        return this.normalizedMatch;
    }

    @Override
    public synchronized RoutingContextInternal setMatchFailure(int matchFailure) {
        this.matchFailure = matchFailure;
        return this;
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        if (this.currentRoute == null) {
            return null;
        }
        return this.currentRoute.getRoute();
    }

    @Override
    public Router currentRouter() {
        return this.currentRouter;
    }

    int currentRouteNextHandlerIndex() {
        return this.currentRouteNextHandlerIndex;
    }

    int currentRouteNextFailureHandlerIndex() {
        return this.currentRouteNextFailureHandlerIndex;
    }

    void restart() {
        this.iter = this.routes.iterator();
        this.currentRoute = null;
        this.next();
    }

    boolean iterateNext() {
        boolean failed = this.failed();
        if (this.currentRoute != null) {
            try {
                if (!failed && this.currentRoute.hasNextContextHandler(this)) {
                    CURRENT_ROUTE_NEXT_HANDLER_INDEX.incrementAndGet(this);
                    this.resetMatchFailure();
                    this.currentRoute.handleContext(this);
                    return true;
                }
                if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                    CURRENT_ROUTE_NEXT_FAILURE_HANDLER_INDEX.incrementAndGet(this);
                    this.currentRoute.handleFailure(this);
                    return true;
                }
            }
            catch (Throwable t3) {
                this.handleInHandlerRuntimeFailure(this.currentRoute.getRouter(), failed, t3);
                return true;
            }
        }
        while (this.iter.hasNext()) {
            RouteState routeState = this.iter.next().state();
            CURRENT_ROUTE_NEXT_HANDLER_INDEX.set(this, 0);
            CURRENT_ROUTE_NEXT_FAILURE_HANDLER_INDEX.set(this, 0);
            try {
                int matchResult = routeState.matches(this, this.mountPoint(), failed);
                if (matchResult == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Route matches: " + routeState);
                    }
                    this.resetMatchFailure();
                    try {
                        this.currentRoute = routeState;
                        this.request().routed(this.currentRoute.getName());
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Calling the " + (failed ? "failure" : "") + " handler");
                        }
                        if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                            CURRENT_ROUTE_NEXT_FAILURE_HANDLER_INDEX.incrementAndGet(this);
                            routeState.handleFailure(this);
                        } else {
                            if (!this.currentRoute.hasNextContextHandler(this)) continue;
                            CURRENT_ROUTE_NEXT_HANDLER_INDEX.incrementAndGet(this);
                            routeState.handleContext(this);
                        }
                    }
                    catch (Throwable t4) {
                        this.handleInHandlerRuntimeFailure(routeState.getRouter(), failed, t4);
                    }
                    return true;
                }
                if (matchResult == 405) {
                    this.allowedMethods.addAll(routeState.getMethods());
                    if (this.matchFailure != 404) continue;
                    this.matchFailure = matchResult;
                    continue;
                }
                if (matchResult == 404) continue;
                this.matchFailure = matchResult;
            }
            catch (Throwable e2) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("IllegalArgumentException thrown during iteration", e2);
                }
                if (!this.response().ended()) {
                    this.unhandledFailure(e2 instanceof IllegalArgumentException ? 400 : -1, e2, routeState.getRouter());
                }
                return true;
            }
        }
        return false;
    }

    private void handleInHandlerRuntimeFailure(RouterImpl router2, boolean failed, Throwable t3) {
        if (!failed) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failing the routing");
            }
            this.fail(t3);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failure in handling failure");
            }
            this.unhandledFailure(-1, t3, router2);
        }
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router2) {
        int code = statusCode != -1 ? statusCode : (failure instanceof HttpException ? ((HttpException)failure).getStatusCode() : 500);
        Handler<RoutingContext> errorHandler = router2.getErrorHandlerByStatusCode(code);
        if (errorHandler != null) {
            try {
                errorHandler.handle(this);
            }
            catch (Throwable t3) {
                LOG.error("Error in error handler", t3);
            }
        } else {
            LOG.error("Unhandled exception in router", failure);
        }
        if (!this.response().ended() && !this.response().closed()) {
            try {
                this.response().setStatusCode(code);
            }
            catch (IllegalArgumentException e2) {
                this.response().setStatusMessage(HttpResponseStatus.valueOf(code).reasonPhrase()).setStatusCode(code);
            }
            this.response().end(this.response().getStatusMessage());
        }
    }

    private void resetMatchFailure() {
        this.matchFailure = 404;
    }
}

