/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import io.vertx.ext.web.impl.OrderListener;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RouteState;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RouteImpl
implements Route {
    private final RouterImpl router;
    private volatile RouteState state;
    private static final String RE_VAR_NAME = Boolean.getBoolean("io.vertx.web.route.param.extended-pattern") ? "[A-Za-z_$][A-Za-z0-9_$-]*" : "[A-Za-z0-9_]+";
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":(" + RE_VAR_NAME + ")");
    private static final Pattern RE_TOKEN_NAME_SEARCH = Pattern.compile("\\(\\?<(" + RE_VAR_NAME + ")>");
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([\\(\\)\\$\\+\\.])");

    RouteImpl(RouterImpl router2, int order) {
        this.router = router2;
        this.state = new RouteState(this, order);
    }

    RouteImpl(RouterImpl router2, int order, String path2) {
        this(router2, order);
        this.checkPath(path2);
        this.setPath(path2);
    }

    RouteImpl(RouterImpl router2, int order, HttpMethod method, String path2) {
        this(router2, order);
        this.method(method);
        this.checkPath(path2);
        this.setPath(path2);
    }

    RouteImpl(RouterImpl router2, int order, String regex, boolean bregex) {
        this(router2, order);
        this.setRegex(regex);
    }

    RouteImpl(RouterImpl router2, int order, HttpMethod method, String regex, boolean bregex) {
        this(router2, order);
        this.method(method);
        this.setRegex(regex);
    }

    RouteState state() {
        return this.state;
    }

    @Override
    public synchronized Route putMetadata(String key2, Object value) {
        this.state = this.state.putMetadata(key2, value);
        return this;
    }

    @Override
    public synchronized Route method(HttpMethod method) {
        this.state = this.state.addMethod(method);
        return this;
    }

    @Override
    public Route path(String path2) {
        this.checkPath(path2);
        this.setPath(path2);
        return this;
    }

    @Override
    public Route pathRegex(String regex) {
        this.setRegex(regex);
        return this;
    }

    @Override
    public synchronized Route produces(String contentType) {
        this.state = this.state.addProduce(new ParsableMIMEValue(contentType).forceParse());
        return this;
    }

    @Override
    public synchronized Route consumes(String contentType) {
        this.state = this.state.addConsume(new ParsableMIMEValue(contentType).forceParse());
        return this;
    }

    @Override
    public synchronized Route virtualHost(String hostnamePattern) {
        this.state = this.state.setVirtualHostPattern(Pattern.compile(hostnamePattern.replaceAll("\\.", "\\\\.").replaceAll("[*]", "(.*?)"), 2));
        return this;
    }

    @Override
    public synchronized Route order(int order) {
        if (this.state.isAdded()) {
            throw new IllegalStateException("Can't change order after route is active");
        }
        this.state = this.state.setOrder(order);
        return this;
    }

    @Override
    public Route last() {
        return this.order(Integer.MAX_VALUE);
    }

    @Override
    public synchronized Route handler(Handler<RoutingContext> contextHandler) {
        if (this.state.isExclusive()) {
            throw new IllegalStateException("This Route is exclusive for already mounted sub router.");
        }
        this.state = this.state.addContextHandler(contextHandler);
        this.checkAdd();
        if (contextHandler instanceof OrderListener) {
            ((OrderListener)((Object)contextHandler)).onOrder(this.order());
        }
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler) {
        return this.blockingHandler(contextHandler, true);
    }

    @Override
    public synchronized Route subRouter(Router subRouter) {
        if (this.state.getPath() != null && this.state.isExactPath()) {
            throw new IllegalStateException("Sub router cannot be mounted on an exact path.");
        }
        if (this.state.getPath() == null && this.state.getPattern() != null) {
            throw new IllegalStateException("Sub router cannot be mounted on a regular expression path.");
        }
        if (this.state.isExclusive()) {
            throw new IllegalStateException("Only one sub router per Route object is allowed.");
        }
        this.handler(subRouter::handleContext);
        this.failureHandler(subRouter::handleFailure);
        subRouter.modifiedHandler(this::validateMount);
        this.validateMount(subRouter);
        this.state = this.state.setExclusive(true);
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler, boolean ordered) {
        return this.handler(new BlockingHandlerDecorator(contextHandler, ordered));
    }

    @Override
    public synchronized Route failureHandler(Handler<RoutingContext> exceptionHandler) {
        if (this.state.isExclusive()) {
            throw new IllegalStateException("This Route is exclusive for already mounted sub router.");
        }
        this.state = this.state.addFailureHandler(exceptionHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public Route remove() {
        this.router.remove(this);
        return this;
    }

    @Override
    public synchronized Route disable() {
        this.state = this.state.setEnabled(false);
        return this;
    }

    @Override
    public synchronized Route enable() {
        this.state = this.state.setEnabled(true);
        return this;
    }

    @Override
    public synchronized Route useNormalizedPath(boolean useNormalizedPath) {
        this.state = this.state.setUseNormalizedPath(useNormalizedPath);
        return this;
    }

    @Override
    public Map<String, Object> metadata() {
        Map<String, Object> metadata2 = this.state.getMetadata();
        return metadata2 != null ? metadata2 : Collections.emptyMap();
    }

    @Override
    public String getPath() {
        return this.state.getPath();
    }

    @Override
    public boolean isRegexPath() {
        return this.state.getPattern() != null;
    }

    @Override
    public boolean isExactPath() {
        return this.state.isExactPath();
    }

    @Override
    public Set<HttpMethod> methods() {
        return this.state.getMethods();
    }

    @Override
    public synchronized Route setRegexGroupsNames(List<String> groups2) {
        this.state = this.state.setGroups(groups2);
        return this;
    }

    @Override
    public synchronized Route setName(String name2) {
        this.state = this.state.setName(name2);
        return this;
    }

    @Override
    public String getName() {
        return this.state.getName();
    }

    public String toString() {
        return "RouteImpl@" + System.identityHashCode(this) + "{state=" + this.state + '}';
    }

    RouterImpl router() {
        return this.router;
    }

    private synchronized void setPath(String path2) {
        int found;
        if (path2.charAt(path2.length() - 1) != '*') {
            this.state = this.state.setExactPath(true);
            this.state = this.state.setPath(path2);
        } else {
            this.state = this.state.setExactPath(false);
            this.state = this.state.setPath(path2.substring(0, path2.length() - 1));
        }
        this.state = this.state.setPathEndsWithSlash(this.state.getPath().endsWith("/"));
        int params = 0;
        for (int i = 0; i < path2.length(); ++i) {
            if (path2.charAt(i) != ':') continue;
            ++params;
        }
        if (params > 0 && params != (found = this.createPatternRegex(path2))) {
            throw new IllegalArgumentException("path param does not follow the variable naming rules, expected (" + params + ") found (" + found + ")");
        }
    }

    private synchronized void setRegex(String regex) {
        this.state = this.state.setPattern(Pattern.compile(regex));
        this.state = this.state.setExactPath(true);
        this.findNamedGroups(this.state.getPattern().pattern());
    }

    private synchronized void findNamedGroups(String path2) {
        Matcher m4 = RE_TOKEN_NAME_SEARCH.matcher(path2);
        while (m4.find()) {
            this.state = this.state.addNamedGroupInRegex(m4.group(1));
        }
    }

    private synchronized int createPatternRegex(String path2) {
        if ((path2 = RE_OPERATORS_NO_STAR.matcher(path2).replaceAll("\\\\$1")).charAt(path2.length() - 1) == '*') {
            path2 = path2.substring(0, path2.length() - 1) + "(?<rest>.*)";
            this.state = this.state.setExactPath(false);
        } else {
            this.state = this.state.setExactPath(true);
        }
        Matcher m4 = RE_TOKEN_SEARCH.matcher(path2);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> groups2 = new ArrayList<String>();
        int index2 = 0;
        while (m4.find()) {
            String param = "p" + index2;
            String group = m4.group().substring(1);
            if (groups2.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m4.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            groups2.add(group);
            ++index2;
        }
        m4.appendTail(sb);
        if (this.state.isExactPath() && !this.state.isPathEndsWithSlash()) {
            sb.append("/?");
        }
        path2 = sb.toString();
        this.state = this.state.setGroups(groups2);
        this.state = this.state.setPattern(Pattern.compile(path2));
        return index2;
    }

    private void checkPath(String path2) {
        if ("".equals(path2) || path2.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with /");
        }
    }

    int order() {
        return this.state.getOrder();
    }

    private synchronized void checkAdd() {
        if (!this.state.isAdded()) {
            this.router.add(this);
            this.state = this.state.setAdded(true);
        }
    }

    public synchronized RouteImpl setEmptyBodyPermittedWithConsumes(boolean emptyBodyPermittedWithConsumes) {
        this.state = this.state.setEmptyBodyPermittedWithConsumes(emptyBodyPermittedWithConsumes);
        return this;
    }

    private void validateMount(Router router2) {
        for (Route route : router2.getRoutes()) {
            if (route.getPath() == null) continue;
            String combinedPath = RE_OPERATORS_NO_STAR.matcher(this.state.getPath() + (this.state.isPathEndsWithSlash() ? route.getPath().substring(1) : route.getPath())).replaceAll("\\\\$1");
            Matcher m4 = RE_TOKEN_SEARCH.matcher(combinedPath);
            HashSet<String> groups2 = new HashSet<String>();
            while (m4.find()) {
                String group = m4.group();
                if (groups2.contains(group)) {
                    throw new IllegalStateException("Cannot use identifier " + group + " more than once in pattern string");
                }
                groups2.add(group);
            }
        }
    }
}

