/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;

public final class Origin {
    private static final Logger LOG = LoggerFactory.getLogger(Origin.class);
    private static final String DEFAULT_FTP_PORT = "21";
    private static final String DEFAULT_HTTP_PORT = "80";
    private static final String DEFAULT_HTTPS_PORT = "443";
    private final String protocol;
    private final String host;
    private final int port;
    private final String resource;
    private final boolean isNull;
    private final String base;
    private final String BASE;
    private final String optional;

    private Origin(String protocol2, String host, String port, String resource2) {
        char c;
        int i;
        String defaultPort;
        if (protocol2 == null && host == null && port == null && resource2 == null) {
            this.protocol = null;
            this.host = null;
            this.port = -1;
            this.resource = null;
            this.isNull = true;
            this.base = null;
            this.BASE = null;
            this.optional = null;
            return;
        }
        this.isNull = false;
        if (protocol2 == null) {
            throw new IllegalStateException("Unsupported protocol: null");
        }
        switch (protocol2.toLowerCase()) {
            case "ftp": {
                this.protocol = protocol2;
                defaultPort = DEFAULT_FTP_PORT;
                break;
            }
            case "http": {
                this.protocol = protocol2;
                defaultPort = DEFAULT_HTTP_PORT;
                break;
            }
            case "https": {
                this.protocol = protocol2;
                defaultPort = DEFAULT_HTTPS_PORT;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported protocol: " + protocol2);
            }
        }
        if (host == null) {
            throw new IllegalStateException("Null host not allowed");
        }
        boolean ipv6 = false;
        block15: for (i = 0; i < host.length(); ++i) {
            c = host.charAt(i);
            switch (c) {
                case '[': {
                    if (i == 0) {
                        ipv6 = true;
                        continue block15;
                    }
                    throw new IllegalStateException("Illegal character in hostname: " + host);
                }
                case ']': {
                    if (ipv6 && i == host.length() - 1) continue block15;
                    throw new IllegalStateException("Illegal character in hostname: " + host);
                }
                case ':': {
                    if (ipv6) continue block15;
                    throw new IllegalStateException("Illegal character in hostname: " + host);
                }
                default: {
                    if (Character.isLetterOrDigit(c) || c == '.' || c == '-') continue block15;
                    throw new IllegalStateException("Illegal character in hostname: " + host);
                }
            }
        }
        this.host = host;
        if (port != null) {
            for (i = 0; i < port.length(); ++i) {
                c = port.charAt(i);
                if (Character.isDigit(c)) continue;
                throw new IllegalStateException("Illegal character in port: " + port);
            }
            this.port = Integer.parseInt(port);
        } else {
            this.port = Integer.parseInt(defaultPort);
        }
        this.resource = resource2;
        if (port == null) {
            this.base = protocol2 + "://" + host;
            this.optional = ":" + defaultPort;
        } else {
            this.base = protocol2 + "://" + host + ":" + port;
            this.optional = "";
        }
        this.BASE = this.base.toUpperCase();
    }

    public static Origin parse(String text) {
        if (text.length() == 4 && "null".equals(text)) {
            return new Origin(null, null, null, null);
        }
        int sep0 = text.indexOf("://");
        if (sep0 > 0) {
            String protocol2 = text.substring(0, sep0);
            int sep1 = -1;
            if (text.charAt(sep0 + 3) == '[') {
                int endHost = text.indexOf(93, sep0 + 3);
                if (endHost != -1) {
                    sep1 = text.indexOf(58, endHost);
                }
            } else {
                sep1 = text.indexOf(58, sep0 + 3);
            }
            int sep2 = text.indexOf(47, Math.max(sep0 + 3, sep1 + 1));
            if (sep1 == -1 && sep2 == -1) {
                return new Origin(protocol2, text.substring(sep0 + 3), null, null);
            }
            if (sep1 != -1 && sep2 == -1) {
                return new Origin(protocol2, text.substring(sep0 + 3, sep1), text.substring(sep1 + 1), null);
            }
            if (sep1 == -1) {
                return new Origin(protocol2, text.substring(sep0 + 3, sep2), null, text.substring(sep2));
            }
            return new Origin(protocol2, text.substring(sep0 + 3, sep1), text.substring(sep1 + 1, sep2), text.substring(sep2));
        }
        throw new IllegalStateException("Invalid Origin, expected <protocol>://<domain>[:<port>][</resource>]");
    }

    public static boolean isValid(String text) {
        if (text.length() == 4 && "null".equals(text)) {
            return true;
        }
        int sep0 = text.indexOf("://");
        if (sep0 > 0) {
            String protocol2 = text.substring(0, sep0);
            switch (protocol2.toLowerCase()) {
                case "ftp": 
                case "http": 
                case "https": {
                    break;
                }
                default: {
                    return false;
                }
            }
            int sep1 = -1;
            if (text.charAt(sep0 + 3) == '[') {
                int endHost = text.indexOf(93, sep0 + 3);
                if (endHost != -1) {
                    sep1 = text.indexOf(58, endHost);
                }
            } else {
                sep1 = text.indexOf(58, sep0 + 3);
            }
            int sep2 = text.indexOf(47, Math.max(sep0 + 3, sep1 + 1));
            if (sep1 == -1 && sep2 == -1) {
                return Origin.check(text.substring(sep0 + 3), null);
            }
            if (sep1 != -1 && sep2 == -1) {
                return Origin.check(text.substring(sep0 + 3, sep1), text.substring(sep1 + 1));
            }
            if (sep1 == -1) {
                return Origin.check(text.substring(sep0 + 3, sep2), null);
            }
            return Origin.check(text.substring(sep0 + 3, sep1), text.substring(sep1 + 1, sep2));
        }
        return false;
    }

    private static boolean check(String host, String port) {
        char c;
        int i;
        if (host == null) {
            return false;
        }
        boolean ipv6 = false;
        block5: for (i = 0; i < host.length(); ++i) {
            c = host.charAt(i);
            switch (c) {
                case '[': {
                    if (i == 0) {
                        ipv6 = true;
                        continue block5;
                    }
                    return false;
                }
                case ']': {
                    if (ipv6 && i == host.length() - 1) continue block5;
                    return false;
                }
                case ':': {
                    if (ipv6) continue block5;
                    return false;
                }
                default: {
                    if (Character.isLetterOrDigit(c) || c == '.' || c == '-') continue block5;
                    return false;
                }
            }
        }
        if (port != null) {
            for (i = 0; i < port.length(); ++i) {
                c = port.charAt(i);
                if (Character.isDigit(c)) continue;
                return false;
            }
        }
        return true;
    }

    public String protocol() {
        return this.protocol;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String resource() {
        return this.resource;
    }

    public boolean sameOrigin(String other) {
        char c;
        int i;
        if (this.isNull) {
            return "null".equals(other);
        }
        int offset = 0;
        int len = other.length();
        if (this.base.length() > len) {
            return false;
        }
        for (i = 0; i < this.base.length(); ++i) {
            c = other.charAt(offset + i);
            if (c == this.base.charAt(i) || c == this.BASE.charAt(i)) continue;
            return false;
        }
        offset += this.base.length();
        if ((len -= this.base.length()) > 0) {
            if (other.charAt(offset) == ':') {
                if (this.optional.length() > len) {
                    return false;
                }
                for (i = 0; i < this.optional.length(); ++i) {
                    c = other.charAt(offset + i);
                    if (c == this.optional.charAt(i)) continue;
                    return false;
                }
                offset += this.optional.length();
                len -= this.optional.length();
            }
            if (len > 0) {
                return other.charAt(offset) == '/';
            }
        }
        return true;
    }

    public @Nullable String encode() {
        if (this.isNull) {
            return "<null>";
        }
        switch (this.protocol) {
            case "http": {
                return this.protocol + "://" + this.host + (this.port == 80 ? "" : ":" + this.port);
            }
            case "https": {
                return this.protocol + "://" + this.host + (this.port == 443 ? "" : ":" + this.port);
            }
            case "ftp": {
                return this.protocol + "://" + this.host + (this.port == 21 ? "" : ":" + this.port);
            }
        }
        return null;
    }

    public String toString() {
        if (this.isNull) {
            return "null";
        }
        return this.base;
    }

    public String href() {
        if (this.isNull) {
            return "null";
        }
        return this.base + (this.resource == null ? "/" : this.resource);
    }

    private static boolean isBlank(String s2) {
        return s2 == null || s2.trim().isEmpty();
    }

    public static boolean check(Origin origin, RoutingContext ctx) {
        if (origin != null) {
            String source2 = ctx.request().getHeader(HttpHeaders.ORIGIN);
            if (Origin.isBlank(source2) && Origin.isBlank(source2 = ctx.request().getHeader(HttpHeaders.REFERER))) {
                LOG.trace("ORIGIN and REFERER request headers are both absent/empty");
                return false;
            }
            if (!origin.sameOrigin(source2)) {
                LOG.trace("Protocol/Host/Port do not fully match");
                return false;
            }
        }
        return true;
    }
}

