/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.SecurityPolicyHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import java.util.Arrays;

class XhrTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(XhrTransport.class);
    private static final Buffer H_BLOCK;
    private final Handler<SockJSSocket> sockHandler;

    XhrTransport(Vertx vertx, Router router2, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options2, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options2);
        this.sockHandler = sockHandler;
        String xhrBase = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";
        String xhrRE = xhrBase + "xhr";
        String xhrStreamRE = xhrBase + "xhr_streaming";
        SecurityPolicyHandler xhrOptionsHandler = XhrTransport.createCORSOptionsHandler(options2, "OPTIONS, POST");
        router2.optionsWithRegex(xhrRE).handler(xhrOptionsHandler);
        router2.optionsWithRegex(xhrStreamRE).handler(xhrOptionsHandler);
        router2.postWithRegex(xhrRE).handler(this::handlePostPolling);
        router2.postWithRegex(xhrStreamRE).handler(this::handlePostStreaming);
        String xhrSendRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/xhr_send";
        router2.optionsWithRegex(xhrSendRE).handler(xhrOptionsHandler);
        router2.postWithRegex(xhrSendRE).handler(this::handlePost);
    }

    private void handlePost(RoutingContext ctx) {
        String sessionID = ctx.request().getParam("param0");
        SockJSSession session = (SockJSSession)this.sessions.get(sessionID);
        if (session != null && !session.isClosed()) {
            this.handleSend(ctx, session);
        } else {
            ctx.response().setStatusCode(404);
            XhrTransport.setJSESSIONID(this.options, ctx);
            ctx.response().end();
        }
    }

    private void handlePostStreaming(RoutingContext ctx) {
        XhrTransport.setNoCacheHeaders(ctx);
        String sessionID = ctx.request().getParam("param0");
        SockJSSession session = this.getSession(ctx, this.options, sessionID, this.sockHandler);
        HttpServerRequest req = ctx.request();
        session.register(req, new XhrStreamingListener(this.options.getMaxBytesStreaming(), ctx, session));
    }

    private void handlePostPolling(RoutingContext ctx) {
        XhrTransport.setNoCacheHeaders(ctx);
        String sessionID = ctx.request().getParam("param0");
        SockJSSession session = this.getSession(ctx, this.options, sessionID, this.sockHandler);
        HttpServerRequest req = ctx.request();
        session.register(req, new XhrPollingListener(ctx, session));
    }

    private void handleSend(RoutingContext rc, SockJSSession session) {
        RequestBody body = rc.body();
        if (!body.available()) {
            LOG.error("No BodyHandler was executed on the route. Please add a BodyHandler before the SockJS handler.");
            rc.fail(500, new NoStackTraceThrowable("BodyHandler is required to process POST requests"));
            return;
        }
        if (body.length() <= 0) {
            rc.response().setStatusCode(500).end("Payload expected.");
            return;
        }
        if (!session.handleMessages(body.asString())) {
            this.sendInvalidJSON(rc.response());
        } else {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=UTF-8");
            XhrTransport.setNoCacheHeaders(rc);
            XhrTransport.setJSESSIONID(this.options, rc);
            XhrTransport.setCORSIfNeeded(rc);
            rc.response().setStatusCode(204).end();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("XHR send processed ok");
        }
    }

    static {
        byte[] bytes2 = new byte[2049];
        Arrays.fill(bytes2, 0, 2048, (byte)104);
        bytes2[bytes2.length - 1] = 10;
        H_BLOCK = Buffer.buffer(bytes2);
    }

    private class XhrStreamingListener
    extends BaseXhrListener {
        int bytesSent;
        final int maxBytesStreaming;

        XhrStreamingListener(int maxBytesStreaming, RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            boolean hr = this.headersWritten;
            super.beforeSend();
            if (!hr) {
                this.rc.response().write(H_BLOCK);
            }
            String sbody = body + "\n";
            Buffer buff = Buffer.buffer(sbody);
            this.rc.response().write(buff, handler);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                this.close();
            }
        }

        @Override
        public void close() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("XHR stream closing listener");
            }
            if (!this.closed) {
                this.session.resetListener();
                try {
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private class XhrPollingListener
    extends BaseXhrListener {
        XhrPollingListener(RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            super.beforeSend();
            this.rc.response().write(body + "\n", handler);
            this.close();
        }

        @Override
        public void close() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("XHR poll closing listener");
            }
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private abstract class BaseXhrListener
    extends BaseTransport.BaseListener {
        boolean headersWritten;

        BaseXhrListener(RoutingContext rc, SockJSSession session) {
            super(rc, session);
        }

        final void beforeSend() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("XHR sending frame");
            }
            if (!this.headersWritten) {
                HttpServerResponse resp = this.rc.response();
                resp.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/javascript; charset=UTF-8");
                BaseTransport.setJSESSIONID(XhrTransport.this.options, this.rc);
                BaseTransport.setCORSIfNeeded(this.rc);
                if (this.rc.request().version() != HttpVersion.HTTP_1_0) {
                    resp.setChunked(true);
                }
                this.headersWritten = true;
            }
        }

        @Override
        public void close() {
        }
    }
}

