/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.Utils;

class RawWebSocketTransport {
    private final Origin origin;
    private final Vertx vertx;
    private final SockJSHandlerOptions options;
    private final Handler<SockJSSocket> sockHandler;

    RawWebSocketTransport(Vertx vertx, Router router2, SockJSHandlerOptions options2, Handler<SockJSSocket> sockHandler) {
        this.vertx = vertx;
        this.options = options2;
        this.origin = options2.getOrigin() != null ? Origin.parse(options2.getOrigin()) : null;
        this.sockHandler = sockHandler;
        router2.get("/websocket").handler(this::handleGet);
        router2.route("/websocket").handler(rc -> rc.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"GET").setStatusCode(405).end());
    }

    private void handleGet(RoutingContext ctx) {
        HttpServerRequest req = ctx.request();
        if (!Utils.canUpgradeToWebsocket(req)) {
            ctx.response().setStatusCode(400);
            ctx.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            return;
        }
        if (!Origin.check(this.origin, ctx)) {
            ctx.fail(403, new IllegalStateException("Invalid Origin"));
            return;
        }
        req.toWebSocket().onFailure(ctx::fail).onSuccess(socket -> {
            RawWSSockJSSocket sock = new RawWSSockJSSocket(this.vertx, ctx, this.options, (ServerWebSocket)socket);
            this.sockHandler.handle(sock);
        });
    }

    private static class RawWSSockJSSocket
    extends SockJSSocketBase {
        final ServerWebSocket ws;
        MultiMap headers;
        boolean closed;

        RawWSSockJSSocket(Vertx vertx, RoutingContext rc, SockJSHandlerOptions options2, ServerWebSocket ws) {
            super(vertx, rc, options2);
            this.ws = ws;
            ws.closeHandler(v -> {
                RawWSSockJSSocket rawWSSockJSSocket = this;
                synchronized (rawWSSockJSSocket) {
                    this.closed = true;
                }
                RawWSSockJSSocket.super.close();
            });
        }

        @Override
        public SockJSSocket handler(Handler<Buffer> handler) {
            this.ws.binaryMessageHandler(handler);
            this.ws.textMessageHandler(textMessage -> handler.handle(Buffer.buffer(textMessage)));
            return this;
        }

        @Override
        public SockJSSocket pause() {
            this.ws.pause();
            return this;
        }

        @Override
        public SockJSSocket resume() {
            this.ws.resume();
            return this;
        }

        @Override
        public SockJSSocket fetch(long amount) {
            this.ws.fetch(amount);
            return this;
        }

        @Override
        public Future<Void> write(Buffer data2) {
            if (!this.closed) {
                return this.ws.writeBinaryMessage(data2);
            }
            PromiseInternal promise2 = ((VertxInternal)this.vertx).promise();
            this.vertx.runOnContext(v -> promise2.fail(ConnectionBase.CLOSED_EXCEPTION));
            return promise2.future();
        }

        @Override
        public Future<Void> write(String data2) {
            if (!this.closed) {
                return this.ws.writeTextMessage(data2);
            }
            PromiseInternal promise2 = ((VertxInternal)this.vertx).promise();
            this.vertx.runOnContext(v -> promise2.fail(ConnectionBase.CLOSED_EXCEPTION));
            return promise2.future();
        }

        @Override
        public SockJSSocket setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
            return this;
        }

        @Override
        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public SockJSSocket drainHandler(Handler<Void> handler) {
            this.ws.drainHandler((Handler)handler);
            return this;
        }

        @Override
        public SockJSSocket exceptionHandler(Handler<Throwable> handler) {
            this.ws.exceptionHandler((Handler)handler);
            return this;
        }

        @Override
        public SockJSSocket endHandler(Handler<Void> endHandler) {
            this.ws.endHandler((Handler)endHandler);
            return this;
        }

        @Override
        public SockJSSocket closeHandler(Handler<Void> closeHandler) {
            this.ws.closeHandler((Handler)closeHandler);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close();
        }

        @Override
        public void closeAfterSessionExpired() {
            this.close(1001, "Session expired");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(int statusCode, String reason) {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close((short)statusCode, reason);
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.ws.remoteAddress();
        }

        @Override
        public SocketAddress localAddress() {
            return this.ws.localAddress();
        }

        @Override
        public MultiMap headers() {
            if (this.headers == null) {
                this.headers = BaseTransport.removeCookieHeaders(this.ws.headers());
            }
            return this.headers;
        }

        @Override
        public String uri() {
            return this.ws.uri();
        }
    }
}

