/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import java.util.regex.Pattern;

class JsonPTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPTransport.class);
    private static final Pattern CALLBACK_VALIDATION = Pattern.compile("[^a-zA-Z0-9-_.]");
    private final Handler<SockJSSocket> sockHandler;

    JsonPTransport(Vertx vertx, Router router2, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options2, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options2);
        this.sockHandler = sockHandler;
        String jsonpRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/jsonp";
        router2.getWithRegex(jsonpRE).handler(this::handleGet);
        String jsonpSendRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/jsonp_send";
        router2.postWithRegex(jsonpSendRE).handler(this::handlePost);
    }

    private void handleGet(RoutingContext ctx) {
        String callback = ctx.request().getParam("callback");
        if (callback == null && (callback = ctx.request().getParam("c")) == null) {
            ctx.response().setStatusCode(500);
            ctx.response().end("\"callback\" parameter required\n");
            return;
        }
        if (callback.length() > 32 || CALLBACK_VALIDATION.matcher(callback).find()) {
            ctx.response().setStatusCode(500);
            ctx.response().end("invalid \"callback\" parameter\n");
            return;
        }
        HttpServerRequest req = ctx.request();
        String sessionID = req.params().get("param0");
        SockJSSession session = this.getSession(ctx, this.options, sessionID, this.sockHandler);
        session.register(req, new JsonPListener(ctx, session, callback));
    }

    private void handlePost(RoutingContext ctx) {
        String sessionID = ctx.request().getParam("param0");
        SockJSSession session = (SockJSSession)this.sessions.get(sessionID);
        if (session != null && !session.isClosed()) {
            this.handleSend(ctx, session);
        } else {
            ctx.response().setStatusCode(404);
            JsonPTransport.setJSESSIONID(this.options, ctx);
            ctx.response().end();
        }
    }

    private void handleSend(RoutingContext rc, SockJSSession session) {
        boolean urlEncoded;
        RequestBody body = rc.body();
        if (!body.available()) {
            rc.fail(500, new NoStackTraceThrowable("BodyHandler is required to process POST requests"));
            return;
        }
        String ct = rc.request().getHeader(HttpHeaders.CONTENT_TYPE);
        if ("application/x-www-form-urlencoded".equalsIgnoreCase(ct)) {
            urlEncoded = true;
        } else if ("text/plain".equalsIgnoreCase(ct)) {
            urlEncoded = false;
        } else {
            rc.response().setStatusCode(500);
            rc.response().end("Invalid Content-Type");
            return;
        }
        String stringBody = body.asString();
        if (body.length() <= 0 || urlEncoded && (body.length() <= 2 || !stringBody.startsWith("d="))) {
            rc.response().setStatusCode(500).end("Payload expected.");
            return;
        }
        if (urlEncoded) {
            stringBody = URIDecoder.decodeURIComponent(stringBody, true).substring(2);
        }
        if (!session.handleMessages(stringBody)) {
            this.sendInvalidJSON(rc.response());
        } else {
            JsonPTransport.setJSESSIONID(this.options, rc);
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=UTF-8");
            JsonPTransport.setNoCacheHeaders(rc);
            rc.response().end("ok");
            if (LOG.isTraceEnabled()) {
                LOG.trace("send handled ok");
            }
        }
    }

    private class JsonPListener
    extends BaseTransport.BaseListener {
        final String callback;
        boolean headersWritten;

        JsonPListener(RoutingContext rc, SockJSSession session, String callback) {
            super(rc, session);
            this.callback = callback;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("JsonP, sending frame");
            }
            if (!this.headersWritten) {
                this.rc.response().setChunked(true).putHeader("X-Content-Type-Options", "nosniff").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/javascript; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.rc);
                BaseTransport.setJSESSIONID(JsonPTransport.this.options, this.rc);
                this.headersWritten = true;
            }
            body = JsonPTransport.this.escapeForJavaScript(body);
            String sb = "/**/" + this.callback + "(\"" + body + "\");\r\n";
            this.rc.response().write(sb, handler);
            this.close();
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

